/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.salesforce;

import com.sforce.soap.partner.LoginResult;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cxf.jaxrs.client.WebClient;
import org.teiid.OAuthCredential;
import org.teiid.resource.adapter.salesforce.transport.SalesforceConnectorConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TeiidPartnerConnection
extends PartnerConnection {
    private static final String AUTHORIZATION = "Authorization";

    public TeiidPartnerConnection(SalesforceConnectorConfig config) throws ConnectionException {
        super((ConnectorConfig)config);
    }

    public LoginResult login(String username, String password) throws ConnectionException {
        SalesforceConnectorConfig config = (SalesforceConnectorConfig)this.getConfig();
        if (config.getCredential(OAuthCredential.class.getName()) == null) {
            return super.login(username, password);
        }
        OAuthCredential credential = (OAuthCredential)config.getCredential(OAuthCredential.class.getName());
        String id = credential.getAuthrorizationProperty("id");
        if (id == null) {
            throw new ConnectionException("Failed to get OAuth based connection");
        }
        String accessToken = credential.getAuthorizationHeader(null, "POST");
        LoginResult loginResult = null;
        WebClient client = WebClient.create((String)id);
        client.header(AUTHORIZATION, new Object[]{accessToken});
        String response = (String)client.get(String.class);
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(new ByteArrayInputStream(response.getBytes()));
            doc.getDocumentElement().normalize();
            Element urls = (Element)doc.getDocumentElement().getElementsByTagName("urls").item(0);
            loginResult = new LoginResult();
            loginResult.setSessionId(accessToken.substring(7));
            String endpoint = config.getAuthEndpoint();
            int index = endpoint.indexOf("Soap/u/");
            String apiVersion = endpoint.substring(index + 7);
            String partnerURL = urls.getElementsByTagName("partner").item(0).getTextContent();
            partnerURL = partnerURL.replace("{version}", apiVersion);
            loginResult.setServerUrl(partnerURL);
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to get OAuth based connection; Failed to get user information", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new ConnectionException("Failed to get OAuth based connection; Failed to get user information", (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new ConnectionException("Failed to get OAuth based connection; Failed to get user information", (Throwable)e);
        }
        catch (SAXException e) {
            throw new ConnectionException("Failed to get OAuth based connection; Failed to get user information", (Throwable)e);
        }
        return loginResult;
    }
}

