/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.solr;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.language.Command;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.resource.api.ConnectionFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.solr.SolrConnection;
import org.teiid.translator.solr.SolrMetadataProcessor;
import org.teiid.translator.solr.SolrPlugin;
import org.teiid.translator.solr.SolrQueryExecution;
import org.teiid.translator.solr.SolrUpdateExecution;

@Translator(name="solr", description="A translator for Solr search platform")
public class SolrExecutionFactory
extends ExecutionFactory<ConnectionFactory, SolrConnection> {
    protected Map<String, FunctionModifier> functionModifiers = new TreeMap<String, FunctionModifier>(String.CASE_INSENSITIVE_ORDER);

    public SolrExecutionFactory() {
        this.setSourceRequiredForMetadata(true);
        this.setTransactionSupport(ExecutionFactory.TransactionSupport.NONE);
        this.registerFunctionModifier("%", (FunctionModifier)new AliasModifier("mod"));
        this.registerFunctionModifier("+", (FunctionModifier)new AliasModifier("sum"));
        this.registerFunctionModifier("-", (FunctionModifier)new AliasModifier("sub"));
        this.registerFunctionModifier("*", (FunctionModifier)new AliasModifier("product"));
        this.registerFunctionModifier("/", (FunctionModifier)new AliasModifier("div"));
        this.registerFunctionModifier("power", (FunctionModifier)new AliasModifier("pow"));
        this.setMaxInCriteriaSize(1024);
    }

    public void start() throws TranslatorException {
        super.start();
    }

    public MetadataProcessor<SolrConnection> getMetadataProcessor() {
        return new SolrMetadataProcessor();
    }

    public void registerFunctionModifier(String name, FunctionModifier modifier) {
        this.functionModifiers.put(name, modifier);
    }

    public Map<String, FunctionModifier> getFunctionModifiers() {
        return this.functionModifiers;
    }

    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(this.getDefaultSupportedFunctions());
        supportedFunctions.add("mod");
        supportedFunctions.add("power");
        supportedFunctions.add("abs");
        supportedFunctions.add("log");
        supportedFunctions.add("sqrt");
        return supportedFunctions;
    }

    public List<String> getDefaultSupportedFunctions() {
        return Arrays.asList("+", "-", "*", "/", "%");
    }

    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, SolrConnection connection) throws TranslatorException {
        return new SolrQueryExecution(this, (Command)command, executionContext, metadata, connection);
    }

    public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, SolrConnection connection) throws TranslatorException {
        return new SolrUpdateExecution(this, command, executionContext, metadata, connection);
    }

    public Object convertFromSolrType(Object value, Class<?> expectedType) {
        if (value == null) {
            return null;
        }
        if (expectedType.isInstance(value)) {
            return value;
        }
        try {
            if (expectedType.isArray()) {
                ArrayList multiValues = (ArrayList)value;
                Object transformed = Array.newInstance(expectedType.getComponentType(), multiValues.size());
                for (int i = 0; i < multiValues.size(); ++i) {
                    Object obj = multiValues.get(i);
                    if (obj == null) {
                        Array.set(transformed, i, obj);
                        continue;
                    }
                    if (expectedType.getComponentType().isInstance(obj)) {
                        Array.set(transformed, i, obj);
                        continue;
                    }
                    if (DataTypeManager.isTransformable(obj.getClass(), expectedType.getComponentType())) {
                        Array.set(transformed, i, DataTypeManager.transformValue(obj, expectedType.getComponentType()));
                        continue;
                    }
                    throw new TeiidRuntimeException((BundleUtil.Event)SolrPlugin.Event.TEIID20001, SolrPlugin.Util.gs((BundleUtil.Event)SolrPlugin.Event.TEIID20001, new Object[]{value, expectedType.getName()}));
                }
                return transformed;
            }
            if (DataTypeManager.isTransformable(value.getClass(), expectedType)) {
                return DataTypeManager.transformValue((Object)value, expectedType);
            }
            throw new TeiidRuntimeException((BundleUtil.Event)SolrPlugin.Event.TEIID20001, SolrPlugin.Util.gs((BundleUtil.Event)SolrPlugin.Event.TEIID20001, new Object[]{value, expectedType.getName()}));
        }
        catch (TransformationException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    public boolean supportsCompareCriteriaEquals() {
        return true;
    }

    public boolean supportsInCriteria() {
        return true;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsNotCriteria() {
        return true;
    }

    public boolean supportsLikeCriteria() {
        return true;
    }

    public boolean supportsOrderBy() {
        return true;
    }

    public boolean supportsCompareCriteriaOrdered() {
        return true;
    }

    public boolean supportsOrCriteria() {
        return true;
    }

    public boolean supportsOnlyLiteralComparison() {
        return true;
    }

    public boolean supportsOrderByUnrelated() {
        return true;
    }

    public boolean supportsSelectExpression() {
        return true;
    }

    public boolean supportsBulkUpdate() {
        return true;
    }

    public boolean supportsAggregatesCountStar() {
        return true;
    }

    public boolean returnsSingleUpdateCount() {
        return true;
    }
}

