/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.solr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.teiid.language.Command;
import org.teiid.language.LanguageObject;
import org.teiid.language.QueryExpression;
import org.teiid.logging.LogManager;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.solr.SolrConnection;
import org.teiid.translator.solr.SolrExecutionFactory;
import org.teiid.translator.solr.SolrSQLHierarchyVistor;

public class SolrQueryExecution
implements ResultSetExecution {
    private ExecutionContext executionContext;
    private SolrConnection connection;
    private SolrSQLHierarchyVistor visitor;
    private Iterator<SolrDocument> resultsItr;
    private Class<?>[] expectedTypes;
    private SolrExecutionFactory executionFactory;
    private int offset = 0;
    private Long resultSize;

    public SolrQueryExecution(SolrExecutionFactory ef, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, SolrConnection connection) {
        this.executionFactory = ef;
        this.executionContext = executionContext;
        this.connection = connection;
        if (command instanceof QueryExpression) {
            this.expectedTypes = ((QueryExpression)command).getColumnTypes();
        }
        this.visitor = new SolrSQLHierarchyVistor(metadata, this.executionFactory);
        this.visitor.visitNode((LanguageObject)command);
    }

    public void execute() throws TranslatorException {
        LogManager.logDetail((String)"Solr Source Query:", (Object)this.visitor.getSolrQuery());
        this.nextBatch();
    }

    public void nextBatch() throws TranslatorException {
        SolrQuery query = this.visitor.getSolrQuery();
        if (!this.visitor.isLimitInUse()) {
            query.setStart(Integer.valueOf(this.offset));
            query.setRows(Integer.valueOf(this.executionContext.getBatchSize()));
        }
        QueryResponse queryResponse = this.connection.query(this.visitor.getSolrQuery());
        SolrDocumentList docList = queryResponse.getResults();
        this.resultSize = docList.getNumFound();
        this.resultsItr = docList.iterator();
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        ArrayList<Object> row = new ArrayList<Object>();
        if (this.visitor.isCountStarInUse() && this.resultsItr != null) {
            row.add(this.resultSize);
            this.resultsItr = null;
            return row;
        }
        if (this.resultsItr != null && this.resultsItr.hasNext()) {
            SolrDocument doc = this.resultsItr.next();
            for (int i = 0; i < this.visitor.getFieldNameList().size(); ++i) {
                String columnName = this.visitor.getFieldNameList().get(i);
                Object obj = doc.getFieldValue(columnName);
                row.add(this.executionFactory.convertFromSolrType(obj, this.expectedTypes[i]));
            }
            ++this.offset;
            if (!this.resultsItr.hasNext() && !this.visitor.isLimitInUse()) {
                this.nextBatch();
            }
            return row;
        }
        return null;
    }

    public void walkDocuments(SolrDocumentCallback callback) throws TranslatorException {
        while (this.resultsItr != null && this.resultsItr.hasNext()) {
            SolrDocument doc = this.resultsItr.next();
            callback.walk(doc);
            ++this.offset;
            if (this.resultsItr.hasNext()) continue;
            this.nextBatch();
        }
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }

    static interface SolrDocumentCallback {
        public void walk(SolrDocument var1);
    }
}

