/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.solr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.teiid.core.BundleUtil;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.Delete;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Expression;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Insert;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.Select;
import org.teiid.language.SetClause;
import org.teiid.language.Update;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.solr.SolrConnection;
import org.teiid.translator.solr.SolrExecutionFactory;
import org.teiid.translator.solr.SolrPlugin;
import org.teiid.translator.solr.SolrQueryExecution;
import org.teiid.translator.solr.SolrSQLHierarchyVistor;

public class SolrUpdateExecution
implements UpdateExecution {
    private SolrExecutionFactory ef;
    private SolrConnection connection;
    private Command command;
    private int updateCount = 0;
    private RuntimeMetadata metadata;
    private ExecutionContext executionContext;

    public SolrUpdateExecution(SolrExecutionFactory ef, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, SolrConnection connection) {
        this.ef = ef;
        this.command = command;
        this.connection = connection;
        this.executionContext = executionContext;
        this.metadata = metadata;
    }

    public void execute() throws TranslatorException {
        this.process(this.command);
    }

    private void process(Command cmd) throws TranslatorException {
        if (cmd instanceof Insert) {
            this.performInsert((Insert)cmd);
        } else if (cmd instanceof Update) {
            this.performUpdate((Update)cmd);
        } else if (cmd instanceof Delete) {
            this.performUpdate((Delete)cmd);
        }
    }

    private void performUpdate(Delete obj) throws TranslatorException {
        Table table = obj.getTable().getMetadataObject();
        KeyRecord pk = table.getPrimaryKey();
        final String id = SQLStringVisitor.getRecordName((AbstractMetadataRecord)((AbstractMetadataRecord)pk.getColumns().get(0)));
        if (obj.getParameterValues() != null) {
            throw new TranslatorException((BundleUtil.Event)SolrPlugin.Event.TEIID20008, SolrPlugin.Util.gs((BundleUtil.Event)SolrPlugin.Event.TEIID20008, new Object[0]));
        }
        SolrQueryExecution query = new SolrQueryExecution(this.ef, (Command)obj, this.executionContext, this.metadata, this.connection);
        query.execute();
        final UpdateRequest request = new UpdateRequest();
        query.walkDocuments(new SolrQueryExecution.SolrDocumentCallback(){

            @Override
            public void walk(SolrDocument doc) {
                SolrUpdateExecution.this.updateCount++;
                request.deleteById(doc.getFieldValue(id).toString());
            }
        });
        UpdateResponse response = this.connection.update(request);
        if (response.getStatus() != 0) {
            throw new TranslatorException((BundleUtil.Event)SolrPlugin.Event.TEIID20005, SolrPlugin.Util.gs((BundleUtil.Event)SolrPlugin.Event.TEIID20005, new Object[]{response.getStatus()}));
        }
    }

    private void performUpdate(final Update obj) throws TranslatorException {
        UpdateResponse response;
        if (obj.getParameterValues() != null) {
            throw new TranslatorException((BundleUtil.Event)SolrPlugin.Event.TEIID20009, SolrPlugin.Util.gs((BundleUtil.Event)SolrPlugin.Event.TEIID20009, new Object[0]));
        }
        SolrQueryExecution query = new SolrQueryExecution(this.ef, (Command)obj, this.executionContext, this.metadata, this.connection);
        query.execute();
        final UpdateRequest request = new UpdateRequest();
        query.walkDocuments(new SolrQueryExecution.SolrDocumentCallback(){

            @Override
            public void walk(SolrDocument doc) {
                SolrUpdateExecution.this.updateCount++;
                Table table = obj.getTable().getMetadataObject();
                SolrInputDocument updateDoc = new SolrInputDocument(new String[0]);
                for (String name : doc.getFieldNames()) {
                    if (table.getColumnByName(name) == null) continue;
                    updateDoc.setField(name, doc.getFieldValue(name));
                }
                int elementCount = obj.getChanges().size();
                for (int i = 0; i < elementCount; ++i) {
                    String columnName = SolrSQLHierarchyVistor.getColumnName(((SetClause)obj.getChanges().get(i)).getSymbol());
                    Literal value = (Literal)((SetClause)obj.getChanges().get(i)).getValue();
                    updateDoc.setField(columnName, value.getValue());
                }
                request.add(updateDoc);
            }
        });
        if (request.getDocuments() != null && !request.getDocuments().isEmpty() && (response = this.connection.update(request)).getStatus() != 0) {
            throw new TranslatorException((BundleUtil.Event)SolrPlugin.Event.TEIID20004, SolrPlugin.Util.gs((BundleUtil.Event)SolrPlugin.Event.TEIID20004, new Object[]{response.getStatus()}));
        }
    }

    private void performInsert(Insert insert) throws TranslatorException {
        List columns = insert.getColumns();
        if (insert.getParameterValues() == null) {
            final UpdateRequest request = new UpdateRequest();
            SolrInputDocument doc = new SolrInputDocument(new String[0]);
            List values = ((ExpressionValueSource)insert.getValueSource()).getValues();
            for (int i = 0; i < columns.size(); ++i) {
                String columnName = SolrSQLHierarchyVistor.getColumnName((ColumnReference)columns.get(i));
                Object value = values.get(i);
                if (!(value instanceof Literal)) {
                    throw new TranslatorException((BundleUtil.Event)SolrPlugin.Event.TEIID20002, SolrPlugin.Util.gs((BundleUtil.Event)SolrPlugin.Event.TEIID20002, new Object[0]));
                }
                doc.addField(columnName, ((Literal)value).getValue());
            }
            ++this.updateCount;
            request.add(doc);
            Select q = this.buildSelectQuery(insert);
            SolrQueryExecution query = new SolrQueryExecution(this.ef, (Command)q, this.executionContext, this.metadata, this.connection);
            query.execute();
            query.walkDocuments(new SolrQueryExecution.SolrDocumentCallback(){

                @Override
                public void walk(SolrDocument doc) {
                    request.clear();
                }
            });
            if (request.getDocuments().isEmpty()) {
                throw new TranslatorException((BundleUtil.Event)SolrPlugin.Event.TEIID20007, SolrPlugin.Util.gs((BundleUtil.Event)SolrPlugin.Event.TEIID20007, new Object[0]));
            }
            UpdateResponse response = this.connection.update(request);
            if (response.getStatus() != 0) {
                throw new TranslatorException((BundleUtil.Event)SolrPlugin.Event.TEIID20003, SolrPlugin.Util.gs((BundleUtil.Event)SolrPlugin.Event.TEIID20003, new Object[]{response.getStatus()}));
            }
        } else {
            UpdateResponse response;
            UpdateRequest request = new UpdateRequest();
            int batchSize = 1024;
            Iterator args = insert.getParameterValues();
            while (args.hasNext()) {
                List arg = (List)args.next();
                SolrInputDocument doc = new SolrInputDocument(new String[0]);
                for (int i = 0; i < columns.size(); ++i) {
                    String columnName = SolrSQLHierarchyVistor.getColumnName((ColumnReference)columns.get(i));
                    doc.addField(columnName, arg.get(i));
                }
                ++this.updateCount;
                request.add(doc);
                if (this.updateCount % batchSize != 0) continue;
                UpdateResponse response2 = this.connection.update(request);
                if (response2.getStatus() != 0) {
                    throw new TranslatorException((BundleUtil.Event)SolrPlugin.Event.TEIID20003, SolrPlugin.Util.gs((BundleUtil.Event)SolrPlugin.Event.TEIID20003, new Object[]{response2.getStatus()}));
                }
                request = new UpdateRequest();
            }
            if (request.getDocuments() != null && !request.getDocuments().isEmpty() && (response = this.connection.update(request)).getStatus() != 0) {
                throw new TranslatorException((BundleUtil.Event)SolrPlugin.Event.TEIID20003, SolrPlugin.Util.gs((BundleUtil.Event)SolrPlugin.Event.TEIID20003, new Object[]{response.getStatus()}));
            }
        }
    }

    private Select buildSelectQuery(Insert insert) throws TranslatorException {
        Table table = insert.getTable().getMetadataObject();
        KeyRecord pk = table.getPrimaryKey();
        String id = SQLStringVisitor.getRecordName((AbstractMetadataRecord)((AbstractMetadataRecord)pk.getColumns().get(0)));
        NamedTable g = insert.getTable();
        ArrayList<DerivedColumn> symbols = new ArrayList<DerivedColumn>();
        for (Column column : table.getColumns()) {
            String columnName = SQLStringVisitor.getRecordName((AbstractMetadataRecord)column);
            symbols.add(new DerivedColumn(columnName, (Expression)new ColumnReference(g, columnName, column, column.getJavaType())));
        }
        ArrayList<NamedTable> groups = new ArrayList<NamedTable>();
        groups.add(g);
        ColumnReference idCol = new ColumnReference(g, id, table.getColumnByName(id), table.getColumnByName(id).getJavaType());
        Comparison cc = new Comparison((Expression)idCol, (Expression)this.getPKValue(id, insert), Comparison.Operator.EQ);
        Select q = new Select(symbols, false, groups, (Condition)cc, null, null, null);
        return q;
    }

    private Literal getPKValue(String pk, Insert insert) throws TranslatorException {
        List columns = insert.getColumns();
        List values = ((ExpressionValueSource)insert.getValueSource()).getValues();
        for (int i = 0; i < columns.size(); ++i) {
            String columnName = SolrSQLHierarchyVistor.getColumnName((ColumnReference)columns.get(i));
            Object value = values.get(i);
            if (!columnName.equals(pk)) continue;
            if (value instanceof Literal) {
                return (Literal)value;
            }
            throw new TranslatorException((BundleUtil.Event)SolrPlugin.Event.TEIID20002, SolrPlugin.Util.gs((BundleUtil.Event)SolrPlugin.Event.TEIID20002, new Object[0]));
        }
        throw new TranslatorException((BundleUtil.Event)SolrPlugin.Event.TEIID20005, SolrPlugin.Util.gs((BundleUtil.Event)SolrPlugin.Event.TEIID20005, new Object[0]));
    }

    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
        return new int[]{this.updateCount};
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }
}

