/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.oauth;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Scanner;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.provider.FormEncodingProvider;
import org.apache.cxf.rs.security.oauth.client.OAuthClientUtils;
import org.apache.cxf.rs.security.oauth2.client.Consumer;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenGrant;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeGrant;

public class OAuthUtil {
    public static final String OAUTH1_0_DOMAIN = "<security-domain name=\"oauth-security\">  \n    <authentication>  \n        <login-module code=\"org.teiid.jboss.oauth.OAuth10LoginModule\" flag=\"required\" module=\"org.jboss.teiid.security\">  \n            <module-option name=\"consumer-key\" value=\"{0}\"/>  \n            <module-option name=\"consumer-secret\" value=\"{1}\"/>  \n            <module-option name=\"access-key\" value=\"{2}\"/>  \n            <module-option name=\"access-secret\" value=\"{3}\"/>  \n        </login-module>  \n    </authentication>  \n</security-domain> ";
    public static final String OAUTH2_0_DOMAIN = "<security-domain name=\"oauth2-security\">  \n    <authentication>  \n        <login-module code=\"org.teiid.jboss.oauth.OAuth20LoginModule\" flag=\"required\" module=\"org.jboss.teiid.security\">  \n            <module-option name=\"client-id\" value=\"{0}\"/>  \n            <module-option name=\"client-secret\" value=\"{1}\"/>  \n            <module-option name=\"refresh-token\" value=\"{2}\"/>  \n            <module-option name=\"access-token-uri\" value=\"{3}\"/>  \n        </login-module>  \n    </authentication>  \n</security-domain> ";

    public static void main(String[] args) throws Exception {
        Scanner in = new Scanner(System.in);
        System.out.println("Select type of OAuth authentication");
        System.out.println("1) OAuth 1.0A");
        System.out.println("2) OAuth 2.0");
        System.out.println("3) OAuth 2.0 - Facebook");
        System.out.println();
        String input = in.nextLine();
        input = input.trim();
        switch (Integer.parseInt(input)) {
            case 1: {
                OAuthUtil.oauth10Flow(in);
                break;
            }
            case 2: {
                OAuthUtil.oauth20Flow(in);
                break;
            }
            case 3: {
                OAuthUtil.oauth20FlowFacebook(in);
            }
        }
        in.close();
    }

    private static void oauth10Flow(Scanner in) throws Exception, URISyntaxException {
        System.out.println("=== OAuth 1.0a Workflow ===");
        System.out.println();
        String consumerKey = OAuthUtil.getInput(in, "Enter the Consumer Key = ");
        String consumerSecret = OAuthUtil.getInput(in, "Enter the Consumer Secret = ");
        OAuthClientUtils.Consumer consumer = new OAuthClientUtils.Consumer(consumerKey, consumerSecret);
        String requestURL = OAuthUtil.getInput(in, "Enter the Request Token URL = ");
        FormEncodingProvider provider = new FormEncodingProvider();
        provider.setConsumeMediaTypes(Arrays.asList("text/html"));
        WebClient client = WebClient.create((String)requestURL, Arrays.asList(provider));
        OAuthClientUtils.Token requestToken = OAuthClientUtils.getRequestToken((WebClient)client, (OAuthClientUtils.Consumer)consumer, (URI)new URI("oob"), null);
        System.out.println("Request Token  = " + requestToken.getToken() + " secret = " + requestToken.getSecret());
        System.out.println("");
        String authorizeURL = OAuthUtil.getInput(in, "Enter the User Authorization URL = ");
        URI authenticateURL = OAuthClientUtils.getAuthorizationURI((String)authorizeURL, (String)requestToken.getToken());
        System.out.println("Cut & Paste the URL in a web browser, and Authticate");
        System.out.println("Authorize URL  = " + authenticateURL);
        System.out.println("");
        String authCode = OAuthUtil.getInput(in, "Enter Token Secret (Auth Code, Pin) from previous step = ");
        String accessTokenURL = OAuthUtil.getInput(in, "Enter the Access Token URL = ");
        client = WebClient.create((String)accessTokenURL, Arrays.asList(provider));
        OAuthClientUtils.Token accessToken = OAuthClientUtils.getAccessToken((WebClient)client, (OAuthClientUtils.Consumer)consumer, (OAuthClientUtils.Token)requestToken, (String)authCode);
        System.out.println("Access Token = " + accessToken.getToken() + " Secret = " + accessToken.getSecret());
        System.out.println("");
        System.out.println("Add the following XML into your standalone-teiid.xml file in security-domains subsystem,\nand configure data source securty to this domain");
        System.out.println("");
        System.out.println("");
        System.out.println(MessageFormat.format(OAUTH1_0_DOMAIN, consumerKey, consumerSecret, accessToken.getToken(), accessToken.getSecret()));
    }

    private static void oauth20Flow(Scanner in) throws Exception {
        System.out.println("=== OAuth 2.0 Workflow ===");
        System.out.println();
        String clientID = OAuthUtil.getInput(in, "Enter the Client ID = ");
        String clientSecret = OAuthUtil.getInput(in, "Enter the Client Secret = ");
        Consumer consumer = new Consumer(clientID, clientSecret);
        String authorizeURL = OAuthUtil.getInput(in, "Enter the User Authorization URL = ");
        String scope = OAuthUtil.getInput(in, "Enter scope (hit enter for none) = ", true);
        String callback = OAuthUtil.getInput(in, "Enter callback URL (default: urn:ietf:wg:oauth:2.0:oob) = ", true);
        if (callback == null) {
            callback = "urn:ietf:wg:oauth:2.0:oob";
        }
        URI authenticateURL = org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils.getAuthorizationURI((String)authorizeURL, (String)consumer.getKey(), (String)callback, (String)"Auth URL", (String)scope);
        System.out.println("Cut & Paste the URL in a web browser, and Authticate");
        System.out.println("Authorize URL  = " + authenticateURL.toASCIIString());
        System.out.println("");
        String authCode = OAuthUtil.getInput(in, "Enter Token Secret (Auth Code, Pin) from previous step = ");
        String accessTokenURL = OAuthUtil.getInput(in, "Enter the Access Token URL = ");
        WebClient client = WebClient.create((String)accessTokenURL);
        AuthorizationCodeGrant grant = new AuthorizationCodeGrant(authCode, new URI(callback));
        ClientAccessToken clientToken = org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils.getAccessToken((WebClient)client, (Consumer)consumer, (AccessTokenGrant)grant, null, (boolean)false);
        System.out.println("Refresh Token=" + clientToken.getRefreshToken());
        System.out.println("");
        System.out.println("Add the following XML into your standalone-teiid.xml file in security-domains subsystem,\nand configure data source securty to this domain");
        System.out.println("");
        System.out.println("");
        System.out.println(MessageFormat.format(OAUTH2_0_DOMAIN, clientID, clientSecret, clientToken.getRefreshToken(), accessTokenURL));
    }

    private static void oauth20FlowFacebook(Scanner in) throws Exception {
        String scope;
        System.out.println("=== OAuth 2.0 - Facebook Workflow ===");
        System.out.println();
        String clientID = OAuthUtil.getInput(in, "Enter the App ID = ");
        String clientSecret = OAuthUtil.getInput(in, "Enter the App Secret = ");
        Consumer consumer = new Consumer(clientID, clientSecret);
        String authorizeURL = OAuthUtil.getInput(in, "Enter the User Authorization URL(default: https://www.facebook.com/v2.9/dialog/oauth) = ", true);
        if (authorizeURL == null) {
            authorizeURL = "https://www.facebook.com/v2.9/dialog/oauth";
        }
        if ((scope = OAuthUtil.getInput(in, "Enter scope (default: public_profile,user_friends,email,pages_manage_cta) = ", true)) == null) {
            scope = "public_profile,user_friends,email,pages_manage_cta";
        }
        String callback = OAuthUtil.getInput(in, "Enter callback URL (the redirect url match the setting in your Facebook App) = ");
        URI authenticateURL = org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils.getAuthorizationURI((String)authorizeURL, (String)consumer.getKey(), (String)callback, (String)"Auth URL", (String)scope);
        System.out.println("Cut & Paste the URL in a web browser, and Authticate");
        System.out.println("Authorize URL  = " + authenticateURL.toASCIIString());
        System.out.println("");
        String authCode = OAuthUtil.getInput(in, "Enter Token Secret (Auth Code) from previous step = ");
        String accessTokenURL = OAuthUtil.getInput(in, "Enter the Access Token URL(default: https://graph.facebook.com/v2.9/oauth/access_token) = ", true);
        if (accessTokenURL == null) {
            accessTokenURL = "https://graph.facebook.com/v2.9/oauth/access_token";
        }
        System.out.println("Cut & Paste the URL in a web browser, and Get Access Token");
        System.out.println("Access Token URL  = " + accessTokenURL + "?client_id=" + clientID + "&client_secret=" + clientSecret + "&redirect_uri=" + callback + "&code=" + authCode);
        System.out.println("");
        String access_token = OAuthUtil.getInput(in, "Enter access_token from previous step = ");
        System.out.println("");
        System.out.println("Add the following XML into your standalone-teiid.xml file in security-domains subsystem,\nand configure data source securty to this domain");
        System.out.println("");
        System.out.println("");
        System.out.println(MessageFormat.format(OAUTH2_0_DOMAIN, clientID, clientSecret, access_token, accessTokenURL));
    }

    public static String getInput(Scanner in, String message) throws Exception {
        return OAuthUtil.getInput(in, message, false);
    }

    public static String getInput(Scanner in, String message, boolean allowNull) throws Exception {
        do {
            System.out.print(message);
            String input = in.nextLine();
            input = input.trim();
            if (input.length() <= 1) continue;
            System.out.println("");
            return input;
        } while (!allowNull);
        System.out.println("");
        return null;
    }
}

