/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.ws;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.activation.DataSource;
import javax.resource.ResourceException;
import javax.security.auth.Subject;
import javax.ws.rs.core.Response;
import javax.xml.namespace.QName;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Binding;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxws.DispatchImpl;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPConduitFactory;
import org.apache.cxf.transport.http.asyncclient.AsyncHTTPConduitFactory;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.ietf.jgss.GSSCredential;
import org.teiid.OAuthCredential;
import org.teiid.core.util.ArgCheck;
import org.teiid.logging.LogManager;
import org.teiid.resource.adapter.ws.WSManagedConnectionFactory;
import org.teiid.resource.adapter.ws.WSSecurityCredential;
import org.teiid.resource.spi.BasicConnection;
import org.teiid.resource.spi.BasicManagedConnectionFactory;
import org.teiid.resource.spi.ConnectionContext;
import org.teiid.translator.ws.WSConnection;
import org.teiid.util.WSUtil;

public class WSConnectionImpl
extends BasicConnection
implements WSConnection {
    private static final String CONNECTION_TIMEOUT = "javax.xml.ws.client.connectionTimeout";
    private static final String RECEIVE_TIMEOUT = "javax.xml.ws.client.receiveTimeout";
    private static final String DUMMY_BINDING = "";
    private WSManagedConnectionFactory mcf;
    private Service wsdlService;

    public WSConnectionImpl(WSManagedConnectionFactory mcf) {
        this.mcf = mcf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Dispatch<T> createDispatch(Class<T> type, Service.Mode mode) throws IOException {
        if (this.wsdlService == null) {
            Bus bus = BusFactory.getThreadDefaultBus();
            BusFactory.setThreadDefaultBus((Bus)this.mcf.getBus());
            try {
                this.wsdlService = Service.create((URL)this.mcf.getWsdlUrl(), (QName)this.mcf.getServiceQName());
            }
            finally {
                BusFactory.setThreadDefaultBus((Bus)bus);
            }
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.CONNECTOR.WS", (int)5)) {
                LogManager.logDetail((String)"org.teiid.CONNECTOR.WS", (Object)"Created the WSDL service for", (Object)this.mcf.getWsdl());
            }
        }
        Dispatch dispatch = this.wsdlService.createDispatch(this.mcf.getPortQName(), type, mode);
        this.configureWSSecurity(dispatch);
        this.setDispatchProperties(dispatch, DUMMY_BINDING);
        return dispatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Dispatch<T> createDispatch(String binding, String endpoint, Class<T> type, Service.Mode mode) {
        Service svc;
        Bus bus;
        ArgCheck.isNotNull((Object)binding);
        if (endpoint != null) {
            try {
                new URL(endpoint);
            }
            catch (MalformedURLException e) {
                String defaultEndpoint = this.mcf.getEndPoint();
                String defaultQueryString = null;
                String defaultFragment = null;
                if (defaultEndpoint == null) {
                    throw new WebServiceException(WSManagedConnectionFactory.UTIL.getString("null_default_endpoint"));
                }
                String[] parts = defaultEndpoint.split("\\?", 2);
                defaultEndpoint = parts[0];
                if (parts.length > 1) {
                    defaultQueryString = parts[1];
                    parts = defaultQueryString.split("#");
                    defaultQueryString = parts[0];
                    if (parts.length > 1) {
                        defaultFragment = parts[1];
                    }
                }
                endpoint = endpoint.startsWith("?") || endpoint.startsWith("/") || defaultEndpoint.endsWith("/") ? defaultEndpoint + endpoint : defaultEndpoint + "/" + endpoint;
                if (defaultQueryString != null && defaultQueryString.trim().length() > 0) {
                    endpoint = WSUtil.appendQueryString((String)endpoint, (String)defaultQueryString);
                }
                if (defaultFragment != null && endpoint.indexOf(35) < 0) {
                    endpoint = endpoint + '#' + defaultFragment;
                }
            }
        } else {
            endpoint = this.mcf.getEndPoint();
            if (endpoint == null) {
                throw new WebServiceException(WSManagedConnectionFactory.UTIL.getString("null_endpoint"));
            }
        }
        HttpDispatch dispatch = null;
        if ("http://www.w3.org/2004/08/wsdl/http".equals(binding) && type == DataSource.class) {
            bus = BusFactory.getThreadDefaultBus();
            BusFactory.setThreadDefaultBus((Bus)this.mcf.getBus());
            try {
                dispatch = new HttpDispatch(endpoint, this.mcf.getConfigFile(), this.mcf.getConfigName());
            }
            finally {
                BusFactory.setThreadDefaultBus((Bus)bus);
            }
        }
        bus = BusFactory.getThreadDefaultBus();
        BusFactory.setThreadDefaultBus((Bus)this.mcf.getBus());
        try {
            svc = Service.create((QName)this.mcf.getServiceQName());
        }
        finally {
            BusFactory.setThreadDefaultBus((Bus)bus);
        }
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.CONNECTOR.WS", (int)5)) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR.WS", (Object)"Creating a dispatch with endpoint", (Object)endpoint);
        }
        svc.addPort(this.mcf.getPortQName(), binding, endpoint);
        dispatch = svc.createDispatch(this.mcf.getPortQName(), type, mode);
        this.configureWSSecurity(dispatch);
        this.setDispatchProperties(dispatch, binding);
        return dispatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void configureWSSecurity(Dispatch<T> dispatch) {
        if (this.mcf.getAsSecurityType() == WSManagedConnectionFactory.SecurityType.WSSecurity) {
            Bus bus = BusFactory.getThreadDefaultBus();
            BusFactory.setThreadDefaultBus((Bus)this.mcf.getBus());
            try {
                Subject subject;
                Client client = ((DispatchImpl)dispatch).getClient();
                Endpoint ep = client.getEndpoint();
                if (this.mcf.getOutInterceptors() != null) {
                    for (Interceptor interceptor : this.mcf.getOutInterceptors()) {
                        ep.getOutInterceptors().add(interceptor);
                    }
                }
                if ((subject = ConnectionContext.getSubject()) != null) {
                    WSSecurityCredential wSSecurityCredential = (WSSecurityCredential)ConnectionContext.getSecurityCredential((Subject)subject, WSSecurityCredential.class);
                    if (wSSecurityCredential != null) {
                        if (wSSecurityCredential.useSts()) {
                            dispatch.getRequestContext().put("security.sts.client", wSSecurityCredential.buildStsClient(bus));
                        }
                        if (wSSecurityCredential.getSecurityHandler() == WSSecurityCredential.SecurityHandler.WSS4J) {
                            ep.getOutInterceptors().add(new WSS4JOutInterceptor(wSSecurityCredential.getRequestPropterties()));
                            ep.getInInterceptors().add(new WSS4JInInterceptor(wSSecurityCredential.getResponsePropterties()));
                        } else if (wSSecurityCredential.getSecurityHandler() == WSSecurityCredential.SecurityHandler.WSPOLICY) {
                            dispatch.getRequestContext().putAll(wSSecurityCredential.getRequestPropterties());
                            dispatch.getResponseContext().putAll(wSSecurityCredential.getResponsePropterties());
                        }
                    }
                    HashMap properties = (HashMap)ConnectionContext.getSecurityCredential((Subject)subject, HashMap.class);
                    for (String key : properties.keySet()) {
                        if (!key.startsWith("ws-security.")) continue;
                        ep.put((Object)key, properties.get(key));
                    }
                }
            }
            finally {
                BusFactory.setThreadDefaultBus((Bus)bus);
            }
        }
    }

    private <T> void setDispatchProperties(Dispatch<T> dispatch, String binding) {
        if (this.mcf.getAsSecurityType() == WSManagedConnectionFactory.SecurityType.HTTPBasic || this.mcf.getAsSecurityType() == WSManagedConnectionFactory.SecurityType.Digest) {
            String userName = this.mcf.getAuthUserName();
            String password = this.mcf.getAuthPassword();
            Subject subject = ConnectionContext.getSubject();
            if (subject != null) {
                userName = ConnectionContext.getUserName((Subject)subject, (BasicManagedConnectionFactory)this.mcf, (String)userName);
                password = ConnectionContext.getPassword((Subject)subject, (BasicManagedConnectionFactory)this.mcf, (String)userName, (String)password);
            }
            AuthorizationPolicy policy = new AuthorizationPolicy();
            policy.setUserName(userName);
            policy.setPassword(password);
            if (this.mcf.getAsSecurityType() == WSManagedConnectionFactory.SecurityType.Digest) {
                policy.setAuthorizationType("Digest");
            } else {
                policy.setAuthorizationType("Basic");
            }
            dispatch.getRequestContext().put(AuthorizationPolicy.class.getName(), policy);
        } else if (this.mcf.getAsSecurityType() == WSManagedConnectionFactory.SecurityType.Kerberos) {
            GSSCredential credential;
            boolean credentialFound = false;
            Subject subject = ConnectionContext.getSubject();
            if (subject != null && (credential = (GSSCredential)ConnectionContext.getSecurityCredential((Subject)subject, GSSCredential.class)) != null) {
                dispatch.getRequestContext().put(GSSCredential.class.getName(), credential);
                credentialFound = true;
            }
            if (!credentialFound) {
                throw new WebServiceException(WSManagedConnectionFactory.UTIL.getString("no_gss_credential"));
            }
        } else if (this.mcf.getAsSecurityType() == WSManagedConnectionFactory.SecurityType.OAuth) {
            OAuthCredential credential;
            boolean credentialFound = false;
            Subject subject = ConnectionContext.getSubject();
            if (subject != null && (credential = (OAuthCredential)ConnectionContext.getSecurityCredential((Subject)subject, OAuthCredential.class)) != null) {
                dispatch.getRequestContext().put(OAuthCredential.class.getName(), credential);
                credentialFound = true;
            }
            if (!credentialFound) {
                throw new WebServiceException(WSManagedConnectionFactory.UTIL.getString("no_oauth_credential"));
            }
        }
        if (this.mcf.getRequestTimeout() != null) {
            dispatch.getRequestContext().put(RECEIVE_TIMEOUT, this.mcf.getRequestTimeout());
        }
        if (this.mcf.getConnectTimeout() != null) {
            dispatch.getRequestContext().put(CONNECTION_TIMEOUT, this.mcf.getConnectTimeout());
        }
        if ("http://www.w3.org/2004/08/wsdl/http".equals(binding)) {
            HashMap<String, List<String>> httpHeaders = (HashMap<String, List<String>>)dispatch.getRequestContext().get("javax.xml.ws.http.request.headers");
            if (httpHeaders == null) {
                httpHeaders = new HashMap<String, List<String>>();
            }
            httpHeaders.put("Content-Type", Collections.singletonList("text/xml; charset=utf-8"));
            httpHeaders.put("User-Agent", Collections.singletonList("Teiid Server"));
            dispatch.getRequestContext().put("javax.xml.ws.http.request.headers", httpHeaders);
        }
    }

    public void close() throws ResourceException {
    }

    public URL getWsdl() {
        return this.mcf.getWsdlUrl();
    }

    public QName getServiceQName() {
        return this.mcf.getServiceQName();
    }

    public QName getPortQName() {
        return this.mcf.getPortQName();
    }

    public String getStatusMessage(int status) {
        Response.Status s = Response.Status.fromStatusCode((int)status);
        if (s != null) {
            return s.getReasonPhrase();
        }
        return null;
    }

    private static final class HttpDispatch
    implements Dispatch<DataSource> {
        private static final String AUTHORIZATION = "Authorization";
        private HashMap<String, Object> requestContext = new HashMap();
        private HashMap<String, Object> responseContext = new HashMap();
        private WebClient client;
        private String endpoint;
        private String configFile;

        public HttpDispatch(String endpoint, String configFile, String configName) {
            this.endpoint = endpoint;
            this.configFile = configFile;
        }

        WebClient createWebClient(String baseAddress, Bus bus) {
            JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
            bean.setBus(bus);
            bean.setAddress(baseAddress);
            return bean.createWebClient();
        }

        Bus getBus(String configLocation) {
            if (configLocation != null) {
                SpringBusFactory bf = new SpringBusFactory();
                return bf.createBus(configLocation);
            }
            return BusFactory.getThreadDefaultBus();
        }

        public DataSource invoke(DataSource msg) {
            try {
                URL url = new URL(this.endpoint);
                url.toURI();
                String httpMethod = (String)this.requestContext.get("javax.xml.ws.http.request.method");
                Bus bus = this.getBus(this.configFile);
                if (httpMethod.equals("PATCH")) {
                    bus.setProperty("use.async.http.conduit", (Object)Boolean.TRUE);
                    bus.setExtension((Object)new AsyncHTTPConduitFactory(bus), HTTPConduitFactory.class);
                }
                this.client = this.createWebClient(this.endpoint, bus);
                Map header = (Map)this.requestContext.get("javax.xml.ws.http.request.headers");
                for (Map.Entry entry : header.entrySet()) {
                    this.client.header((String)entry.getKey(), ((List)entry.getValue()).toArray());
                }
                if (this.requestContext.get(AuthorizationPolicy.class.getName()) != null) {
                    HTTPConduit conduit = (HTTPConduit)WebClient.getConfig((Object)this.client).getConduit();
                    AuthorizationPolicy policy = (AuthorizationPolicy)this.requestContext.get(AuthorizationPolicy.class.getName());
                    conduit.setAuthorization(policy);
                } else if (this.requestContext.get(GSSCredential.class.getName()) != null) {
                    WebClient.getConfig((Object)this.client).getRequestContext().put(GSSCredential.class.getName(), this.requestContext.get(GSSCredential.class.getName()));
                    WebClient.getConfig((Object)this.client).getRequestContext().put("auth.spnego.requireCredDelegation", true);
                } else if (this.requestContext.get(OAuthCredential.class.getName()) != null) {
                    OAuthCredential credential = (OAuthCredential)this.requestContext.get(OAuthCredential.class.getName());
                    this.client.header(AUTHORIZATION, new Object[]{credential.getAuthorizationHeader(this.endpoint, httpMethod)});
                }
                InputStream payload = null;
                if (msg != null) {
                    payload = msg.getInputStream();
                }
                HTTPClientPolicy clientPolicy = WebClient.getConfig((Object)this.client).getHttpConduit().getClient();
                Long timeout = (Long)this.requestContext.get(WSConnectionImpl.RECEIVE_TIMEOUT);
                if (timeout != null) {
                    clientPolicy.setReceiveTimeout(timeout.longValue());
                }
                if ((timeout = (Long)this.requestContext.get(WSConnectionImpl.CONNECTION_TIMEOUT)) != null) {
                    clientPolicy.setConnectionTimeout(timeout.longValue());
                }
                Response response = this.client.invoke(httpMethod, (Object)payload);
                this.responseContext.put("status-code", response.getStatus());
                this.responseContext.putAll((Map<String, Object>)response.getMetadata());
                ArrayList contentTypes = (ArrayList)this.responseContext.get("content-type");
                String contentType = contentTypes != null ? (String)contentTypes.get(0) : "application/octet-stream";
                return new HttpDataSource(url, (InputStream)response.getEntity(), contentType);
            }
            catch (IOException e) {
                throw new WebServiceException((Throwable)e);
            }
            catch (URISyntaxException e) {
                throw new WebServiceException((Throwable)e);
            }
        }

        public Map<String, Object> getRequestContext() {
            return this.requestContext;
        }

        public Map<String, Object> getResponseContext() {
            return this.responseContext;
        }

        public Binding getBinding() {
            throw new UnsupportedOperationException();
        }

        public EndpointReference getEndpointReference() {
            throw new UnsupportedOperationException();
        }

        public <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
            throw new UnsupportedOperationException();
        }

        public javax.xml.ws.Response<DataSource> invokeAsync(DataSource msg) {
            throw new UnsupportedOperationException();
        }

        public Future<?> invokeAsync(DataSource msg, AsyncHandler<DataSource> handler) {
            throw new UnsupportedOperationException();
        }

        public void invokeOneWay(DataSource msg) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class HttpDataSource
    implements DataSource {
        private final URL url;
        private InputStream content;
        private String contentType;

        private HttpDataSource(URL url, InputStream entity, String contentType) {
            this.url = url;
            this.content = entity;
            this.contentType = contentType;
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            return this.url.getPath();
        }

        public InputStream getInputStream() throws IOException {
            return this.content;
        }

        public String getContentType() {
            return this.contentType;
        }
    }
}

