/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.ws;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.ws.security.trust.STSClient;

public class WSSecurityCredential
implements Serializable {
    private static final long serialVersionUID = 7725328159246858176L;
    private boolean useSts;
    private String stsWsdlLocation;
    private QName stsService;
    private QName stsPort;
    private HashMap<String, Object> requestProps = new HashMap();
    private HashMap<String, Object> responseProps = new HashMap();
    private HashMap<String, Object> stsProps = new HashMap();
    private SecurityHandler securityHandler = SecurityHandler.WSS4J;

    public SecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    public void setSecurityHandler(SecurityHandler securityHandler) {
        this.securityHandler = securityHandler;
    }

    public HashMap<String, Object> getRequestPropterties() {
        return this.requestProps;
    }

    public HashMap<String, Object> getResponsePropterties() {
        return this.responseProps;
    }

    public HashMap<String, Object> getStsPropterties() {
        return this.stsProps;
    }

    public void setSTSClient(String stsWsdlLocation, QName stsService, QName stsPort) {
        this.stsWsdlLocation = stsWsdlLocation;
        this.stsService = stsService;
        this.stsPort = stsPort;
        this.useSts = true;
    }

    public STSClient buildStsClient(Bus bus) {
        STSClient stsClient = new STSClient(bus);
        stsClient.setWsdlLocation(this.stsWsdlLocation);
        stsClient.setServiceQName(this.stsService);
        stsClient.setEndpointQName(this.stsPort);
        Map props = stsClient.getProperties();
        props.putAll(this.stsProps);
        return stsClient;
    }

    public boolean useSts() {
        return this.useSts;
    }

    public static enum SecurityHandler {
        WSPOLICY,
        WSS4J;

    }
}

