/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request;

import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DecompressingHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.ODataClientErrorException;
import org.apache.olingo.client.api.communication.header.ODataPreferences;
import org.apache.olingo.client.api.communication.request.AsyncRequestWrapper;
import org.apache.olingo.client.api.communication.request.ODataRequest;
import org.apache.olingo.client.api.communication.request.cud.ODataDeleteRequest;
import org.apache.olingo.client.api.communication.response.AsyncResponseWrapper;
import org.apache.olingo.client.api.communication.response.ODataDeleteResponse;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.apache.olingo.client.api.http.HttpClientException;
import org.apache.olingo.client.core.communication.request.AbstractODataBasicRequest;
import org.apache.olingo.client.core.communication.request.AbstractODataRequest;
import org.apache.olingo.client.core.communication.request.AbstractRequest;
import org.apache.olingo.client.core.communication.request.AsyncRequestException;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.api.http.HttpStatusCode;

public class AsyncRequestWrapperImpl<R extends ODataResponse>
extends AbstractRequest
implements AsyncRequestWrapper<R> {
    protected static final int MAX_RETRY = 5;
    protected final ODataClient odataClient;
    protected final ODataRequest odataRequest;
    protected final HttpClient httpClient;
    protected final HttpUriRequest request;
    protected final URI uri;

    protected AsyncRequestWrapperImpl(ODataClient odataClient, ODataRequest odataRequest) {
        this.odataRequest = odataRequest;
        this.odataRequest.setAccept(this.odataRequest.getAccept());
        this.odataRequest.setContentType(this.odataRequest.getContentType());
        this.extendHeader("Prefer", new ODataPreferences().respondAsync());
        this.odataClient = odataClient;
        HttpMethod method = odataRequest.getMethod();
        this.uri = odataRequest.getURI();
        HttpClient _httpClient = odataClient.getConfiguration().getHttpClientFactory().create(method, this.uri);
        if (odataClient.getConfiguration().isGzipCompression()) {
            _httpClient = new DecompressingHttpClient(_httpClient);
        }
        this.httpClient = _httpClient;
        this.request = odataClient.getConfiguration().getHttpUriRequestFactory().create(method, this.uri);
        if (this.request instanceof HttpEntityEnclosingRequestBase && odataRequest instanceof AbstractODataBasicRequest) {
            AbstractODataBasicRequest br = (AbstractODataBasicRequest)odataRequest;
            HttpEntityEnclosingRequestBase httpRequest = (HttpEntityEnclosingRequestBase)this.request;
            httpRequest.setEntity((HttpEntity)new InputStreamEntity(br.getPayload(), -1L));
        }
    }

    public final AsyncRequestWrapper<R> wait(int waitInSeconds) {
        this.extendHeader("Prefer", new ODataPreferences().wait(waitInSeconds));
        return this;
    }

    public final AsyncRequestWrapper<R> callback(URI url) {
        this.extendHeader("Prefer", new ODataPreferences().callback(url.toASCIIString()));
        return this;
    }

    protected final void extendHeader(String headerName, String headerValue) {
        StringBuilder extended = new StringBuilder();
        if (this.odataRequest.getHeaderNames().contains(headerName)) {
            extended.append(this.odataRequest.getHeader(headerName)).append(", ");
        }
        this.odataRequest.addCustomHeader(headerName, extended.append(headerValue).toString());
    }

    public AsyncResponseWrapper<R> execute() {
        return new AsyncResponseWrapperImpl(this.doExecute());
    }

    protected HttpResponse doExecute() {
        for (String key : this.odataRequest.getHeaderNames()) {
            String value = this.odataRequest.getHeader(key);
            this.request.addHeader(key, value);
            LOG.debug("HTTP header being sent {}: {}", (Object)key, (Object)value);
        }
        return this.executeHttpRequest(this.httpClient, this.request);
    }

    protected final HttpResponse checkMonitor(URI location) {
        if (location == null) {
            throw new AsyncRequestException("Invalid async request response. Missing monitor URL");
        }
        HttpUriRequest monitor = this.odataClient.getConfiguration().getHttpUriRequestFactory().create(HttpMethod.GET, location);
        return this.executeHttpRequest(this.httpClient, monitor);
    }

    protected final HttpResponse executeHttpRequest(HttpClient client, HttpUriRequest req) {
        HttpResponse response;
        try {
            response = client.execute(req);
        }
        catch (IOException e) {
            throw new HttpClientException((Throwable)e);
        }
        catch (RuntimeException e) {
            req.abort();
            throw new HttpClientException((Throwable)e);
        }
        this.checkResponse(this.odataClient, response, this.odataRequest.getAccept());
        return response;
    }

    public class AsyncResponseWrapperImpl
    implements AsyncResponseWrapper<R> {
        protected URI location = null;
        protected R response = null;
        protected int retryAfter = 5;
        protected boolean preferenceApplied = false;

        public AsyncResponseWrapperImpl() {
        }

        public AsyncResponseWrapperImpl(HttpResponse res) {
            if (res.getStatusLine().getStatusCode() == 202) {
                this.retrieveMonitorDetails(res);
            } else {
                this.response = ((AbstractODataRequest)AsyncRequestWrapperImpl.this.odataRequest).getResponseTemplate().initFromHttpResponse(res);
            }
        }

        public boolean isPreferenceApplied() {
            return this.preferenceApplied;
        }

        public boolean isDone() {
            if (this.response == null) {
                HttpResponse res = AsyncRequestWrapperImpl.this.checkMonitor(this.location);
                if (res.getStatusLine().getStatusCode() == 202) {
                    this.retrieveMonitorDetails(res);
                } else {
                    this.response = this.instantiateResponse(res);
                }
            }
            return this.response != null;
        }

        public R getODataResponse() {
            HttpResponse res = null;
            for (int i = 0; this.response == null && i < 5; ++i) {
                res = AsyncRequestWrapperImpl.this.checkMonitor(this.location);
                if (res.getStatusLine().getStatusCode() == HttpStatusCode.ACCEPTED.getStatusCode()) {
                    Object[] headers = res.getHeaders("Retry-After");
                    if (ArrayUtils.isNotEmpty((Object[])headers)) {
                        this.retryAfter = Integer.parseInt(headers[0].getValue());
                    }
                    try {
                        Thread.sleep((long)this.retryAfter * 1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                this.location = null;
                return this.instantiateResponse(res);
            }
            if (this.response == null) {
                throw new ODataClientErrorException(res == null ? null : res.getStatusLine());
            }
            return this.response;
        }

        public ODataDeleteResponse delete() {
            ODataDeleteRequest deleteRequest = AsyncRequestWrapperImpl.this.odataClient.getCUDRequestFactory().getDeleteRequest(this.location);
            return (ODataDeleteResponse)deleteRequest.execute();
        }

        public AsyncResponseWrapper<ODataDeleteResponse> asyncDelete() {
            return AsyncRequestWrapperImpl.this.odataClient.getAsyncRequestFactory().getAsyncRequestWrapper((ODataRequest)AsyncRequestWrapperImpl.this.odataClient.getCUDRequestFactory().getDeleteRequest(this.location)).execute();
        }

        public AsyncResponseWrapper<R> forceNextMonitorCheck(URI uri) {
            this.location = uri;
            this.response = null;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private R instantiateResponse(HttpResponse res) {
            ODataResponse odataResponse;
            try {
                odataResponse = ((AbstractODataRequest)AsyncRequestWrapperImpl.this.odataRequest).getResponseTemplate().initFromEnclosedPart(res.getEntity().getContent());
            }
            catch (Exception e) {
                AbstractRequest.LOG.error("Error instantiating odata response", (Throwable)e);
                odataResponse = null;
            }
            finally {
                HttpClientUtils.closeQuietly((HttpResponse)res);
            }
            return odataResponse;
        }

        private void retrieveMonitorDetails(HttpResponse res) {
            Object[] headers = res.getHeaders("Location");
            if (!ArrayUtils.isNotEmpty((Object[])headers)) {
                throw new AsyncRequestException("Invalid async request response. Monitor URL '" + headers[0].getValue() + "'");
            }
            this.location = URI.create(headers[0].getValue());
            headers = res.getHeaders("Retry-After");
            if (ArrayUtils.isNotEmpty((Object[])headers)) {
                this.retryAfter = Integer.parseInt(headers[0].getValue());
            }
            if (ArrayUtils.isNotEmpty((Object[])(headers = res.getHeaders("Preference-Applied")))) {
                for (Object header : headers) {
                    if (!header.getValue().equalsIgnoreCase(new ODataPreferences().respondAsync())) continue;
                    this.preferenceApplied = true;
                }
            }
            try {
                EntityUtils.consume((HttpEntity)res.getEntity());
            }
            catch (IOException ex) {
                Logger.getLogger(AsyncRequestWrapperImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

