/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.edm.provider.CsdlTypeDefinition;

@JsonDeserialize(using=TypeDefinitionDeserializer.class)
class ClientCsdlTypeDefinition
extends CsdlTypeDefinition
implements Serializable {
    private static final long serialVersionUID = -902407149079419602L;

    ClientCsdlTypeDefinition() {
    }

    static class TypeDefinitionDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlTypeDefinition> {
        TypeDefinitionDeserializer() {
        }

        @Override
        protected ClientCsdlTypeDefinition doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlTypeDefinition typeDefinition = new ClientCsdlTypeDefinition();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Name".equals(jp.getCurrentName())) {
                        typeDefinition.setName(jp.nextTextValue());
                    } else if ("UnderlyingType".equals(jp.getCurrentName())) {
                        typeDefinition.setUnderlyingType(jp.nextTextValue());
                    } else if ("MaxLength".equals(jp.getCurrentName())) {
                        typeDefinition.setMaxLength(jp.nextIntValue(0));
                    } else if ("Unicode".equals(jp.getCurrentName())) {
                        typeDefinition.setUnicode(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                    } else if ("Precision".equals(jp.getCurrentName())) {
                        typeDefinition.setPrecision(jp.nextIntValue(0));
                    } else if ("Scale".equals(jp.getCurrentName())) {
                        String scale = jp.nextTextValue();
                        typeDefinition.setScale("variable".equalsIgnoreCase(scale) ? 0 : Integer.valueOf(scale));
                    } else if ("SRID".equals(jp.getCurrentName())) {
                        String srid = jp.nextTextValue();
                        if (srid != null) {
                            typeDefinition.setSrid(SRID.valueOf((String)srid));
                        }
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        typeDefinition.getAnnotations().add(jp.readValueAs(ClientCsdlAnnotation.class));
                    }
                }
                jp.nextToken();
            }
            return typeDefinition;
        }
    }
}

