/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.appsforyourdomain;

import com.google.gdata.client.GoogleService;
import com.google.gdata.client.Query;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.IFeed;
import com.google.gdata.data.appsforyourdomain.AppsForYourDomainException;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AppsForYourDomainService
extends GoogleService {
    public static final String DOMAIN_NAME = "www.google.com";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String APPS_SERVICE = "apps";

    public AppsForYourDomainService(String applicationName) {
        this(applicationName, HTTPS_PROTOCOL, DOMAIN_NAME);
    }

    public AppsForYourDomainService(String applicationName, String protocol, String domainName) {
        super(APPS_SERVICE, applicationName, protocol, domainName);
    }

    @Override
    public <E extends IEntry> E insert(URL feedUrl, E entry) throws IOException, ServiceException, AppsForYourDomainException {
        try {
            return super.insert(feedUrl, entry);
        }
        catch (ServiceException se) {
            AppsForYourDomainException ae = AppsForYourDomainException.narrow(se);
            throw ae != null ? ae : se;
        }
    }

    @Override
    public <E extends IEntry> E getEntry(URL entryUrl, Class<E> entryClass) throws IOException, ServiceException, AppsForYourDomainException {
        try {
            return super.getEntry(entryUrl, entryClass);
        }
        catch (ServiceException se) {
            AppsForYourDomainException ae = AppsForYourDomainException.narrow(se);
            throw ae != null ? ae : se;
        }
    }

    @Override
    public <F extends IFeed> F getFeed(URL feedUrl, Class<F> feedClass) throws IOException, ServiceException, AppsForYourDomainException {
        try {
            return super.getFeed(feedUrl, feedClass);
        }
        catch (ServiceException se) {
            AppsForYourDomainException ae = AppsForYourDomainException.narrow(se);
            throw ae != null ? ae : se;
        }
    }

    @Override
    public <F extends IFeed> F query(Query query, Class<F> feedClass) throws IOException, ServiceException, AppsForYourDomainException {
        try {
            return super.query(query, feedClass);
        }
        catch (ServiceException se) {
            AppsForYourDomainException ae = AppsForYourDomainException.narrow(se);
            throw ae != null ? ae : se;
        }
    }

    @Override
    public <E extends IEntry> E update(URL entryUrl, E entry) throws IOException, ServiceException, AppsForYourDomainException {
        try {
            return super.update(entryUrl, entry);
        }
        catch (ServiceException se) {
            AppsForYourDomainException ae = AppsForYourDomainException.narrow(se);
            throw ae != null ? ae : se;
        }
    }

    @Override
    public void delete(URL entryUrl) throws IOException, ServiceException, AppsForYourDomainException {
        try {
            super.delete(entryUrl);
            return;
        }
        catch (ServiceException se) {
            AppsForYourDomainException ae = AppsForYourDomainException.narrow(se);
            throw ae != null ? ae : se;
        }
    }

    @Override
    public <E extends IEntry> E getEntry(URL entryUrl, Class<E> entryClass, DateTime ifModifiedSince) throws IOException, ServiceException {
        try {
            return super.getEntry(entryUrl, entryClass);
        }
        catch (ServiceException se) {
            AppsForYourDomainException ae = AppsForYourDomainException.narrow(se);
            throw ae != null ? ae : se;
        }
    }

    @Override
    public <F extends IFeed> F getFeed(URL feedUrl, Class<F> feedClass, DateTime ifModifiedSince) throws IOException, ServiceException {
        try {
            return super.getFeed(feedUrl, feedClass);
        }
        catch (ServiceException se) {
            AppsForYourDomainException ae = AppsForYourDomainException.narrow(se);
            throw ae != null ? ae : se;
        }
    }

    protected <E extends IEntry, F extends IFeed> List<E> getAllPages(URL feedUrl, Class<F> feedClass) throws IOException, ServiceException {
        ArrayList<? extends IEntry> allEntries = new ArrayList<IEntry>();
        try {
            F feed;
            do {
                feed = this.getFeed(feedUrl, feedClass);
                allEntries.addAll(feed.getEntries());
            } while ((feedUrl = feed.getNextLink() == null ? null : new URL(feed.getNextLink().getHref())) != null);
        }
        catch (ServiceException se) {
            AppsForYourDomainException ae = AppsForYourDomainException.narrow(se);
            throw ae != null ? ae : se;
        }
        return allEntries;
    }
}

