/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.appsforyourdomain.adminsettings;

import com.google.gdata.client.appsforyourdomain.AppsPropertyService;
import com.google.gdata.data.appsforyourdomain.AppsForYourDomainException;
import com.google.gdata.data.appsforyourdomain.generic.GenericEntry;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.URL;

public class DomainVerificationService
extends AppsPropertyService {
    protected String domainUrlBase = null;
    protected String verificationBaseUrl;

    public DomainVerificationService(String domain, String applicationName) {
        super(applicationName);
        this.domainUrlBase = "https://apps-apis.google.com/a/feeds/domain/2.0/" + domain + "/";
        this.verificationBaseUrl = this.domainUrlBase + "verification/";
    }

    public DomainVerificationService(String adminEmail, String password, String domain, String applicationName) throws AuthenticationException {
        this(domain, applicationName);
        this.setUserCredentials(adminEmail, password);
    }

    public GenericEntry retrieveCnameVerificationStatus() throws AppsForYourDomainException, IOException, ServiceException {
        return this.getEntry(new URL(this.verificationBaseUrl + "cname"), GenericEntry.class);
    }

    public GenericEntry retrieveMxVerificationStatus() throws AppsForYourDomainException, IOException, ServiceException {
        return this.getEntry(new URL(this.verificationBaseUrl + "mx"), GenericEntry.class);
    }

    public GenericEntry updateVerifiedStatus(GenericEntry entry, boolean status) throws AppsForYourDomainException, IOException, ServiceException {
        entry.removeProperty("verified");
        entry.addProperty("verified", String.valueOf(status));
        return (GenericEntry)entry.update();
    }
}

