/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.docs;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="docs", nsUri="http://schemas.google.com/docs/2007", localName="archiveFailure")
public class ArchiveFailure
extends AbstractExtension {
    static final String XML_NAME = "archiveFailure";
    private static final String REASON = "reason";
    private String reason = null;
    private String value = null;

    public ArchiveFailure() {
    }

    public ArchiveFailure(String reason, String value) {
        this.setReason(reason);
        this.setValue(value);
        this.setImmutable(true);
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.throwExceptionIfImmutable();
        this.reason = reason;
    }

    public boolean hasReason() {
        return this.getReason() != null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.throwExceptionIfImmutable();
        this.value = value;
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    protected void validate() {
        if (this.value == null) {
            throw new IllegalStateException("Missing text content");
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(ArchiveFailure.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put(REASON, this.reason);
        generator.setContent(this.value);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.reason = helper.consume(REASON, false);
        this.value = helper.consume(null, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        ArchiveFailure other = (ArchiveFailure)obj;
        return ArchiveFailure.eq(this.reason, other.reason) && ArchiveFailure.eq(this.value, other.value);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.reason != null) {
            result = 37 * result + this.reason.hashCode();
        }
        if (this.value != null) {
            result = 37 * result + this.value.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{ArchiveFailure reason=" + this.reason + " value=" + this.value + "}";
    }
}

