/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.docs;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="docs", nsUri="http://schemas.google.com/docs/2007", localName="exportFormat")
public class ExportFormat
extends ExtensionPoint {
    static final String XML_NAME = "exportFormat";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final AttributeHelper.EnumToAttributeValue<Source> SOURCE_ENUM_TO_ATTRIBUTE_VALUE = new AttributeHelper.LowerCaseEnumToAttributeValue<Source>();
    private Source source = null;
    private String target = null;

    public ExportFormat() {
    }

    public ExportFormat(Source source, String target) {
        this.setSource(source);
        this.setTarget(target);
        this.setImmutable(true);
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.throwExceptionIfImmutable();
        this.source = source;
    }

    public boolean hasSource() {
        return this.getSource() != null;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.throwExceptionIfImmutable();
        this.target = target;
    }

    public boolean hasTarget() {
        return this.getTarget() != null;
    }

    protected void validate() {
        if (this.source == null) {
            ExportFormat.throwExceptionForMissingAttribute(SOURCE);
        }
        if (this.target == null) {
            ExportFormat.throwExceptionForMissingAttribute(TARGET);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(ExportFormat.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put(SOURCE, this.source, SOURCE_ENUM_TO_ATTRIBUTE_VALUE);
        generator.put(TARGET, this.target);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.source = helper.consumeEnum(SOURCE, true, Source.class, null, SOURCE_ENUM_TO_ATTRIBUTE_VALUE);
        this.target = helper.consume(TARGET, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        ExportFormat other = (ExportFormat)obj;
        return ExportFormat.eq((Object)this.source, (Object)other.source) && ExportFormat.eq(this.target, other.target);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.source != null) {
            result = 37 * result + this.source.hashCode();
        }
        if (this.target != null) {
            result = 37 * result + this.target.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{ExportFormat source=" + (Object)((Object)this.source) + " target=" + this.target + "}";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Source {
        DOCUMENT,
        DRAWING,
        PRESENTATION,
        SPREADSHEET;

    }
}

