/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.finance;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.finance.PositionData;
import com.google.gdata.data.finance.PositionFeedLink;
import com.google.gdata.data.finance.Symbol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Kind.Term(value="http://schemas.google.com/finance/2007#position")
public class PositionEntry
extends BaseEntry<PositionEntry> {
    public static final String KIND = "http://schemas.google.com/finance/2007#position";
    public static final Category CATEGORY = new Category("http://schemas.google.com/g/2005#kind", "http://schemas.google.com/finance/2007#position");

    public PositionEntry() {
        this.getCategories().add(CATEGORY);
    }

    public PositionEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(PositionEntry.class)) {
            return;
        }
        super.declareExtensions(extProfile);
        extProfile.declare(PositionEntry.class, PositionFeedLink.class);
        new PositionFeedLink().declareExtensions(extProfile);
        extProfile.declare(PositionEntry.class, PositionData.getDefaultDescription(true, false));
        new PositionData().declareExtensions(extProfile);
        extProfile.declare(PositionEntry.class, Symbol.getDefaultDescription(true, false));
    }

    public PositionFeedLink getFeedLink() {
        return this.getExtension(PositionFeedLink.class);
    }

    public void setFeedLink(PositionFeedLink feedLink) {
        if (feedLink == null) {
            this.removeExtension(PositionFeedLink.class);
        } else {
            this.setExtension(feedLink);
        }
    }

    public boolean hasFeedLink() {
        return this.hasExtension(PositionFeedLink.class);
    }

    public PositionData getPositionData() {
        return this.getExtension(PositionData.class);
    }

    public void setPositionData(PositionData positionData) {
        if (positionData == null) {
            this.removeExtension(PositionData.class);
        } else {
            this.setExtension(positionData);
        }
    }

    public boolean hasPositionData() {
        return this.hasExtension(PositionData.class);
    }

    public Symbol getSymbol() {
        return this.getExtension(Symbol.class);
    }

    public void setSymbol(Symbol symbol) {
        if (symbol == null) {
            this.removeExtension(Symbol.class);
        } else {
            this.setExtension(symbol);
        }
    }

    public boolean hasSymbol() {
        return this.hasExtension(Symbol.class);
    }

    @Override
    protected void validate() {
    }

    public String toString() {
        return "{PositionEntry " + super.toString() + "}";
    }
}

