/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.media;

import com.google.gdata.data.DateTime;
import com.google.gdata.data.media.BaseMediaSource;
import java.io.InputStream;
import java.io.OutputStream;
import javax.mail.internet.SharedInputStream;

public class MediaStreamSource
extends BaseMediaSource {
    private InputStream mediaStream;
    private long sharedMediaStreamStart;

    public MediaStreamSource(InputStream mediaStream, String mediaType, DateTime lastModified, long contentLength) {
        super(mediaType);
        this.mediaStream = mediaStream;
        this.lastModified = lastModified;
        this.contentLength = contentLength;
        if (mediaStream instanceof SharedInputStream) {
            this.sharedMediaStreamStart = ((SharedInputStream)mediaStream).getPosition();
        }
    }

    public MediaStreamSource(InputStream mediaStream, String mediaType) {
        this(mediaStream, mediaType, null, -1L);
    }

    public InputStream getInputStream() {
        InputStream returnStream = this.mediaStream instanceof SharedInputStream ? ((SharedInputStream)this.mediaStream).newStream(this.sharedMediaStreamStart, -1L) : this.mediaStream;
        return returnStream;
    }

    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException("Cannot write to MediaStreamSource");
    }
}

