/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jdmf.algorithms.association;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.sf.jdmf.algorithms.AbstractDataMiningAlgorithm;
import net.sf.jdmf.data.input.InputData;
import net.sf.jdmf.data.input.attribute.Attribute;
import net.sf.jdmf.data.input.attribute.Instance;
import net.sf.jdmf.data.operators.EqualityOperator;
import net.sf.jdmf.data.output.DataMiningModel;
import net.sf.jdmf.data.output.Item;
import net.sf.jdmf.data.output.Rule;
import net.sf.jdmf.data.output.RuleElement;
import org.apache.commons.collections.CollectionUtils;

public class AprioriAlgorithm
extends AbstractDataMiningAlgorithm {
    protected Integer minRuleCoverage;
    protected Double minRuleAccuracy;

    @Override
    public DataMiningModel analyze(InputData inputData) {
        List<Attribute> attributes = inputData.getAttributes();
        List<Instance> instances = this.attributeConverter.convertToInstances(attributes);
        DataMiningModel dataMiningModel = new DataMiningModel();
        List<Rule> associationRules = dataMiningModel.getRules();
        List<Set<Item>> previousItemSets = new ArrayList<Set<Item>>();
        for (Attribute attribute : attributes) {
            for (Comparable attributeValue : attribute.getDistinctValues()) {
                Item item = new Item(attribute.getName(), attributeValue, EqualityOperator.EQUAL);
                LinkedHashSet<Item> itemSet = new LinkedHashSet<Item>();
                itemSet.add(item);
                if (this.calculateCoverage(itemSet, instances) < this.minRuleCoverage) continue;
                Rule rule = this.generateRule(item);
                if (this.calculateAccuracy(rule, instances) >= this.minRuleAccuracy) {
                    associationRules.add(rule);
                }
                previousItemSets.add(itemSet);
            }
        }
        for (int i = 0; i < attributes.size() - 2; ++i) {
            List<Set<Item>> currentItemSets = this.findCurrentItemSets(previousItemSets, instances);
            List<Rule> rulesForCurrentItemSets = this.findRulesForCurrentItemSets(currentItemSets, instances);
            associationRules.addAll(rulesForCurrentItemSets);
            previousItemSets = currentItemSets;
        }
        return dataMiningModel;
    }

    protected List<Set<Item>> findCurrentItemSets(List<Set<Item>> previousItemSets, List<Instance> instances) {
        ArrayList<Set<Item>> currentItemSets = new ArrayList<Set<Item>>();
        while (previousItemSets.size() > 1) {
            Set<Item> firstItemSet = null;
            for (Set<Item> itemSet : previousItemSets) {
                if (firstItemSet != null) {
                    LinkedHashSet<Item> currentItemSet = new LinkedHashSet<Item>();
                    currentItemSet.addAll(CollectionUtils.union(firstItemSet, itemSet));
                    if (this.calculateCoverage(currentItemSet, instances) < this.minRuleCoverage || currentItemSets.contains(currentItemSet)) continue;
                    currentItemSets.add(currentItemSet);
                    continue;
                }
                firstItemSet = itemSet;
            }
            previousItemSets.remove(firstItemSet);
        }
        return currentItemSets;
    }

    protected List<Rule> findRulesForCurrentItemSets(List<Set<Item>> currentItemSets, List<Instance> instances) {
        ArrayList<Rule> rulesForCurrentItemSets = new ArrayList<Rule>();
        for (Set<Item> currentItemSet : currentItemSets) {
            Rule noConditionsRule = this.generateRule(new LinkedHashSet<Item>(), currentItemSet);
            if (this.calculateAccuracy(noConditionsRule, instances) >= this.minRuleAccuracy) {
                rulesForCurrentItemSets.add(noConditionsRule);
            }
            rulesForCurrentItemSets.addAll(this.generateDescendantRules(currentItemSet, new LinkedHashSet<Item>(), instances));
        }
        return rulesForCurrentItemSets;
    }

    protected List<Rule> generateDescendantRules(Set<Item> conditionItemSet, Set<Item> consequenceItemSet, List<Instance> instances) {
        ArrayList<Rule> descendantRules = new ArrayList<Rule>();
        if (conditionItemSet.size() == 1) {
            return descendantRules;
        }
        for (Item conditionItem : conditionItemSet) {
            LinkedHashSet<Item> descendantConditionItemSet = new LinkedHashSet<Item>(conditionItemSet);
            descendantConditionItemSet.remove(conditionItem);
            LinkedHashSet<Item> descendantConsequenceItemSet = new LinkedHashSet<Item>(consequenceItemSet);
            descendantConsequenceItemSet.add(conditionItem);
            Rule descendantRule = this.generateRule(descendantConditionItemSet, descendantConsequenceItemSet);
            Double descendantRuleAccuracy = this.calculateAccuracy(descendantRule, instances);
            if (!(descendantRuleAccuracy >= this.minRuleAccuracy)) continue;
            descendantRules.add(descendantRule);
            descendantRules.addAll(this.generateDescendantRules(descendantConditionItemSet, descendantConsequenceItemSet, instances));
        }
        return descendantRules;
    }

    protected Rule generateRule(Set<Item> conditionItemSet, Set<Item> consequenceItemSet) {
        Rule rule = new Rule();
        RuleElement currentRuleElement = null;
        for (Item conditionItem : conditionItemSet) {
            if (currentRuleElement != null) {
                currentRuleElement = currentRuleElement.and(rule).attribute(conditionItem.getAttributeName()).equals(conditionItem.getAttributeValue());
                continue;
            }
            currentRuleElement = rule.defineIf().attribute(conditionItem.getAttributeName()).equals(conditionItem.getAttributeValue());
        }
        currentRuleElement = null;
        for (Item consequenceItem : consequenceItemSet) {
            if (currentRuleElement != null) {
                currentRuleElement = currentRuleElement.and(rule).attribute(consequenceItem.getAttributeName()).equals(consequenceItem.getAttributeValue());
                continue;
            }
            currentRuleElement = rule.defineThen().attribute(consequenceItem.getAttributeName()).equals(consequenceItem.getAttributeValue());
        }
        return rule;
    }

    protected Rule generateRule(Item item) {
        Rule rule = new Rule();
        rule.defineThen().attribute(item.getAttributeName()).equals(item.getAttributeValue());
        return rule;
    }

    @Override
    protected String getName() {
        return "Apriori Algorithm";
    }

    public Integer getMinRuleCoverage() {
        return this.minRuleCoverage;
    }

    public void setMinRuleCoverage(Integer maxRuleCount) {
        this.minRuleCoverage = maxRuleCount;
    }

    public Double getMinRuleAccuracy() {
        return this.minRuleAccuracy;
    }

    public void setMinRuleAccuracy(Double minRuleAccuracy) {
        this.minRuleAccuracy = minRuleAccuracy;
    }
}

