/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jdmf.algorithms.classification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.sf.jdmf.algorithms.AbstractDataMiningAlgorithm;
import net.sf.jdmf.algorithms.classification.util.AttributeValuePartitioner;
import net.sf.jdmf.data.input.InputData;
import net.sf.jdmf.data.input.attribute.Attribute;
import net.sf.jdmf.data.input.attribute.AttributeType;
import net.sf.jdmf.data.input.attribute.AttributeValuePair;
import net.sf.jdmf.data.input.attribute.Instance;
import net.sf.jdmf.data.output.DataMiningModel;
import net.sf.jdmf.data.output.Rule;

public class OneRuleAlgorithm
extends AbstractDataMiningAlgorithm {
    protected AttributeValuePartitioner attributeValuePartitioner = new AttributeValuePartitioner();

    @Override
    public DataMiningModel analyze(InputData inputData) {
        DataMiningModel dataMiningModel = new DataMiningModel();
        List<Rule> rules = dataMiningModel.getRules();
        for (Attribute decision : inputData.getDecisions()) {
            List<Rule> singleDecisionRules = this.analyzeDecision(decision, inputData.getAttributes());
            rules.addAll(singleDecisionRules);
        }
        return dataMiningModel;
    }

    protected List<Rule> analyzeDecision(Attribute decision, List<Attribute> attributes) {
        ArrayList<Rule> singleDecisionRules = new ArrayList<Rule>();
        Integer lowestErrorSum = 0;
        Map<List<Rule>, Integer> errorSum = this.calculateErrorSumForAttributes(decision, attributes);
        for (Map.Entry<List<Rule>, Integer> errorSumEntry : errorSum.entrySet()) {
            if (singleDecisionRules.isEmpty() || errorSumEntry.getValue().compareTo(lowestErrorSum) < 0) {
                lowestErrorSum = errorSumEntry.getValue();
                singleDecisionRules.clear();
                singleDecisionRules.addAll((Collection<Rule>)errorSumEntry.getKey());
                continue;
            }
            if (errorSumEntry.getValue().compareTo(lowestErrorSum) != 0) continue;
            singleDecisionRules.addAll((Collection<Rule>)errorSumEntry.getKey());
        }
        return singleDecisionRules;
    }

    protected Map<List<Rule>, Integer> calculateErrorSumForAttributes(Attribute decision, List<Attribute> attributes) {
        LinkedHashMap<List<Rule>, Integer> errorSum = new LinkedHashMap<List<Rule>, Integer>();
        for (Attribute attribute : attributes) {
            List<Rule> rulesForAttribute = this.generateRulesForAttribute(attribute, decision);
            ArrayList<Attribute> requiredAttributes = new ArrayList<Attribute>();
            requiredAttributes.add(attribute);
            requiredAttributes.add(decision);
            List<Instance> instances = this.attributeConverter.convertToInstances(requiredAttributes);
            Integer errorSumForAttribute = this.calculateErrorSum(rulesForAttribute, instances);
            errorSum.put(rulesForAttribute, errorSumForAttribute);
        }
        return errorSum;
    }

    protected Integer calculateErrorSum(List<Rule> rulesForAttribute, List<Instance> instances) {
        Integer errorCountForAttribute = instances.size();
        for (Rule ruleForAttribute : rulesForAttribute) {
            errorCountForAttribute = errorCountForAttribute - this.calculateCoverage(ruleForAttribute, instances);
        }
        return errorCountForAttribute;
    }

    protected List<Rule> generateRulesForAttribute(Attribute attribute, Attribute decision) {
        List<Rule> rulesBasedOnAttribute = new ArrayList<Rule>();
        AttributeType attributeType = attribute.getType();
        if (attributeType.equals((Object)AttributeType.NOMINAL)) {
            for (Comparable attributeValue : attribute.getDistinctValues()) {
                Comparable bestDecisionValue = this.chooseBestDecisionValueForAttributeValue(decision, attribute, attributeValue);
                Rule rule = new Rule();
                rule.defineIf().attribute(attribute.getName()).equals(attributeValue);
                rule.defineThen().attribute(decision.getName()).equals(bestDecisionValue);
                rulesBasedOnAttribute.add(rule);
            }
        } else if (attributeType.equals((Object)AttributeType.NUMERIC)) {
            List<AttributeValuePair> valuePairs = this.attributeConverter.convertToValuePairs(attribute, decision);
            rulesBasedOnAttribute = this.attributeValuePartitioner.partitionValues(attribute.getName(), decision.getName(), valuePairs, 3);
        }
        return rulesBasedOnAttribute;
    }

    protected Comparable chooseBestDecisionValueForAttributeValue(Attribute decision, Attribute attribute, Comparable selectedAttributeValue) {
        Map<Comparable, Integer> coverageForAttributeValue = this.calculateCoverageForAttributeValue(decision, attribute, selectedAttributeValue);
        Comparable bestDecisionValue = null;
        Integer bestDecisionValueCoverage = null;
        ArrayList<Comparable> exAequoDecisionValues = new ArrayList<Comparable>();
        for (Map.Entry<Comparable, Integer> coverageEntry : coverageForAttributeValue.entrySet()) {
            if (bestDecisionValue == null || coverageEntry.getValue().compareTo(bestDecisionValueCoverage) > 0) {
                bestDecisionValue = coverageEntry.getKey();
                bestDecisionValueCoverage = coverageEntry.getValue();
                exAequoDecisionValues.clear();
                exAequoDecisionValues.add(coverageEntry.getKey());
                continue;
            }
            if (coverageEntry.getValue().compareTo(bestDecisionValueCoverage) != 0) continue;
            exAequoDecisionValues.add(coverageEntry.getKey());
        }
        if (exAequoDecisionValues.size() > 1) {
            Random random = new Random();
            bestDecisionValue = (Comparable)exAequoDecisionValues.get(random.nextInt(exAequoDecisionValues.size()));
        }
        return bestDecisionValue;
    }

    protected Map<Comparable, Integer> calculateCoverageForAttributeValue(Attribute decision, Attribute attribute, Comparable selectedAttributeValue) {
        LinkedHashMap<Comparable, Integer> coverageForSelectedAttributeValue = new LinkedHashMap<Comparable, Integer>();
        for (Comparable decisionValue : decision.getDistinctValues()) {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            attributes.add(attribute);
            attributes.add(decision);
            List<Instance> instances = this.attributeConverter.convertToInstances(attributes);
            Rule ruleForSelectedValue = new Rule();
            ruleForSelectedValue.defineIf().attribute(attribute.getName()).equals(selectedAttributeValue);
            ruleForSelectedValue.defineThen().attribute(decision.getName()).equals(decisionValue);
            Integer decisionValueCoverage = this.calculateCoverage(ruleForSelectedValue, instances);
            coverageForSelectedAttributeValue.put(decisionValue, decisionValueCoverage);
        }
        return coverageForSelectedAttributeValue;
    }

    @Override
    protected String getName() {
        return "One Rule Algorithm";
    }
}

