/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.analytics;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PIIValidator {
    private String errdef = "";

    public boolean isCreditCard(String ccnumber) {
        this.errdef = "";
        int strlen = ccnumber.length();
        if (strlen > 19 || strlen < 12) {
            this.errdef = "No of digits not matching";
            return false;
        }
        String lastdc = ccnumber.substring(strlen - 1, strlen);
        int lastd = -1;
        try {
            lastd = Integer.parseInt(lastdc);
            int checkd = this.luhn_checkSum(ccnumber);
            if (lastd != checkd) {
                this.errdef = "Check Sum failed";
                return false;
            }
        }
        catch (Exception e) {
            this.errdef = "Non Digit Values for Credit Card";
            return false;
        }
        this.errdef = "Credit Card successful";
        return true;
    }

    private int luhn_checkSum(String numberString) {
        int sum = 0;
        int checkDigit = 0;
        boolean isDouble = true;
        for (int i = numberString.length() - 2; i >= 0; --i) {
            int k = Integer.parseInt(String.valueOf(numberString.charAt(i)));
            sum += this.sumToSingleDigit(k * (isDouble ? 2 : 1));
            isDouble = !isDouble;
        }
        if (sum % 10 > 0) {
            checkDigit = 10 - sum % 10;
        }
        return checkDigit;
    }

    private int sumToSingleDigit(int k) {
        if (k < 10) {
            return k;
        }
        return this.sumToSingleDigit(k / 10) + k % 10;
    }

    public boolean isSSN(String ssnnumber) {
        int strlen = ssnnumber.length();
        if (strlen != 9) {
            this.errdef = "No of digits not matching for SSN";
            return false;
        }
        if (ssnnumber.startsWith("000") || ssnnumber.startsWith("666") || ssnnumber.startsWith("9") || ssnnumber.endsWith("0000") || ssnnumber.startsWith("00", 3)) {
            this.errdef = "Invalid digits for SSN";
            return false;
        }
        try {
            for (int i = 0; i < strlen; ++i) {
                Integer.parseInt(String.valueOf(ssnnumber.charAt(i)));
            }
        }
        catch (Exception e) {
            this.errdef = "Non Digit Values for SSN";
            return false;
        }
        this.errdef = "SSN Validation Successful";
        return true;
    }

    public boolean isPhone(String phonenum) {
        int strlen = phonenum.length();
        if (strlen > 12 || strlen < 8) {
            this.errdef = "No of digits not matching";
            return false;
        }
        if (phonenum.startsWith("0000")) {
            return false;
        }
        this.errdef = "Phone Validation Successful";
        return true;
    }

    public boolean isEmails(String[] emailStr) {
        boolean allEmail = false;
        for (String email : emailStr) {
            allEmail = this.isEmail(email);
            if (allEmail) continue;
            return false;
        }
        this.errdef = "Email Validation successful";
        return true;
    }

    public boolean isEmail(String emailStr) {
        String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
        Pattern pattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
        Matcher matcher = pattern.matcher(emailStr);
        if (!matcher.matches()) {
            this.errdef = "Not well formed email";
            return false;
        }
        this.errdef = "Email Validation successful";
        return true;
    }

    public boolean isDoB(Date dob) {
        long nowmilliSec;
        long dobmilliSec = dob.getTime();
        if (dobmilliSec > (nowmilliSec = System.currentTimeMillis())) {
            this.errdef = "Dob is after today's date";
            return false;
        }
        this.errdef = "Date of Birth Validation successful";
        return true;
    }

    public boolean isIp(String ipaddress) {
        Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
        Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
        Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");
        if (IPV4_PATTERN.matcher(ipaddress).matches() || IPV6_STD_PATTERN.matcher(ipaddress).matches() || IPV6_HEX_COMPRESSED_PATTERN.matcher(ipaddress).matches()) {
            this.errdef = "IP Validation successful";
            return true;
        }
        this.errdef = "Not well formed IP";
        return false;
    }

    public String getErrdef() {
        return this.errdef;
    }
}

