/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.analytics;

import java.util.Vector;

public class SetAnalysis {
    private String errstr = "";
    private Vector<Object> smallSet;
    private Vector<Object> bigSet;

    public SetAnalysis(Vector<Object> setA, Vector<Object> setB) throws NullPointerException {
        if (setA == null || setB == null) {
            NullPointerException e = new NullPointerException();
            throw e;
        }
        if (setA.size() > setB.size()) {
            this.smallSet = setB;
            this.bigSet = setA;
        } else {
            this.smallSet = setA;
            this.bigSet = setB;
        }
    }

    public Vector<Object> getIntersection() {
        Vector<Object> resultSet = null;
        int ilen = this.smallSet.size();
        if (ilen == 0 || this.bigSet.size() == 0) {
            this.errstr = "Not Valid sets for Intersection";
            return resultSet;
        }
        resultSet = new Vector<Object>();
        for (int i = 0; i < ilen; ++i) {
            Object o = this.smallSet.get(i);
            if (this.bigSet.indexOf(o) == -1) continue;
            resultSet.add(o);
        }
        return resultSet;
    }

    public Vector<Object> getUnion() {
        Vector<Object> resultSet = null;
        int ilen = this.smallSet.size();
        if (ilen == 0) {
            this.errstr = "Not Valid sets for Union";
            return this.bigSet;
        }
        resultSet = new Vector<Object>();
        for (int i = 0; i < ilen; ++i) {
            Object o = this.smallSet.get(i);
            if (resultSet.indexOf(o) != -1) continue;
            resultSet.add(o);
        }
        int ilenB = this.bigSet.size();
        for (int i = 0; i < ilenB; ++i) {
            Object o = this.bigSet.get(i);
            if (resultSet.indexOf(o) != -1) continue;
            resultSet.add(o);
        }
        return resultSet;
    }

    public Vector<Object[]> getCartesian(Vector<Object> first, Vector<Object> second) {
        Vector<Object[]> resultSet = null;
        int ilen = first.size();
        int ilenB = second.size();
        if (ilen == 0 || ilenB == 0) {
            this.errstr = "Not Valid sets for Cartesian";
            return resultSet;
        }
        resultSet = new Vector<Object[]>();
        for (int i = 0; i < ilen; ++i) {
            for (int j = 0; j < ilenB; ++j) {
                Object[] cartS = new Object[]{first.get(i), second.get(j)};
                resultSet.add(cartS);
            }
        }
        return resultSet;
    }

    public Vector<Object> getDifference(Vector<Object> first, Vector<Object> second) {
        Vector<Object> resultSet = new Vector<Object>();
        int ilen = first.size();
        for (int i = 0; i < ilen; ++i) {
            Object o = first.get(i);
            if (second.indexOf(o) != -1) continue;
            resultSet.add(o);
        }
        this.errstr = "Difference Successful";
        return resultSet;
    }

    public boolean isSubset(Vector<Object> first, Vector<Object> second) {
        int ilen = first.size();
        for (int i = 0; i < ilen; ++i) {
            Object o = first.get(i);
            if (second.indexOf(o) != -1) continue;
            return false;
        }
        this.errstr = "Subset Successful";
        return true;
    }

    public String getErrstr() {
        return this.errstr;
    }
}

