/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.dataquality;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RecordMatch {
    static ConcurrentMap<String, String> biclassmap;
    static ConcurrentMap<String, Map.Entry<Method, Object>> functor;

    public static void main(String ... args) {
    }

    class fuzzyCompare
    implements Comparator<List<String>> {
        private MultiColData metaA;
        private float simMatchVal = 0.0f;

        public fuzzyCompare(MultiColData metaA, boolean bycell) {
            this.metaA = metaA;
        }

        public float getsimMatchVal() {
            return this.simMatchVal;
        }

        @Override
        public int compare(List<String> o1, List<String> o2) {
            boolean exactMatch = this.metaA.isExactMatch();
            boolean atLeastOneMatch = false;
            try {
                Map.Entry en = null;
                for (ColData dd : this.metaA.getA()) {
                    en = (Map.Entry)functor.get(dd.getM_algoName());
                    float matchprob = dd.getM_matchIndex();
                    if ((double)matchprob != 1.0) {
                        Object ob = ((Method)en.getKey()).invoke(en.getValue(), o1.get(dd.getM_colIndexA()), o2.get(dd.getM_colIndexB()));
                        this.simMatchVal = ((Float)ob).floatValue();
                        if (this.simMatchVal < matchprob) {
                            if (exactMatch) {
                                return -1;
                            }
                        } else {
                            atLeastOneMatch = true;
                            if (!exactMatch) {
                                break;
                            }
                        }
                    } else if (o1.get(dd.getM_colIndexA()).compareToIgnoreCase(o2.get(dd.getM_colIndexB())) == 0) {
                        this.simMatchVal = 1.0f;
                        atLeastOneMatch = true;
                        if (!exactMatch) {
                            break;
                        }
                    } else {
                        this.simMatchVal = 0.0f;
                        if (exactMatch) {
                            return -1;
                        }
                    }
                    en = null;
                }
            }
            catch (InvocationTargetException x) {
                x.printStackTrace();
                return 1;
            }
            catch (IllegalAccessException x) {
                x.printStackTrace();
                return 1;
            }
            if (exactMatch) {
                return 0;
            }
            if (atLeastOneMatch) {
                return 0;
            }
            return -1;
        }
    }

    class recordSorter
    implements Comparator<List<String>> {
        private MultiColData meta;
        boolean leftSide;

        public recordSorter(MultiColData metaA, boolean leftSide) {
            this.meta = metaA;
            this.leftSide = leftSide;
        }

        @Override
        public int compare(List<String> o1, List<String> o2) {
            StringBuilder lA = new StringBuilder();
            StringBuilder lB = new StringBuilder();
            for (ColData dd : this.meta.getA()) {
                if (this.leftSide) {
                    lA = lA.append(o1.get(dd.getM_colIndexA()));
                    lB = lB.append(o2.get(dd.getM_colIndexA()));
                    continue;
                }
                lA = lA.append(o1.get(dd.getM_colIndexA()));
                lB = lB.append(o2.get(dd.getM_colIndexA()));
            }
            return lA.toString().compareTo(lB.toString());
        }
    }

    public class operator {
        public operator() {
            biclassmap = new ConcurrentHashMap<String, String>();
            functor = new ConcurrentHashMap<String, Map.Entry<Method, Object>>();
            biclassmap.put("org.simmetrics.metrics.Jaro", "compare");
            biclassmap.put("org.simmetrics.metrics.JaroWinkler", "compare");
            biclassmap.put("org.simmetrics.metrics.Levenshtein", "compare");
            biclassmap.put("org.simmetrics.metrics.NeedlemanWunch", "compare");
            biclassmap.put("org.simmetrics.metrics.SmithWaterman", "compare");
            biclassmap.put("org.simmetrics.metrics.SmithWatermanGotoh", "compare");
            for (Map.Entry m : biclassmap.entrySet()) {
                try {
                    String methodName = (String)m.getValue();
                    String className = (String)m.getKey();
                    Class<?> cls = Class.forName(className);
                    Object ob = cls.newInstance();
                    functor.put(new String(className.substring(className.lastIndexOf(46) + 1, className.length()).toUpperCase()), new AbstractMap.SimpleEntry(cls.getDeclaredMethod(methodName, String.class, String.class), ob));
                }
                catch (ClassNotFoundException cfe) {
                    System.err.println("Class not found " + cfe.toString());
                    System.err.println("Please make sure simmetrics_core-3.0.0.jar in CLASSPATH");
                    return;
                }
                catch (NoSuchMethodException nm) {
                    System.err.println("Method not found " + nm.toString());
                    return;
                }
                catch (Exception exp) {
                    System.err.println("Exception: " + exp.toString());
                    return;
                }
            }
        }

        public List<Result> compare(final List<List<String>> left, final List<List<String>> right, MultiColData meta1, MultiColData meta2) {
            int i;
            final fuzzyCompare fz = new fuzzyCompare(meta1, false);
            final List<Result> matched = Collections.synchronizedList(new ArrayList());
            final boolean firstRecordMatch = meta1.isFirstRecordMatch();
            int THREADCOUNT = 10;
            Thread[] tid = new Thread[10];
            final int rowthread = left.size() / 10;
            for (i = 0; i < 10; ++i) {
                final int tindex = i;
                tid[tindex] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int lIndex = tindex * rowthread;
                        int rIndex = 0;
                        List leftsub = tindex < 9 ? left.subList(tindex * rowthread, tindex * rowthread + rowthread) : left.subList(tindex * rowthread, left.size());
                        try {
                            for (List l : leftsub) {
                                boolean atleastOneRecordmatch = false;
                                for (List r : right) {
                                    if (fz.compare(l, r) == 0) {
                                        atleastOneRecordmatch = true;
                                        matched.add(new Result(true, lIndex, rIndex, l, r, fz.simMatchVal));
                                        if (firstRecordMatch) break;
                                    }
                                    ++rIndex;
                                }
                                if (!atleastOneRecordmatch) {
                                    // empty if block
                                }
                                ++lIndex;
                                rIndex = 0;
                            }
                        }
                        catch (Exception e) {
                            System.out.println(" Thread Comparison Exeception:" + e.getMessage());
                        }
                    }
                });
                tid[i].start();
            }
            for (i = 0; i < 10; ++i) {
                try {
                    tid[i].join();
                    continue;
                }
                catch (Exception e) {
                    System.out.println(" Thread Exeception:" + e.getMessage());
                }
            }
            matched.sort(null);
            return matched;
        }
    }

    public class MultiColData {
        private List<ColData> colA = new ArrayList<ColData>();
        private List<ColData> colB = new ArrayList<ColData>();
        private String algoName = new String();
        private boolean exactMatch = true;
        private boolean firstRecordMatch;

        public MultiColData() {
            this.setFirstRecordMatch(false);
        }

        public List<ColData> getA() {
            return this.colA;
        }

        public List<ColData> getB() {
            return this.colB;
        }

        public void setA(List<ColData> a) {
            this.colA.addAll(a);
        }

        public void setB(List<ColData> b) {
            this.colB.addAll(b);
        }

        public String getAlgoName() {
            return this.algoName;
        }

        public void setAlgoName(String algoName) {
            this.algoName = algoName;
        }

        public boolean isExactMatch() {
            return this.exactMatch;
        }

        public void setExactMatch(boolean exactMatch) {
            this.exactMatch = exactMatch;
        }

        public boolean isFirstRecordMatch() {
            return this.firstRecordMatch;
        }

        public void setFirstRecordMatch(boolean firstRecordMatch) {
            this.firstRecordMatch = firstRecordMatch;
        }
    }

    public class ColData {
        private int m_colIndexA;
        private int m_colIndexB;
        private float m_matchIndex;
        private String m_algoName;

        public ColData(int colIndexA, int colIndexB, float matchIndex, String algoName) {
            this.m_colIndexA = colIndexA;
            this.m_colIndexB = colIndexB;
            this.m_matchIndex = matchIndex;
            this.m_algoName = algoName;
        }

        public float getM_matchIndex() {
            return this.m_matchIndex;
        }

        public void setM_matchIndex(float m_matchIndex) {
            this.m_matchIndex = m_matchIndex;
        }

        public int getM_colIndexA() {
            return this.m_colIndexA;
        }

        public void setM_colIndexA(int m_colIndexA) {
            this.m_colIndexA = m_colIndexA;
        }

        public int getM_colIndexB() {
            return this.m_colIndexB;
        }

        public void setM_colIndexB(int m_colIndexB) {
            this.m_colIndexB = m_colIndexB;
        }

        public String getM_algoName() {
            return this.m_algoName;
        }

        public void setM_algoName(String m_algoName) {
            this.m_algoName = m_algoName;
        }
    }

    public class Result
    implements Comparable<Object> {
        int index1;
        int index2;
        List<String> record1;
        List<String> record2;
        boolean isMatch;
        float simMatchValResult;

        Result(boolean isMatch, int index1, int index2, List<String> record1, List<String> record2, float simMatchVal) {
            this.isMatch = isMatch;
            this.index1 = index1;
            this.simMatchValResult = simMatchVal;
            if (isMatch) {
                this.index2 = index2;
                this.record1 = new ArrayList<String>(record1);
                this.record2 = new ArrayList<String>(record2);
            }
        }

        public int getLeftMatchIndex() {
            return this.index1;
        }

        public int getRightMatchIndex() {
            return this.index2;
        }

        public List<String> getLeftMatchedRow() {
            return this.record1;
        }

        public List<String> getRightMatchedRow() {
            return this.record2;
        }

        public boolean isMatch() {
            return this.isMatch;
        }

        public float getSimMatchVal() {
            return this.simMatchValResult;
        }

        public String toString() {
            if (this.isMatch) {
                return "Index [" + this.index1 + "] matched [" + this.index2 + "]";
            }
            return "Index [" + this.index1 + "] no match";
        }

        @Override
        public int compareTo(Object o) {
            Result newo = (Result)o;
            if (this.index1 > newo.index1) {
                return 1;
            }
            if (this.index1 < newo.index1) {
                return -1;
            }
            return 0;
        }
    }
}

