/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.hadooputil;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.arrah.framework.rdbms.QueryBuilder;
import org.arrah.framework.rdbms.Rdbms_conn;

public class HiveQueryBuilder
extends QueryBuilder {
    public HiveQueryBuilder(String Dsn, String Table, String Column, String DBType) {
        super(Dsn, Table, Column, DBType);
    }

    public HiveQueryBuilder(String Dsn, String Table, String DBType) {
        super(Dsn, Table, DBType);
    }

    public HiveQueryBuilder(String Dsn, String DBType) {
        super(Dsn, DBType);
    }

    public String appendHiveTable(String filePath, String tableName, boolean isLocal, boolean isOverWrite, String partition) {
        String local = "";
        if (isLocal) {
            local = "LOCAL";
        }
        String overWrite = "";
        if (isOverWrite) {
            overWrite = " OVERWRITE ";
        }
        String query = "LOAD DATA " + local + " INPATH " + filePath + overWrite + "INTO TABLE " + this._table;
        if (partition != null && !"".equals(partition)) {
            query = query + " PARTITION " + partition;
        }
        return query;
    }

    public String descHiveTable() {
        String query = "DESCRIBE FORMATTED " + this._table;
        return query;
    }

    public String createRDBMSTable(String colDesc, String tbName, String constraintDesc) {
        String strrC = null;
        String s1C = null;
        int constraintCount = 0;
        String createQuery = "";
        boolean isConstraint = false;
        if (colDesc != null && colDesc.length() > 1) {
            colDesc = colDesc.replace(",", " ");
            colDesc = colDesc.replace(":", ",");
        }
        if (constraintDesc != null && constraintDesc.length() > 0) {
            String[] constraintDescArray = constraintDesc.split(":");
            constraintCount = constraintDescArray.length;
            ArrayList<String> constraints = new ArrayList<String>();
            for (int i = 0; i < constraintCount; ++i) {
                constraints.add(constraintDescArray[i]);
            }
            int noc1 = constraints.size();
            isConstraint = true;
            for (int i = 0; i < noc1; ++i) {
                s1C = ((String)constraints.get(i)).replace(",", " ");
                s1C = s1C.replace(";", ",");
                if (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("Informix") == 0) {
                    if (strrC == null || "".equals(strrC)) {
                        strrC = s1C;
                        continue;
                    }
                    strrC = strrC + ", " + s1C + " ";
                    continue;
                }
                strrC = strrC == null || "".equals(strrC) ? "CONSTRAINT " + s1C : strrC + " ," + " CONSTRAINT " + s1C + " ";
            }
        }
        if (isConstraint) {
            createQuery = "CREATE TABLE " + tbName + "(" + colDesc + " ," + strrC + ")";
        } else {
            strrC = " ";
            createQuery = "CREATE TABLE " + tbName + "(" + colDesc + ")";
        }
        System.out.println("Create Table Query is:" + createQuery);
        return createQuery;
    }

    public String createHiveTable(String tbName, String colDesc, String partColDesc, String fieldedelim) {
        String createQuery = "CREATE TABLE " + tbName;
        if (colDesc != null && colDesc.length() > 1) {
            colDesc = colDesc.replace(",", " ");
            colDesc = colDesc.replace(":", ",");
            createQuery = createQuery + " (" + colDesc + ")";
        }
        if (partColDesc != null && partColDesc.length() > 1) {
            partColDesc = partColDesc.replace(",", " ");
            partColDesc = partColDesc.replace(":", ",");
            createQuery = createQuery + " PARTITIONED BY (" + partColDesc + ")";
        }
        if (fieldedelim != null) {
            createQuery = createQuery + "ROW FORMAT DELIMITED FIELDS TERMINATED BY '" + fieldedelim + "'";
        }
        System.out.println("Hive Table Create Query:" + createQuery);
        return createQuery;
    }

    public static String prepareHiveParam(int type, Object param) {
        String formatParam = "";
        if (param instanceof Number) {
            return param.toString();
        }
        if (param instanceof Date) {
            SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return "unix_timestamp('" + sd.format(param) + "')";
        }
        if (param instanceof String || param instanceof Character) {
            return "'" + param + "'";
        }
        if (param instanceof Boolean) {
            if (((Boolean)param).booleanValue()) {
                return "TRUE";
            }
            return "FALSE";
        }
        if (param instanceof Byte) {
            return param.toString();
        }
        return formatParam;
    }

    public String get_hiveequal_query(Vector<?> col_vc, Vector<Integer> vc_t, Vector<Object> vc_v, String condition) {
        String equal_query = "";
        String columns = "";
        String column = "";
        Enumeration<?> cols = col_vc.elements();
        int i = 0;
        while (cols.hasMoreElements()) {
            column = cols.nextElement().toString();
            if (!(this._dtype.compareToIgnoreCase("mysql") == 0 || this._dtype.compareToIgnoreCase("hive") == 0 || this._dtype.compareToIgnoreCase("ms_access_jdbc") == 0 || this._dtype.compareToIgnoreCase("informix") == 0 || this._dtype.compareToIgnoreCase("Others") == 0 && Rdbms_conn.getHValue("Database_SupportQuote").compareToIgnoreCase("NO") == 0 || column.startsWith("\""))) {
                column = "\"" + column + "\"";
            }
            String param = HiveQueryBuilder.prepareHiveParam(vc_t.get(i), vc_v.get(i));
            column = cols.hasMoreElements() ? column + "=" + param + " AND " : column + "=" + param;
            columns = columns + column;
            ++i;
        }
        equal_query = "SELECT * from " + this._table + " WHERE " + columns;
        if (condition != null && !"".equals(condition)) {
            equal_query = equal_query + " AND (" + condition + ")";
        }
        return equal_query;
    }
}

