/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.profile;

import java.util.Arrays;
import java.util.Vector;
import org.arrah.framework.ndtable.ReportTableModel;

public class StatisticalAnalysis {
    private Object[] _colObj;
    private boolean isNumber = true;
    private ReportTableModel freq_t = new ReportTableModel(new String[]{"Record Value", "Frequency", "% Freq."}, false, true);
    private ReportTableModel range_t = new ReportTableModel(new String[]{"Range Metric", "Metric Value"});
    private ReportTableModel perc_t = new ReportTableModel(new String[]{"Percentile %", "Record Upper Value", "Samples Below"});
    private double count;
    private double sum;
    private double avg;
    private double variance = 0.0;
    private double aad = 0.0;
    private double skew = 0.0;
    private double kurt = 0.0;
    private double[] perv_a = new double[21];
    private long[] perc_a = new long[21];

    public StatisticalAnalysis(Object[] colValue) {
        int colC = colValue.length;
        if (colC <= 0) {
            System.out.println("No Value for Analysis. Empty Column Data");
            return;
        }
        Vector<Object> vc = new Vector<Object>();
        for (int index = 0; index < colC; ++index) {
            if (colValue[index] == null) continue;
            vc.add(colValue[index]);
            if (this.isNumber && colValue[index] instanceof Number) {
                this.sum += ((Number)colValue[index]).doubleValue();
                continue;
            }
            this.isNumber = false;
        }
        this._colObj = vc.toArray();
        Arrays.sort(this._colObj);
        this.analyseValue();
    }

    public void analyseValue() {
        this.count = this._colObj.length;
        this.avg = this.sum / this.count;
        int freq_c = 1;
        int c = 0;
        Object prev_obj = null;
        Object curr_obj = null;
        int arr_i = 0;
        int dataset_c = 1;
        this.perc_a[0] = Math.round(this.count / 100.0);
        if (this.perc_a[0] == 0L) {
            arr_i = 1;
            this.perv_a[0] = 0.0;
        }
        for (int i = 1; i < 20; ++i) {
            this.perc_a[i] = Math.round((double)(5 * i) * this.count / 100.0);
            if (this.perc_a[i] != 0L) continue;
            ++arr_i;
            this.perv_a[i] = 0.0;
        }
        this.perc_a[20] = Math.round(99.0 * this.count / 100.0);
        if (this.perc_a[20] == 0L) {
            arr_i = 21;
            this.perv_a[20] = 0.0;
        }
        c = 0;
        while ((double)c < this.count) {
            curr_obj = this._colObj[c];
            if (curr_obj.equals(prev_obj)) {
                ++freq_c;
            } else {
                if (prev_obj != null) {
                    this.freq_t.addFillRow(new Object[]{prev_obj, new Integer(freq_c), new Double((double)freq_c / this.count * 100.0)});
                }
                freq_c = 1;
                prev_obj = curr_obj;
            }
            if (this.isNumber) {
                double d = ((Number)curr_obj).doubleValue();
                if (arr_i < 21 && (long)dataset_c == this.perc_a[arr_i]) {
                    while (arr_i < 20 && this.perc_a[arr_i + 1] == this.perc_a[arr_i]) {
                        this.perv_a[arr_i] = d;
                        ++arr_i;
                    }
                    this.perv_a[arr_i] = d;
                    ++arr_i;
                }
                this.aad += Math.abs(d - this.avg) / this.count;
                this.variance += Math.pow(d - this.avg, 2.0) / (this.count - 1.0);
                this.skew += Math.pow(d - this.avg, 3.0);
                this.kurt += Math.pow(d - this.avg, 4.0);
                ++dataset_c;
            }
            ++c;
        }
        if (prev_obj != null) {
            this.freq_t.addFillRow(new Object[]{prev_obj, new Integer(freq_c), new Double((double)freq_c / this.count * 100.0)});
        }
        this.fillDataIntoTable();
    }

    public ReportTableModel getFrequencyTable() {
        return this.freq_t;
    }

    public ReportTableModel getRangeTable() {
        return this.range_t;
    }

    public ReportTableModel getPercTable() {
        return this.perc_t;
    }

    public Object[] getColObject() {
        return this._colObj;
    }

    public boolean isObjNumber() {
        return this.isNumber;
    }

    public double getMean() {
        return this.avg;
    }

    public double getVariance() {
        return this.variance;
    }

    public double getSDev() {
        return Math.sqrt(this.variance);
    }

    public Object getMinObject() {
        return this._colObj[0];
    }

    public Object getMaxObject() {
        return this._colObj[this._colObj.length - 1];
    }

    public double rangeObject() {
        if (this._colObj[0] instanceof Number && this._colObj[this._colObj.length - 1] instanceof Number) {
            return ((Number)this._colObj[this._colObj.length - 1]).doubleValue() - ((Number)this._colObj[0]).doubleValue();
        }
        return 0.0;
    }

    private void fillDataIntoTable() {
        this.range_t.addFillRow(new String[]{"Total Record Count", String.valueOf(this.count)});
        this.range_t.addFillRow(new String[]{"Maximum Value ", String.valueOf(this._colObj[this._colObj.length - 1])});
        this.range_t.addFillRow(new String[]{"Minimum Value ", String.valueOf(this._colObj[0])});
        if (this.isNumber) {
            this.range_t.addFillRow(new String[]{"Range(Max-Min)", String.valueOf(((Number)this._colObj[this._colObj.length - 1]).doubleValue() - ((Number)this._colObj[0]).doubleValue())});
            this.range_t.addFillRow(new String[]{"Total Record Sum", String.valueOf(this.sum)});
            this.range_t.addRow();
            this.range_t.addFillRow(new String[]{"Mean Value", String.valueOf(this.avg)});
            this.range_t.addFillRow(new String[]{"Avg. Absolute Dev.(AAD)", Double.toString(this.aad)});
            this.range_t.addFillRow(new String[]{"Variance", Double.toString(this.variance)});
            this.range_t.addFillRow(new String[]{"Std. Dev.(SD)", Double.toString(Math.sqrt(this.variance))});
            this.range_t.addFillRow(new String[]{"Std. Error of Mean(SE)", Double.toString(Math.sqrt(this.variance) / Math.sqrt(this.count))});
            this.range_t.addFillRow(new String[]{"Skewness", Double.toString(this.skew / ((this.count - 1.0) * Math.pow(this.variance, 1.5)))});
            this.range_t.addFillRow(new String[]{"Kurtosis", Double.toString(this.kurt / ((this.count - 1.0) * Math.pow(this.variance, 2.0)))});
            this.range_t.addRow();
            this.range_t.addFillRow(new String[]{"Mid Range Value", String.valueOf((((Number)this._colObj[this._colObj.length - 1]).doubleValue() + ((Number)this._colObj[0]).doubleValue()) / 2.0)});
            if (this.perc_a[0] > 0L) {
                this.range_t.addFillRow(new String[]{"Mid Range(1%-99%)", Double.toString((this.perv_a[0] + this.perv_a[20]) / 2.0)});
            }
            if (this.perc_a[1] > 0L) {
                this.range_t.addFillRow(new String[]{"Mid Range(5%-95%)", Double.toString((this.perv_a[1] + this.perv_a[19]) / 2.0)});
            }
            if (this.perc_a[2] > 0L) {
                this.range_t.addFillRow(new String[]{"Mid Range(10%-90%)", Double.toString((this.perv_a[2] + this.perv_a[18]) / 2.0)});
            }
            if (this.perc_a[3] > 0L) {
                this.range_t.addFillRow(new String[]{"Mid Range(15%-85%)", Double.toString((this.perv_a[3] + this.perv_a[17]) / 2.0)});
            }
            if (this.perc_a[4] > 0L) {
                this.range_t.addFillRow(new String[]{"Mid Range(20%-80%)", Double.toString((this.perv_a[4] + this.perv_a[16]) / 2.0)});
            }
            if (this.perc_a[5] > 0L) {
                this.range_t.addFillRow(new String[]{"Mid Range(25%-75%)", Double.toString((this.perv_a[5] + this.perv_a[15]) / 2.0)});
            }
            if (this.perc_a[6] > 0L) {
                this.range_t.addFillRow(new String[]{"Mid Range(30%-70%)", Double.toString((this.perv_a[6] + this.perv_a[14]) / 2.0)});
            }
            if (this.perc_a[7] > 0L) {
                this.range_t.addFillRow(new String[]{"Mid Range(35%-65%)", Double.toString((this.perv_a[7] + this.perv_a[13]) / 2.0)});
            }
            if (this.perc_a[8] > 0L) {
                this.range_t.addFillRow(new String[]{"Mid Range(40%-60%)", Double.toString((this.perv_a[8] + this.perv_a[12]) / 2.0)});
            }
            this.perc_t.addFillRow(new String[]{"1", Double.toString(this.perv_a[0]), Long.toString(this.perc_a[0])});
            for (int i = 1; i < 20; ++i) {
                this.perc_t.addFillRow(new String[]{Integer.toString(i * 5), Double.toString(this.perv_a[i]), Long.toString(this.perc_a[i])});
            }
            this.perc_t.addFillRow(new String[]{"99", Double.toString(this.perv_a[20]), Long.toString(this.perc_a[20])});
        }
    }
}

