/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.profile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.arrah.framework.ndtable.ReportTableModel;

public class TimeStatisticalAnalysis {
    private Long[] _colObj;
    private ReportTableModel freq_t = new ReportTableModel(new String[]{"Date Value", "Frequency", "% Freq."}, false, true);
    private ReportTableModel range_t = new ReportTableModel(new String[]{"Date Range Metric", "Metric Value"});
    private ReportTableModel perc_t = new ReportTableModel(new String[]{"Percentile %", "Date Upper Value", "Records Below"});
    private double count;
    private double sum;
    private double avg;
    private double variance = 0.0;
    private double aad = 0.0;
    private double[] perv_a = new double[21];
    private long[] perc_a = new long[21];

    public TimeStatisticalAnalysis(Long[] colValue) {
        if (colValue.length <= 0) {
            return;
        }
        this._colObj = colValue;
        for (int i = 0; i < colValue.length; ++i) {
            this.sum += (double)this._colObj[i].longValue();
        }
        Arrays.sort((Object[])this._colObj);
        this.analyseValue();
    }

    public void analyseValue() {
        this.count = this._colObj.length;
        this.avg = this.sum / this.count;
        int freq_c = 1;
        int c = 0;
        Long prev_obj = null;
        Long curr_obj = null;
        int arr_i = 0;
        int dataset_c = 1;
        this.perc_a[0] = Math.round(this.count / 100.0);
        if (this.perc_a[0] == 0L) {
            arr_i = 1;
            this.perv_a[0] = 0.0;
        }
        for (int i = 1; i < 20; ++i) {
            this.perc_a[i] = Math.round((double)(5 * i) * this.count / 100.0);
            if (this.perc_a[i] != 0L) continue;
            ++arr_i;
            this.perv_a[i] = 0.0;
        }
        this.perc_a[20] = Math.round(99.0 * this.count / 100.0);
        if (this.perc_a[20] == 0L) {
            arr_i = 21;
            this.perv_a[20] = 0.0;
        }
        c = 0;
        while ((double)c < this.count) {
            curr_obj = this._colObj[c];
            if (((Object)curr_obj).equals(prev_obj)) {
                ++freq_c;
            } else {
                if (prev_obj != null) {
                    this.freq_t.addFillRow(new Object[]{new Date(prev_obj), new Integer(freq_c), new Double((double)freq_c / this.count * 100.0)});
                }
                freq_c = 1;
                prev_obj = curr_obj;
            }
            double d = ((Number)curr_obj).doubleValue();
            if (arr_i < 21 && (long)dataset_c == this.perc_a[arr_i]) {
                while (arr_i < 20 && this.perc_a[arr_i + 1] == this.perc_a[arr_i]) {
                    this.perv_a[arr_i] = d;
                    ++arr_i;
                }
                this.perv_a[arr_i] = d;
                ++arr_i;
            }
            this.aad += Math.abs(TimeStatisticalAnalysis.getDayVal((long)(d - this.avg))) / this.count;
            this.variance += Math.pow(TimeStatisticalAnalysis.getDayVal((long)(d - this.avg)), 2.0) / (this.count - 1.0);
            ++dataset_c;
            ++c;
        }
        if (prev_obj != null) {
            this.freq_t.addFillRow(new Object[]{new Date(prev_obj), new Integer(freq_c), new Double((double)freq_c / this.count * 100.0)});
        }
        this.fillDataIntoTable();
    }

    public ReportTableModel getFrequencyTable() {
        return this.freq_t;
    }

    public ReportTableModel getRangeTable() {
        return this.range_t;
    }

    public ReportTableModel getPercTable() {
        return this.perc_t;
    }

    public Object[] getColObject() {
        return this._colObj;
    }

    public ArrayList<Long> getColObjectArray() {
        ArrayList<Long> colO = new ArrayList<Long>();
        if (this._colObj == null) {
            return colO;
        }
        for (Long a : this._colObj) {
            colO.add(a);
        }
        return colO;
    }

    private void fillDataIntoTable() {
        Date localdate = new Date();
        this.range_t.addFillRow(new String[]{"Total Record Count", String.valueOf(this.count)});
        localdate.setTime(this._colObj[this._colObj.length - 1]);
        this.range_t.addFillRow(new String[]{"Maximum Date ", localdate.toString()});
        localdate.setTime(this._colObj[0]);
        this.range_t.addFillRow(new String[]{"Minimum Date ", localdate.toString()});
        double dayval = TimeStatisticalAnalysis.getDayVal(this._colObj[this._colObj.length - 1] - this._colObj[0]);
        this.range_t.addFillRow(new String[]{"Range(Max-Min) in Days", String.valueOf(dayval)});
        this.range_t.addRow();
        localdate.setTime((long)this.avg);
        this.range_t.addFillRow(new String[]{"Mean Value", localdate.toString()});
        this.range_t.addFillRow(new String[]{"Avg. Absolute Dev.(AAD) in Days", Double.toString(this.aad)});
        this.range_t.addFillRow(new String[]{"Variance in Days", Double.toString(this.variance)});
        this.range_t.addFillRow(new String[]{"Std. Dev.(SD) in Days", Double.toString(Math.sqrt(this.variance))});
        this.range_t.addFillRow(new String[]{"Std. Error of Mean(SE) in Days", Double.toString(Math.sqrt(this.variance) / Math.sqrt(this.count))});
        this.range_t.addRow();
        localdate.setTime((this._colObj[this._colObj.length - 1] + this._colObj[0]) / 2L);
        this.range_t.addFillRow(new String[]{"Mid Range Date Value", localdate.toString()});
        if (this.perc_a[0] > 0L) {
            localdate.setTime((long)(this.perv_a[0] + this.perv_a[20]) / 2L);
            this.range_t.addFillRow(new String[]{"Mid Range(1%-99%)", localdate.toString()});
        }
        if (this.perc_a[1] > 0L) {
            localdate.setTime((long)(this.perv_a[1] + this.perv_a[19]) / 2L);
            this.range_t.addFillRow(new String[]{"Mid Range(5%-95%)", localdate.toString()});
        }
        if (this.perc_a[2] > 0L) {
            localdate.setTime((long)(this.perv_a[2] + this.perv_a[18]) / 2L);
            this.range_t.addFillRow(new String[]{"Mid Range(10%-90%)", localdate.toString()});
        }
        if (this.perc_a[3] > 0L) {
            localdate.setTime((long)(this.perv_a[3] + this.perv_a[17]) / 2L);
            this.range_t.addFillRow(new String[]{"Mid Range(15%-85%)", localdate.toString()});
        }
        if (this.perc_a[4] > 0L) {
            localdate.setTime((long)(this.perv_a[4] + this.perv_a[16]) / 2L);
            this.range_t.addFillRow(new String[]{"Mid Range(20%-80%)", localdate.toString()});
        }
        if (this.perc_a[5] > 0L) {
            localdate.setTime((long)(this.perv_a[5] + this.perv_a[15]) / 2L);
            this.range_t.addFillRow(new String[]{"Mid Range(25%-75%)", localdate.toString()});
        }
        if (this.perc_a[6] > 0L) {
            localdate.setTime((long)(this.perv_a[6] + this.perv_a[14]) / 2L);
            this.range_t.addFillRow(new String[]{"Mid Range(30%-70%)", localdate.toString()});
        }
        if (this.perc_a[7] > 0L) {
            localdate.setTime((long)(this.perv_a[7] + this.perv_a[13]) / 2L);
            this.range_t.addFillRow(new String[]{"Mid Range(35%-65%)", localdate.toString()});
        }
        if (this.perc_a[8] > 0L) {
            localdate.setTime((long)(this.perv_a[8] + this.perv_a[12]) / 2L);
            this.range_t.addFillRow(new String[]{"Mid Range(40%-60%)", localdate.toString()});
        }
        if (this.perc_a[9] > 0L) {
            localdate.setTime((long)(this.perv_a[9] + this.perv_a[11]) / 2L);
            this.range_t.addFillRow(new String[]{"Mid Range(45%-55%)", localdate.toString()});
        }
        localdate.setTime((long)this.perv_a[0]);
        this.perc_t.addFillRow(new String[]{"1", localdate.toString(), Long.toString(this.perc_a[0])});
        for (int i = 1; i < 20; ++i) {
            localdate.setTime((long)this.perv_a[i]);
            this.perc_t.addFillRow(new String[]{Integer.toString(i * 5), localdate.toString(), Long.toString(this.perc_a[i])});
        }
        localdate.setTime((long)this.perv_a[20]);
        this.perc_t.addFillRow(new String[]{"99", localdate.toString(), Long.toString(this.perc_a[20])});
    }

    public static double getDayVal(long milliSec) {
        return milliSec / 86400000L;
    }
}

