/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.rdbms;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arrah.framework.profile.TableMetaInfo;
import org.arrah.framework.rdbms.Rdbms_NewConn;
import org.arrah.framework.rdbms.Rdbms_conn;

public class QueryBuilder {
    protected String _dsn;
    protected String _table;
    protected String _column;
    protected String _dtype;
    protected String _table1;
    protected String _column1;
    private static boolean isCond = false;
    private static String _cond_q = "";
    private static Vector<?>[] dateVar;

    public QueryBuilder() {
    }

    public QueryBuilder(String Dsn, String Table, String Column, String DBType) {
        String cat;
        this.set_dsn(Dsn);
        this._table = Table;
        this._column = Column;
        this._dtype = DBType;
        if (this._dtype.compareToIgnoreCase("mysql") != 0 && this._dtype.compareToIgnoreCase("hive") != 0 && this._dtype.compareToIgnoreCase("informix") != 0 && this._dtype.compareToIgnoreCase("ms_access_jdbc") != 0 && (this._dtype.compareToIgnoreCase("Others") != 0 || Rdbms_conn.getHValue("Database_SupportQuote").compareToIgnoreCase("NO") != 0)) {
            if (!this._table.startsWith("\"")) {
                this._table = "\"" + this._table + "\"";
            }
            if (!this._column.startsWith("\"")) {
                this._column = "\"" + this._column + "\"";
            }
        }
        if ((cat = Rdbms_conn.getHValue("Database_Catalog")) != null && !"".equals(cat)) {
            this._table = cat + "." + this._table;
        }
    }

    public QueryBuilder(String Dsn, String Table, String DBType) {
        String cat;
        this.set_dsn(Dsn);
        this._table = Table;
        this._column = "";
        this._dtype = DBType;
        if (!(this._dtype.compareToIgnoreCase("mysql") == 0 || this._dtype.compareToIgnoreCase("hive") == 0 || this._dtype.compareToIgnoreCase("Informix") == 0 || this._dtype.compareToIgnoreCase("ms_access_jdbc") == 0 || this._dtype.compareToIgnoreCase("Others") == 0 && Rdbms_conn.getHValue("Database_SupportQuote").compareToIgnoreCase("NO") == 0 || this._table.startsWith("\""))) {
            this._table = "\"" + this._table + "\"";
        }
        if ((cat = Rdbms_conn.getHValue("Database_Catalog")) != null && !"".equals(cat)) {
            this._table = cat + "." + this._table;
        }
    }

    public QueryBuilder(String Dsn, String DBType) {
        this.set_dsn(Dsn);
        this._dtype = DBType;
    }

    public void setCTableCol(String Table, String Column) {
        String cat;
        this._table1 = Table;
        this._column1 = Column;
        if (this._dtype.compareToIgnoreCase("mysql") != 0 && this._dtype.compareToIgnoreCase("hive") != 0 && this._dtype.compareToIgnoreCase("informix") != 0 && this._dtype.compareToIgnoreCase("ms_access_jdbc") != 0 && (this._dtype.compareToIgnoreCase("Others") != 0 || Rdbms_conn.getHValue("Database_SupportQuote").compareToIgnoreCase("NO") != 0)) {
            if (!this._table1.startsWith("\"")) {
                this._table1 = "\"" + this._table1 + "\"";
            }
            if (!this._column1.startsWith("\"")) {
                this._column1 = "\"" + this._column1 + "\"";
            }
        }
        if ((cat = Rdbms_conn.getHValue("Database_Catalog")) != null && !"".equals(cat)) {
            this._table1 = cat + "." + this._table1;
        }
    }

    public String get_tableAll_query() {
        String allTable = "SELECT * FROM " + this._table;
        return allTable;
    }

    public String get_tableCount_query() {
        String allCount = "SELECT count(*) as row_count FROM " + this._table;
        return allCount;
    }

    public String count_query(boolean distinct, String col_name) {
        String count_query = "";
        if (!distinct) {
            count_query = " SELECT count(" + this._column + ") as " + col_name + " FROM " + this._table;
            if (isCond) {
                count_query = count_query + " WHERE " + _cond_q;
            }
        } else {
            count_query = "SELECT count(*) as " + col_name + " FROM ( SELECT DISTINCT " + this._column + " FROM " + this._table + " WHERE " + this._column + " IS NOT NULL ";
            if (isCond) {
                count_query = count_query + " AND " + _cond_q;
            }
            count_query = this._dtype.compareToIgnoreCase("sql_server") == 0 || this._dtype.compareToIgnoreCase("mysql") == 0 || this._dtype.compareToIgnoreCase("postgres") == 0 || this._dtype.compareToIgnoreCase("teiid") == 0 || this._dtype.compareToIgnoreCase("splice") == 0 ? count_query + " ) as AS1" : (this._dtype.compareToIgnoreCase("hive") == 0 ? count_query + " ) t1" : count_query + " )");
        }
        return count_query;
    }

    public String count_query_w(boolean distinct, String col_name) {
        String count_query = "";
        if (!distinct) {
            count_query = " SELECT count(" + this._column + ") as " + col_name + " FROM " + this._table;
        } else {
            count_query = "SELECT count(*) as " + col_name + " FROM ( SELECT DISTINCT " + this._column + " FROM " + this._table + " WHERE " + this._column + " IS NOT NULL ";
            count_query = this._dtype.compareToIgnoreCase("sql_server") == 0 || this._dtype.compareToIgnoreCase("mysql") == 0 || this._dtype.compareToIgnoreCase("postgres") == 0 || this._dtype.compareToIgnoreCase("teiid") == 0 || this._dtype.compareToIgnoreCase("splice") == 0 ? count_query + " ) as AS1" : (this._dtype.compareToIgnoreCase("hive") == 0 ? count_query + " ) t1" : count_query + " )");
        }
        return count_query;
    }

    public String bottom_query(boolean distinct, String col_name, String num) {
        String distinct_str = "";
        String bottom_sel_query = "";
        if (distinct) {
            distinct_str = " DISTINCT ";
        }
        if (this._dtype.compareToIgnoreCase("oracle_native") == 0 || this._dtype.compareToIgnoreCase("oracle_odbc") == 0) {
            bottom_sel_query = " SELECT " + this._column + " as " + col_name + " FROM " + " (SELECT " + distinct_str + this._column + " FROM " + this._table;
            if (isCond) {
                bottom_sel_query = bottom_sel_query + " WHERE " + _cond_q;
            }
            bottom_sel_query = bottom_sel_query + " order by " + this._column + ") WHERE rownum <= " + num;
        } else if (this._dtype.compareToIgnoreCase("mysql") == 0 || this._dtype.compareToIgnoreCase("postgres") == 0 || this._dtype.compareToIgnoreCase("ms_access_jdbc") == 0 || this._dtype.compareToIgnoreCase("teiid") == 0 || this._dtype.compareToIgnoreCase("db2") == 0) {
            bottom_sel_query = " SELECT " + distinct_str + " " + this._column + " as " + col_name + " FROM " + this._table;
            if (isCond) {
                bottom_sel_query = bottom_sel_query + " WHERE " + _cond_q;
            }
            bottom_sel_query = this._dtype.compareToIgnoreCase("teiid") == 0 ? bottom_sel_query + " order by " + this._column + " LIMIT " + num : bottom_sel_query + " order by " + this._column + " LIMIT " + num + " OFFSET 0";
        } else if (this._dtype.compareToIgnoreCase("hive") == 0) {
            bottom_sel_query = " SELECT " + this._column + " as " + col_name + " FROM ( ";
            bottom_sel_query = bottom_sel_query + " SELECT " + distinct_str + " " + this._column + " FROM " + this._table;
            if (isCond) {
                bottom_sel_query = bottom_sel_query + " WHERE " + _cond_q;
            }
            bottom_sel_query = bottom_sel_query + " order by " + this._column + " LIMIT " + num + " ) t1 ";
        } else if (this._dtype.compareToIgnoreCase("Informix") == 0) {
            bottom_sel_query = " SELECT  FIRST " + num + " " + this._column + " as " + col_name + " FROM " + this._table;
            if (isCond) {
                bottom_sel_query = bottom_sel_query + " WHERE " + _cond_q;
            }
            bottom_sel_query = bottom_sel_query + " order by " + this._column;
        } else if (this._dtype.compareToIgnoreCase("Splice") == 0) {
            bottom_sel_query = " SELECT " + this._column + " as " + col_name + " FROM " + this._table;
            if (isCond) {
                bottom_sel_query = bottom_sel_query + " WHERE " + _cond_q;
            }
            bottom_sel_query = bottom_sel_query + " order by " + this._column + "FETCH FIRST " + " " + num + " " + " ROW ONLY";
        } else {
            bottom_sel_query = " SELECT " + distinct_str + " TOP " + num + " " + this._column + " as " + col_name + " FROM " + this._table;
            if (isCond) {
                bottom_sel_query = bottom_sel_query + " WHERE " + _cond_q;
            }
            bottom_sel_query = bottom_sel_query + " order by " + this._column;
        }
        return bottom_sel_query;
    }

    public String top_query(boolean distinct, String col_name, String num) {
        String distinct_str = "";
        String top_sel_query = "";
        if (distinct) {
            distinct_str = " DISTINCT ";
        }
        if (this._dtype.compareToIgnoreCase("oracle_native") == 0 || this._dtype.compareToIgnoreCase("oracle_odbc") == 0) {
            top_sel_query = " SELECT " + this._column + " as " + col_name + " FROM " + " (SELECT " + distinct_str + this._column + " FROM " + this._table;
            if (isCond) {
                top_sel_query = top_sel_query + " WHERE " + _cond_q;
            }
            top_sel_query = top_sel_query + " order by " + this._column + " desc ) WHERE rownum <= " + num;
        } else if (this._dtype.compareToIgnoreCase("mysql") == 0 || this._dtype.compareToIgnoreCase("postgres") == 0 || this._dtype.compareToIgnoreCase("ms_access_jdbc") == 0 || this._dtype.compareToIgnoreCase("teiid") == 0 || this._dtype.compareToIgnoreCase("db2") == 0) {
            top_sel_query = " SELECT " + distinct_str + " " + this._column + " as " + col_name + " FROM " + this._table;
            if (isCond) {
                top_sel_query = top_sel_query + " WHERE " + _cond_q;
            }
            top_sel_query = this._dtype.compareToIgnoreCase("teiid") == 0 ? top_sel_query + " order by " + this._column + " desc LIMIT " + num : top_sel_query + " order by " + this._column + " desc LIMIT " + num + " OFFSET 0";
        } else if (this._dtype.compareToIgnoreCase("hive") == 0) {
            top_sel_query = " SELECT " + this._column + " as " + col_name + " FROM ( ";
            top_sel_query = top_sel_query + " SELECT " + distinct_str + " " + this._column + " FROM " + this._table;
            if (isCond) {
                top_sel_query = top_sel_query + " WHERE " + _cond_q;
            }
            top_sel_query = top_sel_query + " order by " + this._column + " desc LIMIT " + num + " ) t1 ";
        } else if (this._dtype.compareToIgnoreCase("Informix") == 0) {
            top_sel_query = " SELECT  FIRST " + num + " " + this._column + " as " + col_name + " FROM " + this._table;
            if (isCond) {
                top_sel_query = top_sel_query + " WHERE " + _cond_q;
            }
            top_sel_query = top_sel_query + " order by " + this._column + " desc ";
        } else if (this._dtype.compareToIgnoreCase("Splice") == 0) {
            top_sel_query = " SELECT " + this._column + " as " + col_name + " FROM " + this._table;
            if (isCond) {
                top_sel_query = top_sel_query + " WHERE " + _cond_q;
            }
            top_sel_query = top_sel_query + " order by " + this._column + " " + " desc fetch first" + " " + num + " " + "row Only ";
        } else {
            top_sel_query = " SELECT " + distinct_str + " TOP " + num + " " + this._column + " as " + col_name + " FROM " + this._table;
            if (isCond) {
                top_sel_query = top_sel_query + " WHERE " + _cond_q;
            }
            top_sel_query = top_sel_query + " order by " + this._column + " desc ";
        }
        return top_sel_query;
    }

    public String aggr_query(String status, int index, String min_value, String max_value) {
        String count = "";
        String avg = "";
        String max = "";
        String min = "";
        String sum = "";
        String aggr_query = "";
        String total_count = status.substring(0, 1);
        int total_sel = new Integer(total_count);
        if (total_sel == 0) {
            return aggr_query;
        }
        if (status.charAt(1) == 'Y') {
            count = "count(" + this._column + ") as row_count ";
            if (total_sel > 1) {
                --total_sel;
                count = count + ",";
            }
        }
        if (status.charAt(2) == 'Y') {
            avg = "avg(" + this._column + ") as avg_count ";
            if (total_sel > 1) {
                --total_sel;
                avg = avg + ",";
            }
        }
        if (status.charAt(3) == 'Y') {
            max = "max(" + this._column + ") as max_count ";
            if (total_sel > 1) {
                --total_sel;
                max = max + ",";
            }
        }
        if (status.charAt(4) == 'Y') {
            min = "min(" + this._column + ") as min_count ";
            if (total_sel > 1) {
                --total_sel;
                min = min + ",";
            }
        }
        if (status.charAt(5) == 'Y') {
            sum = " sum(" + this._column + ") as sum_count ";
        }
        if (index == 0) {
            aggr_query = "SELECT " + count + avg + max + min + sum + " FROM " + this._table;
            if (isCond) {
                aggr_query = aggr_query + " WHERE " + _cond_q;
            }
        }
        if (index == 1) {
            aggr_query = "SELECT " + count + avg + max + min + sum + " FROM " + this._table + " WHERE " + this._column + " < " + min_value;
            if (isCond) {
                aggr_query = aggr_query + " and " + _cond_q;
            }
        }
        if (index == 2) {
            aggr_query = "SELECT " + count + avg + max + min + sum + " FROM " + this._table + " WHERE " + this._column + " > " + max_value;
            if (isCond) {
                aggr_query = aggr_query + " and " + _cond_q;
            }
        }
        if (index == 3) {
            aggr_query = "SELECT " + count + avg + max + min + sum + " FROM " + this._table + " WHERE " + this._column + " > " + min_value + " and " + this._column + " < " + max_value;
            if (isCond) {
                aggr_query = aggr_query + " and " + _cond_q;
            }
        }
        return aggr_query;
    }

    public String dist_count_query(int index, String min_value, String max_value) {
        String dist_count_query = "SELECT count(*) as dist_count FROM ( SELECT DISTINCT " + this._column + " FROM " + this._table;
        if (isCond) {
            dist_count_query = dist_count_query + " WHERE " + _cond_q;
        }
        dist_count_query = this._dtype.compareToIgnoreCase("sql_server") == 0 || this._dtype.compareToIgnoreCase("mysql") == 0 || this._dtype.compareToIgnoreCase("postgres") == 0 || this._dtype.compareToIgnoreCase("teiid") == 0 || this._dtype.compareToIgnoreCase("splice") == 0 ? dist_count_query + " ) as AS1" : (this._dtype.compareToIgnoreCase("hive") == 0 ? dist_count_query + " ) as t1" : dist_count_query + " )");
        if (index == 0) {
            // empty if block
        }
        if (index == 1) {
            dist_count_query = dist_count_query + " WHERE " + this._column + " < " + min_value;
        }
        if (index == 2) {
            dist_count_query = dist_count_query + " WHERE " + this._column + " > " + max_value;
        }
        if (index == 3) {
            dist_count_query = dist_count_query + " WHERE " + this._column + " > " + min_value + " and " + this._column + " < " + max_value;
        }
        return dist_count_query;
    }

    public String get_like_query(String like_str, boolean like) {
        String like_query = "";
        like_query = like ? (this._dtype.compareToIgnoreCase("postgres") == 0 ? "SELECT " + this._column + " as like_wise FROM " + this._table + " WHERE " + this._column + "::text ILIKE " + "'" + like_str + "'" : (this._dtype.compareToIgnoreCase("informix") == 0 ? "SELECT " + this._column + " as like_wise FROM " + this._table + " WHERE " + this._column + "::VARCHAR(255) LIKE " + "'" + like_str + "'" : (this._dtype.compareToIgnoreCase("splice") == 0 ? "SELECT " + this._column + " as like_wise FROM " + this._table + " WHERE " + "CAST(" + this._column + " AS CHAR(250)) LIKE " + "'" + like_str + "'" : "SELECT " + this._column + " as like_wise FROM " + this._table + " WHERE " + this._column + " LIKE " + "'" + like_str + "'"))) : (this._dtype.compareToIgnoreCase("postgres") == 0 ? "SELECT " + this._column + " as like_wise FROM " + this._table + " WHERE " + this._column + "::text NOT ILIKE " + "'" + like_str + "'" : (this._dtype.compareToIgnoreCase("informix") == 0 ? "SELECT " + this._column + " as like_wise FROM " + this._table + " WHERE " + this._column + "::VARCHAR(255) NOT LIKE " + "'" + like_str + "'" : (this._dtype.compareToIgnoreCase("splice") == 0 ? "SELECT " + this._column + " as like_wise FROM " + this._table + " WHERE " + "CAST(" + this._column + " AS CHAR(250)) NOT LIKE " + "'" + like_str + "'" : "SELECT " + this._column + " as like_wise FROM " + this._table + " WHERE " + this._column + " NOT LIKE " + "'" + like_str + "'")));
        if (isCond) {
            like_query = like_query + " and " + _cond_q;
        }
        return like_query;
    }

    public String get_all_query() {
        String all_query;
        if (this._dtype.compareToIgnoreCase("hive") == 0) {
            all_query = "SELECT " + this._column + " as like_wise FROM ";
            all_query = all_query + " ( SELECT * FROM " + this._table + " order by " + this._column + " ) t1";
            if (isCond) {
                all_query = all_query + " WHERE " + _cond_q;
            }
        } else {
            all_query = "SELECT " + this._column + " as like_wise FROM " + this._table;
            if (isCond) {
                all_query = all_query + " WHERE " + _cond_q;
            }
            all_query = all_query + " order by " + this._column;
        }
        return all_query;
    }

    public String get_all_query_wcond_wnull() {
        String all_query = "";
        if (this._dtype.compareToIgnoreCase("hive") == 0) {
            all_query = "SELECT " + this._column + " as like_wise FROM ";
            all_query = all_query + " ( SELECT * FROM " + this._table + " WHERE " + this._column + " IS NOT NULL" + " order by " + this._column + " ) t1";
        } else {
            all_query = "SELECT " + this._column + " as like_wise FROM " + this._table + " WHERE " + this._column + " IS NOT NULL";
            all_query = all_query + " order by " + this._column;
        }
        return all_query;
    }

    public String get_freq_query_wnull() {
        String freq_query = "SELECT count( " + this._column + " ) as row_count," + this._column + " as like_wise FROM " + this._table + " WHERE " + this._column + " IS NOT NULL";
        freq_query = freq_query + " group by " + this._column + " having count(" + this._column + ") > 0 order by ";
        freq_query = this._dtype.compareToIgnoreCase("hive") == 0 ? freq_query + "like_wise" : freq_query + this._column;
        return freq_query;
    }

    public String get_all_worder_query() {
        String all_query = "SELECT " + this._column + " as like_wise FROM " + this._table;
        if (isCond) {
            all_query = all_query + " WHERE " + _cond_q;
        }
        return all_query;
    }

    public String get_nullCount_query(String equalTo) {
        String equal_query = "SELECT count(*) as equal_count FROM " + this._table + " WHERE " + this._column + " Is " + equalTo;
        if (isCond) {
            equal_query = equal_query + " and " + _cond_q;
        }
        return equal_query;
    }

    public String get_nullCount_query_w(String equalTo) {
        String equal_query = "SELECT count(*) as equal_count FROM " + this._table + " WHERE " + this._column + " Is " + equalTo;
        return equal_query;
    }

    public String get_zeroCount_query(String equalTo) {
        String equal_query = "SELECT count( " + this._column + " ) as equal_count FROM " + this._table + " WHERE " + this._column + " = " + equalTo;
        if (isCond) {
            equal_query = equal_query + " and " + _cond_q;
        }
        return equal_query;
    }

    public String get_zeroCount_query_w(String equalTo) {
        String equal_query = "SELECT count( " + this._column + " ) as equal_count FROM " + this._table + " WHERE " + this._column + " = " + equalTo;
        return equal_query;
    }

    public String get_prep_query() {
        String prep_query = "SELECT count( " + this._column + " ) as row_count FROM " + this._table + " WHERE " + this._column + " >= ? and " + this._column + " < ?";
        if (isCond) {
            prep_query = prep_query + " and " + _cond_q;
        }
        return prep_query;
    }

    public String get_freq_query() {
        String freq_query = "SELECT count( " + this._column + " ) as row_count, " + this._column + " as like_wise FROM " + this._table;
        freq_query = freq_query + " group by " + this._column + " having count(" + this._column + ") > 1 order by ";
        freq_query = this._dtype.compareToIgnoreCase("hive") == 0 ? freq_query + "row_count desc" : freq_query + "1 desc";
        return freq_query;
    }

    public String get_pattern_query() {
        String pattern_query = "SELECT count(*) as row_count FROM ( ";
        pattern_query = pattern_query + "SELECT " + this._column + " FROM " + this._table;
        pattern_query = pattern_query + " group by " + this._column + " having count(" + this._column + ") > 1 ";
        pattern_query = this._dtype.compareToIgnoreCase("sql_server") == 0 || this._dtype.compareToIgnoreCase("mysql") == 0 || this._dtype.compareToIgnoreCase("postgres") == 0 || this._dtype.compareToIgnoreCase("teiid") == 0 || this._dtype.compareToIgnoreCase("splice") == 0 ? pattern_query + " ) as AS1" : (this._dtype.compareToIgnoreCase("hive") == 0 ? pattern_query + " ) t1" : pattern_query + " )");
        return pattern_query;
    }

    public String get_pattern_all_query() {
        String pattern_query = "SELECT count(*) as row_count FROM ( ";
        pattern_query = pattern_query + "SELECT " + this._column + " FROM " + this._table;
        pattern_query = pattern_query + " WHERE " + this._column + " IS NOT NULL ";
        pattern_query = pattern_query + " group by " + this._column + " having count(" + this._column + ") > 0 ";
        pattern_query = this._dtype.compareToIgnoreCase("sql_server") == 0 || this._dtype.compareToIgnoreCase("mysql") == 0 || this._dtype.compareToIgnoreCase("postgres") == 0 || this._dtype.compareToIgnoreCase("teiid") == 0 || this._dtype.compareToIgnoreCase("splice") == 0 ? pattern_query + " ) as AS1" : (this._dtype.compareToIgnoreCase("hive") == 0 ? pattern_query + " ) t1" : pattern_query + " )");
        return pattern_query;
    }

    public String get_freq_all_query() {
        String freq_all_query = "SELECT " + this._column + " as like_wise, count( " + this._column + " ) as row_count FROM " + this._table;
        if (isCond) {
            freq_all_query = freq_all_query + " WHERE " + _cond_q;
        }
        freq_all_query = freq_all_query + " group by " + this._column + " having count(" + this._column + ") > 0 order by";
        freq_all_query = this._dtype.compareToIgnoreCase("hive") == 0 ? freq_all_query + " row_count desc" : freq_all_query + " 2 desc ";
        return freq_all_query;
    }

    public String get_freq_like_query(String like_str, boolean like) {
        String freq_like_query = "";
        freq_like_query = like ? (this._dtype.compareToIgnoreCase("postgres") == 0 ? "SELECT " + this._column + " as like_wise, count( " + this._column + " ) as row_count FROM " + this._table + " WHERE " + this._column + "::text ILIKE " + "'" + like_str + "'" : (this._dtype.compareToIgnoreCase("informix") == 0 ? "SELECT " + this._column + " as like_wise, count( " + this._column + " ) as row_count FROM " + this._table + " WHERE " + this._column + "::VARCHAR(255) LIKE " + "'" + like_str + "'" : (this._dtype.compareToIgnoreCase("splice") == 0 ? "SELECT " + this._column + " as like_wise, count( " + this._column + " ) as row_count FROM " + this._table + " WHERE " + "CAST(" + this._column + "AS CHAR(250)) LIKE " + "'" + like_str + "'" : "SELECT " + this._column + " as like_wise, count( " + this._column + " ) as row_count FROM " + this._table + " WHERE " + this._column + " LIKE " + "'" + like_str + "'"))) : (this._dtype.compareToIgnoreCase("postgres") == 0 ? "SELECT " + this._column + " as like_wise, count( " + this._column + " ) as row_count FROM " + this._table + " WHERE " + this._column + "::text NOT ILIKE " + "'" + like_str + "'" : (this._dtype.compareToIgnoreCase("informix") == 0 ? "SELECT " + this._column + " as like_wise, count( " + this._column + " ) as row_count FROM " + this._table + " WHERE " + this._column + "::VARCHAR(255) NOT LIKE " + "'" + like_str + "'" : (this._dtype.compareToIgnoreCase("splice") == 0 ? "SELECT " + this._column + " as like_wise, count( " + this._column + " ) as row_count FROM " + this._table + " WHERE " + "CAST(" + this._column + "AS CHAR(250)) NOT LIKE " + "'" + like_str + "'" : "SELECT " + this._column + " as like_wise, count( " + this._column + " ) as row_count FROM " + this._table + " WHERE " + this._column + " NOT LIKE " + "'" + like_str + "'")));
        if (isCond) {
            freq_like_query = freq_like_query + " and " + _cond_q;
        }
        freq_like_query = this._dtype.compareToIgnoreCase("hive") == 0 ? freq_like_query + " group by " + this._column + " having count(" + this._column + ") > 0 order by row_count desc" : freq_like_query + " group by " + this._column + " having count(" + this._column + ") > 0 order by 2 desc";
        return freq_like_query;
    }

    public String get_match_count(byte multiple, int mX) {
        String m_count_query = this._dtype.compareToIgnoreCase("sql_server") == 0 || this._dtype.compareToIgnoreCase("mysql") == 0 || this._dtype.compareToIgnoreCase("ms_access") == 0 || this._dtype.compareToIgnoreCase("teiid") == 0 || this._dtype.compareToIgnoreCase("postgres") == 0 ? " SELECT count(*) as row_count,sum(AS1.row_count) as row_sum FROM ( SELECT count(" + this._table + "." + this._column + ") as row_count FROM " + this._table : (this._dtype.compareToIgnoreCase("splice") == 0 ? " SELECT count(*) as row_count,sum(row_count) as row_sum FROM ( SELECT count(" + this._table + "." + this._column + ") as row_count FROM " + this._table + "as VirtualTable" : " SELECT count(*) as row_count,sum(row_count) as row_sum FROM ( SELECT count(" + this._table + "." + this._column + ") as row_count FROM " + this._table);
        m_count_query = !this._table.equals(this._table1) ? (this._dtype.compareToIgnoreCase("hive") == 0 ? m_count_query + " LEFT SEMI JOIN " + this._table1 + " ON ( " + this._table + "." + this._column + " = " + this._table1 + "." + this._column1 + ") AND " : m_count_query + "," + this._table1 + " WHERE " + this._table + "." + this._column + " = " + this._table1 + "." + this._column1 + " AND ") : m_count_query + " WHERE ";
        m_count_query = m_count_query + this._table + "." + this._column + " IS NOT NULL GROUP BY " + this._table + "." + this._column + " HAVING " + " count(" + this._table + "." + this._column + ") ";
        if (this._dtype.compareToIgnoreCase("sql_server") == 0 || this._dtype.compareToIgnoreCase("ms_access") == 0 || this._dtype.compareToIgnoreCase("mysql") == 0 || this._dtype.compareToIgnoreCase("postgres") == 0 || this._dtype.compareToIgnoreCase("teiid") == 0 || this._dtype.compareToIgnoreCase("splice") == 0) {
            if (this._dtype.compareToIgnoreCase("Splice") == 0) {
                m_count_query = m_count_query.replaceAll("as VirtualTable", "");
            }
            if (multiple == 0) {
                m_count_query = m_count_query + "= 1 ) as AS1";
            } else if (multiple == 1) {
                m_count_query = m_count_query + ">= 1 ) as AS1";
            } else if (multiple == 2) {
                m_count_query = m_count_query + "> 1 ) as AS1";
            } else if (multiple == 3) {
                m_count_query = m_count_query + "= " + mX + " ) as AS1";
            }
        } else if (this._dtype.compareToIgnoreCase("hive") == 0) {
            if (multiple == 0) {
                m_count_query = m_count_query + "= 1 )  t1";
            } else if (multiple == 1) {
                m_count_query = m_count_query + ">= 1 )  t1";
            } else if (multiple == 2) {
                m_count_query = m_count_query + "> 1 )  t1";
            } else if (multiple == 3) {
                m_count_query = m_count_query + "= " + mX + " )  t1";
            }
        } else if (multiple == 0) {
            m_count_query = m_count_query + "= 1 ) ";
        } else if (multiple == 1) {
            m_count_query = m_count_query + ">= 1 ) ";
        } else if (multiple == 2) {
            m_count_query = m_count_query + "> 1 ) ";
        } else if (multiple == 3) {
            m_count_query = m_count_query + "= " + mX + " ) ";
        }
        return m_count_query;
    }

    public String get_match_value(byte multiple, int mX, boolean match, boolean isLeft) {
        String m_match_query = "";
        String match_str = "";
        String hive_innerQuery = "";
        match_str = match ? " IN" : " NOT IN";
        if (this._dtype.compareToIgnoreCase("hive") == 0) {
            hive_innerQuery = !this._table.equals(this._table1) ? hive_innerQuery + " ( SELECT " + this._table + "." + this._column + " as match_value FROM " + this._table + " JOIN " + this._table1 + " ON (" + this._table + "." + this._column + " = " + this._table1 + "." + this._column1 + ")  AND " + this._table + "." + this._column + " IS NOT NULL GROUP BY " + this._table + "." + this._column + " HAVING " + " count(" + this._table + "." + this._column + ")  " : hive_innerQuery + " ( SELECT " + this._table + "." + this._column + " as match_value FROM " + this._table + " WHERE " + this._table + "." + this._column + " IS NOT NULL GROUP BY " + this._table + "." + this._column + " HAVING " + " count(" + this._table + "." + this._column + ")  ";
            if (match) {
                if (multiple == 0) {
                    hive_innerQuery = hive_innerQuery + "= 1 ) t1";
                } else if (multiple == 1) {
                    hive_innerQuery = hive_innerQuery + ">= 1 ) t1";
                } else if (multiple == 2) {
                    hive_innerQuery = hive_innerQuery + "> 1 ) t1";
                } else if (multiple == 3) {
                    hive_innerQuery = hive_innerQuery + "= " + mX + ") t1";
                }
            } else if (multiple == 0) {
                hive_innerQuery = hive_innerQuery + "!= 1 ) t1";
            } else if (multiple == 1) {
                hive_innerQuery = hive_innerQuery + "< 1 ) t1";
            } else if (multiple == 2) {
                hive_innerQuery = hive_innerQuery + "<= 1 ) t1";
            } else if (multiple == 3) {
                hive_innerQuery = hive_innerQuery + "!= " + mX + ") t1";
            }
            if (!this._table.equals(this._table1) && !isLeft) {
                m_match_query = " SELECT * FROM " + this._table1 + " LEFT SEMI JOIN " + hive_innerQuery + " ON  " + this._table1 + "." + this._column1 + " = t1.match_value";
                m_match_query = m_match_query + " ORDER BY " + this._table1 + "." + this._column1;
            } else if (this._table.equals(this._table1) && !isLeft) {
                m_match_query = " SELECT * FROM " + this._table + " LEFT SEMI JOIN " + hive_innerQuery + " ON  " + this._table + "." + this._column + " = t1.match_value";
                m_match_query = m_match_query + " ORDER BY " + this._table + "." + this._column1;
            } else {
                m_match_query = " SELECT *  FROM " + this._table + " LEFT SEMI JOIN " + hive_innerQuery + " ON " + this._table + "." + this._column + " = t1.match_value";
                m_match_query = m_match_query + " ORDER BY " + this._table + "." + this._column;
            }
        } else {
            m_match_query = !this._table.equals(this._table1) && !isLeft ? " SELECT *  FROM " + this._table1 + " WHERE " + this._column1 + match_str : " SELECT *  FROM " + this._table + " WHERE " + this._column + match_str;
            m_match_query = !this._table.equals(this._table1) ? m_match_query + " ( SELECT " + this._table + "." + this._column + " FROM " + this._table + "," + this._table1 + " WHERE " + this._table + "." + this._column + " = " + this._table1 + "." + this._column1 + "  AND " + this._table + "." + this._column + " IS NOT NULL GROUP BY " + this._table + "." + this._column + " HAVING " + " count(" + this._table + "." + this._column + ") " : m_match_query + " ( SELECT " + this._table + "." + this._column + " FROM " + this._table + " WHERE " + this._table + "." + this._column + " IS NOT NULL GROUP BY " + this._table + "." + this._column + " HAVING " + " count(" + this._table + "." + this._column + ") ";
            if (multiple == 0) {
                m_match_query = m_match_query + "= 1 )";
            } else if (multiple == 1) {
                m_match_query = m_match_query + ">= 1 )";
            } else if (multiple == 2) {
                m_match_query = m_match_query + "> 1 )";
            } else if (multiple == 3) {
                m_match_query = m_match_query + "= " + mX + ")";
            }
            m_match_query = isLeft ? m_match_query + " ORDER BY " + this._column : m_match_query + " ORDER BY " + this._column1;
        }
        return m_match_query;
    }

    public String get_all_freq_query(boolean isDup) {
        String freq_query = "SELECT * FROM " + this._table + " WHERE " + this._column + " IN ";
        freq_query = freq_query + "( SELECT " + this._column + " FROM (";
        freq_query = freq_query + " SELECT " + this._column + " FROM " + this._table;
        if (isCond) {
            freq_query = freq_query + " WHERE " + _cond_q;
        }
        freq_query = freq_query + " group by " + this._column + " having count(" + this._column + ")";
        freq_query = isDup ? freq_query + " > 1 ) ) " : freq_query + " = 1 ) )";
        return freq_query;
    }

    public String get_like_table(String searchS, int index, boolean isCount) {
        Vector<?>[] avector = null;
        avector = TableMetaInfo.populateTable(5, index, index + 1, avector);
        String columns = "";
        if (avector == null) {
            return null;
        }
        for (int j = 0; j < avector[0].size() - 1; ++j) {
            columns = this._dtype.compareToIgnoreCase("postgres") == 0 ? columns + "\"" + avector[0].elementAt(j) + "\"::text ILIKE '%" + searchS + "%' OR " : (this._dtype.compareToIgnoreCase("informix") == 0 ? columns + avector[0].elementAt(j) + "::VARCHAR(255) LIKE '%" + searchS + "%' OR " : (this._dtype.compareToIgnoreCase("splice") == 0 ? columns + "CAST(" + avector[0].elementAt(j) + " AS CHAR(250)) LIKE '%" + searchS + "%' OR " : (this._dtype.compareToIgnoreCase("mysql") != 0 && this._dtype.compareToIgnoreCase("hive") != 0 && this._dtype.compareToIgnoreCase("informix") != 0 && this._dtype.compareToIgnoreCase("ms_access_jdbc") != 0 && (this._dtype.compareToIgnoreCase("Others") != 0 || Rdbms_conn.getHValue("Database_SupportQuote").compareToIgnoreCase("NO") != 0) ? columns + "\"" + avector[0].elementAt(j) + "\" LIKE '%" + searchS + "%' OR " : columns + avector[0].elementAt(j) + " LIKE '%" + searchS + "%' OR ")));
        }
        if (avector[0].size() != 0) {
            columns = this._dtype.compareToIgnoreCase("postgres") == 0 ? columns + "\"" + avector[0].elementAt(avector[0].size() - 1) + "\"::text ILIKE '%" + searchS + "%'" : (this._dtype.compareToIgnoreCase("informix") == 0 ? columns + avector[0].elementAt(avector[0].size() - 1) + "::VARCHAR(255) LIKE '%" + searchS + "%'" : (this._dtype.compareToIgnoreCase("splice") == 0 ? columns + " CAST( " + avector[0].elementAt(avector[0].size() - 1) + " AS CHAR(250)) LIKE '%" + searchS + "%' " : (this._dtype.compareToIgnoreCase("mysql") != 0 && this._dtype.compareToIgnoreCase("hive") != 0 && this._dtype.compareToIgnoreCase("informix") != 0 && this._dtype.compareToIgnoreCase("ms_access_jdbc") != 0 && (this._dtype.compareToIgnoreCase("Others") != 0 || Rdbms_conn.getHValue("Database_SupportQuote").compareToIgnoreCase("NO") != 0) ? columns + "\"" + avector[0].elementAt(avector[0].size() - 1) + "\" LIKE '%" + searchS + "%'" : columns + avector[0].elementAt(avector[0].size() - 1) + " LIKE '%" + searchS + "%'")));
        }
        String tb_like_query = "";
        tb_like_query = isCount ? "SELECT count(*) as COUNT FROM " + this._table + " WHERE " + columns : "SELECT *  FROM " + this._table + " WHERE " + columns;
        return tb_like_query;
    }

    public String get_like_table_cols(String searchS, Vector<String> avector, boolean isCount) {
        String columns = "";
        if (avector == null) {
            return null;
        }
        for (int j = 0; j < avector.size() - 1; ++j) {
            columns = this._dtype.compareToIgnoreCase("postgres") == 0 ? columns + "\"" + avector.elementAt(j) + "\"::text ILIKE '%" + searchS + "%' OR " : (this._dtype.compareToIgnoreCase("informix") == 0 ? columns + avector.elementAt(j) + "::VARCHAR(255) LIKE '%" + searchS + "%' OR " : (this._dtype.compareToIgnoreCase("splice") == 0 ? columns + "CAST(" + avector.elementAt(j) + " AS CHAR(250)) LIKE '%" + searchS + "%' OR " : (this._dtype.compareToIgnoreCase("mysql") != 0 && this._dtype.compareToIgnoreCase("hive") != 0 && this._dtype.compareToIgnoreCase("informix") != 0 && this._dtype.compareToIgnoreCase("ms_access_jdbc") != 0 && (this._dtype.compareToIgnoreCase("Others") != 0 || Rdbms_conn.getHValue("Database_SupportQuote").compareToIgnoreCase("NO") != 0) ? columns + "\"" + avector.elementAt(j) + "\" LIKE '%" + searchS + "%' OR " : columns + avector.elementAt(j) + " LIKE '%" + searchS + "%' OR ")));
        }
        if (avector.size() != 0) {
            columns = this._dtype.compareToIgnoreCase("postgres") == 0 ? columns + "\"" + avector.elementAt(avector.size() - 1) + "\"::text ILIKE '%" + searchS + "%'" : (this._dtype.compareToIgnoreCase("informix") == 0 ? columns + avector.elementAt(avector.size() - 1) + " ::VARCHAR(255) LIKE '%" + searchS + "%'" : (this._dtype.compareToIgnoreCase("Splice") == 0 ? columns + "CAST(" + avector.elementAt(avector.size() - 1) + " AS CHAR(250)) LIKE '%" + searchS + "%' " : (this._dtype.compareToIgnoreCase("mysql") != 0 && this._dtype.compareToIgnoreCase("hive") != 0 && this._dtype.compareToIgnoreCase("informix") != 0 && this._dtype.compareToIgnoreCase("ms_access_jdbc") != 0 && (this._dtype.compareToIgnoreCase("Others") != 0 || Rdbms_conn.getHValue("Database_SupportQuote").compareToIgnoreCase("NO") != 0) ? columns + "\"" + avector.elementAt(avector.size() - 1) + "\" LIKE '%" + searchS + "%'" : columns + avector.elementAt(avector.size() - 1) + " LIKE '%" + searchS + "%'")));
        }
        String tb_like_query = "";
        tb_like_query = isCount ? "SELECT count(*) as COUNT FROM " + this._table + " WHERE " + columns : "SELECT *  FROM " + this._table + " WHERE " + columns;
        return tb_like_query;
    }

    public String get_tb_value(boolean isOrd) {
        String table = this._table.charAt(0) == '\"' ? this._table.replaceAll("\"", "") : this._table;
        String cat = Rdbms_conn.getHValue("Database_Catalog");
        if (cat != null && !"".equals(cat) && cat.charAt(0) == '\"') {
            table = table.substring(cat.length() - 1);
        } else if (cat != null && !"".equals(cat)) {
            table = (table = table.substring(cat.length() + 1)).charAt(0) == '\"' ? table.replaceAll("\"", "") : table;
        }
        Vector<String> vector = Rdbms_conn.getTable();
        int i = vector.indexOf(table);
        Vector<?>[] avector = null;
        avector = TableMetaInfo.populateTable(5, i, i + 1, avector);
        String columns = "";
        if (avector == null) {
            return null;
        }
        for (int j = 0; j < avector[0].size() - 1; ++j) {
            columns = this._dtype.compareToIgnoreCase("mysql") != 0 && this._dtype.compareToIgnoreCase("hive") != 0 && this._dtype.compareToIgnoreCase("informix") != 0 && this._dtype.compareToIgnoreCase("ms_access_jdbc") != 0 && (this._dtype.compareToIgnoreCase("Others") != 0 || Rdbms_conn.getHValue("Database_SupportQuote").compareToIgnoreCase("NO") != 0) ? columns + "\"" + avector[0].elementAt(j) + "\"" + "," : columns + avector[0].elementAt(j) + ",";
        }
        if (avector[0].size() != 0) {
            columns = this._dtype.compareToIgnoreCase("mysql") != 0 && this._dtype.compareToIgnoreCase("hive") != 0 && this._dtype.compareToIgnoreCase("informix") != 0 && this._dtype.compareToIgnoreCase("ms_access_jdbc") != 0 && (this._dtype.compareToIgnoreCase("Others") != 0 || Rdbms_conn.getHValue("Database_SupportQuote").compareToIgnoreCase("NO") != 0) ? columns + "\"" + avector[0].elementAt(avector[0].size() - 1) + "\"" : columns + avector[0].elementAt(avector[0].size() - 1);
        }
        String tb_query = "SELECT " + columns + " FROM " + this._table;
        if (isCond) {
            tb_query = tb_query + " WHERE " + _cond_q;
        }
        if (isOrd) {
            tb_query = tb_query + " order by " + this._column;
        }
        return tb_query;
    }

    public String[] get_mapping_query(Hashtable<String, Vector<String>> tb, Vector<String> tableV) {
        String[] map_query = new String[tb.size()];
        String cat = Rdbms_conn.getHValue("Database_Catalog");
        int index = 0;
        Enumeration<String> e = tb.keys();
        while (e.hasMoreElements()) {
            String cols = "";
            String table = e.nextElement();
            tableV.add(table);
            Vector<String> vc = tb.get(table);
            if (vc == null) {
                System.out.println("\n ERROR:Could not Find:" + table);
            }
            if (!(this._dtype.compareToIgnoreCase("mysql") == 0 || this._dtype.compareToIgnoreCase("hive") == 0 || this._dtype.compareToIgnoreCase("informix") == 0 || this._dtype.compareToIgnoreCase("ms_access_jdbc") == 0 || this._dtype.compareToIgnoreCase("Others") == 0 && Rdbms_conn.getHValue("Database_SupportQuote").compareToIgnoreCase("NO") == 0 || table.startsWith("\""))) {
                table = "\"" + table + "\"";
            }
            if (cat != null && !"".equals(cat)) {
                table = cat + "." + table;
            }
            for (int i = 0; i < vc.size(); ++i) {
                String col = vc.elementAt(i);
                if (!(this._dtype.compareToIgnoreCase("mysql") == 0 || this._dtype.compareToIgnoreCase("hive") == 0 || this._dtype.compareToIgnoreCase("informix") == 0 || this._dtype.compareToIgnoreCase("ms_access_jdbc") == 0 || this._dtype.compareToIgnoreCase("Others") == 0 && Rdbms_conn.getHValue("Database_SupportQuote").compareToIgnoreCase("NO") == 0 || col.startsWith("\""))) {
                    col = "\"" + col + "\"";
                }
                cols = "".equals(cols) ? table + "." + col : cols + "," + table + "." + col;
            }
            map_query[index] = "SELECT " + cols + " FROM " + table;
            ++index;
        }
        return map_query;
    }

    public Vector<String> get_synch_mapping_query(Vector<String> table_s, Vector<String> column_s) {
        Vector<String> synch_map_query = new Vector<String>();
        String cat = Rdbms_conn.getHValue("Database_Catalog");
        for (int index = 0; index < table_s.size(); ++index) {
            String table = table_s.get(index);
            String col = column_s.get(index);
            if (!(this._dtype.compareToIgnoreCase("mysql") == 0 || this._dtype.compareToIgnoreCase("hive") == 0 || this._dtype.compareToIgnoreCase("informix") == 0 || this._dtype.compareToIgnoreCase("ms_access_jdbc") == 0 || this._dtype.compareToIgnoreCase("Others") == 0 && Rdbms_conn.getHValue("Database_SupportQuote").compareToIgnoreCase("NO") == 0 || table.startsWith("\""))) {
                table = "\"" + table + "\"";
            }
            if (cat != null && !"".equals(cat)) {
                table = cat + "." + table;
            }
            if (!(this._dtype.compareToIgnoreCase("mysql") == 0 || this._dtype.compareToIgnoreCase("hive") == 0 || this._dtype.compareToIgnoreCase("informix") == 0 || this._dtype.compareToIgnoreCase("ms_access_jdbc") == 0 || this._dtype.compareToIgnoreCase("Others") == 0 && Rdbms_conn.getHValue("Database_SupportQuote").compareToIgnoreCase("NO") == 0 || col.startsWith("\""))) {
                col = "\"" + col + "\"";
            }
            String query = "SELECT " + table + "." + col + " FROM " + table;
            synch_map_query.add(query);
        }
        return synch_map_query;
    }

    public String get_table_duprow_query(Vector<?> col_vc, String cond) {
        String dup_row_query = "";
        String columns = "";
        String column = "";
        Enumeration<?> cols = col_vc.elements();
        while (cols.hasMoreElements()) {
            column = cols.nextElement().toString();
            if (!(this._dtype.compareToIgnoreCase("mysql") == 0 || this._dtype.compareToIgnoreCase("hive") == 0 || this._dtype.compareToIgnoreCase("informix") == 0 || this._dtype.compareToIgnoreCase("ms_access_jdbc") == 0 || this._dtype.compareToIgnoreCase("Others") == 0 && Rdbms_conn.getHValue("Database_SupportQuote").compareToIgnoreCase("NO") == 0 || column.startsWith("\""))) {
                column = "\"" + column + "\"";
            }
            if ("".equals(columns)) {
                columns = columns + column;
                continue;
            }
            columns = columns + "," + column;
        }
        dup_row_query = "SELECT count(" + column + ") as count" + "," + columns + " from " + this._table;
        if (!"".equals(cond)) {
            dup_row_query = dup_row_query + " WHERE " + cond;
        }
        dup_row_query = dup_row_query + " GROUP BY " + columns + " HAVING COUNT(*) > 1 ";
        return dup_row_query;
    }

    public String get_equal_query(Vector<?> col_vc, String condition) {
        String equal_query = "";
        String columns = "";
        String column = "";
        Enumeration<?> cols = col_vc.elements();
        while (cols.hasMoreElements()) {
            column = cols.nextElement().toString();
            if (!(this._dtype.compareToIgnoreCase("mysql") == 0 || this._dtype.compareToIgnoreCase("hive") == 0 || this._dtype.compareToIgnoreCase("informix") == 0 || this._dtype.compareToIgnoreCase("ms_access_jdbc") == 0 || this._dtype.compareToIgnoreCase("Others") == 0 && Rdbms_conn.getHValue("Database_SupportQuote").compareToIgnoreCase("NO") == 0 || column.startsWith("\""))) {
                column = "\"" + column + "\"";
            }
            column = cols.hasMoreElements() ? column + "= ? AND " : column + "= ? ";
            columns = columns + column;
        }
        equal_query = "SELECT * from " + this._table + " WHERE " + columns;
        if (condition != null && !"".equals(condition)) {
            equal_query = equal_query + " AND (" + condition + ")";
        }
        return equal_query;
    }

    public String get_inclusive_query(Vector<?> col_vc, boolean isInclusive) {
        String inclusive_query = "";
        String columns = "";
        String column = "";
        String inclusive = "";
        inclusive = isInclusive ? " AND " : " OR ";
        Enumeration<?> cols = col_vc.elements();
        while (cols.hasMoreElements()) {
            column = cols.nextElement().toString();
            if (!(this._dtype.compareToIgnoreCase("mysql") == 0 || this._dtype.compareToIgnoreCase("hive") == 0 || this._dtype.compareToIgnoreCase("informix") == 0 || this._dtype.compareToIgnoreCase("ms_access_jdbc") == 0 || this._dtype.compareToIgnoreCase("Others") == 0 && Rdbms_conn.getHValue("Database_SupportQuote").compareToIgnoreCase("NO") == 0 || column.startsWith("\""))) {
                column = "\"" + column + "\"";
            }
            column = cols.hasMoreElements() ? column + " IS NULL" + inclusive : column + " IS NULL";
            columns = columns + column;
        }
        inclusive_query = "SELECT * from " + this._table + " WHERE " + columns;
        return inclusive_query;
    }

    public String get_selCol_query(Object[] col, String cond) {
        String selColQuery = "";
        String column = "";
        for (int i = 0; i < col.length; ++i) {
            String colN = col[i].toString();
            if (!(this._dtype.compareToIgnoreCase("mysql") == 0 || this._dtype.compareToIgnoreCase("hive") == 0 || this._dtype.compareToIgnoreCase("informix") == 0 || this._dtype.compareToIgnoreCase("ms_access_jdbc") == 0 || this._dtype.compareToIgnoreCase("Others") == 0 && Rdbms_conn.getHValue("Database_SupportQuote").compareToIgnoreCase("NO") == 0 || colN.startsWith("\""))) {
                colN = "\"" + colN + "\"";
            }
            if (!"".equals(column)) {
                column = column + ",";
            }
            column = column + colN;
        }
        selColQuery = "SELECT " + column + " FROM " + this._table;
        if (cond != null && !"".equals(cond)) {
            selColQuery = selColQuery + " WHERE " + cond;
        }
        return selColQuery;
    }

    public String get_col_match_value(byte multiple, int mX, boolean match, boolean isLeft) {
        String table = " ";
        String cat = Rdbms_conn.getHValue("Database_Catalog");
        if (!this._table.equals(this._table1) && !isLeft) {
            table = this._table1.charAt(0) == '\"' ? this._table1.replaceAll("\"", "") : this._table1;
        } else {
            String string = table = this._table.charAt(0) == '\"' ? this._table.replaceAll("\"", "") : this._table;
        }
        if (cat != null && !"".equals(cat) && cat.charAt(0) == '\"') {
            table = table.substring(cat.length() - 1);
        } else if (cat != null && !"".equals(cat)) {
            table = (table = table.substring(cat.length() + 1)).charAt(0) == '\"' ? table.replaceAll("\"", "") : table;
        }
        Vector<String> vector = Rdbms_conn.getTable();
        int i = vector.indexOf(table);
        Vector<?>[] avector = null;
        avector = TableMetaInfo.populateTable(5, i, i + 1, avector);
        String columns = "";
        if (avector == null) {
            return null;
        }
        for (int j = 0; j < avector[0].size() - 1; ++j) {
            columns = this._dtype.compareToIgnoreCase("mysql") != 0 && this._dtype.compareToIgnoreCase("hive") != 0 && this._dtype.compareToIgnoreCase("informix") != 0 && this._dtype.compareToIgnoreCase("ms_access_jdbc") != 0 && (this._dtype.compareToIgnoreCase("Others") != 0 || Rdbms_conn.getHValue("Database_SupportQuote").compareToIgnoreCase("NO") != 0) ? columns + "\"" + avector[0].elementAt(j) + "\"" + "," : columns + avector[0].elementAt(j) + ",";
        }
        if (avector[0].size() != 0) {
            columns = this._dtype.compareToIgnoreCase("mysql") != 0 && this._dtype.compareToIgnoreCase("hive") != 0 && this._dtype.compareToIgnoreCase("informix") != 0 && this._dtype.compareToIgnoreCase("ms_access_jdbc") != 0 && (this._dtype.compareToIgnoreCase("Others") != 0 || Rdbms_conn.getHValue("Database_SupportQuote").compareToIgnoreCase("NO") != 0) ? columns + "\"" + avector[0].elementAt(avector[0].size() - 1) + "\"" : columns + avector[0].elementAt(avector[0].size() - 1);
        }
        String m_match_query = "";
        String match_str = "";
        match_str = match ? " IN (" : " NOT IN (";
        m_match_query = !this._table.equals(this._table1) && !isLeft ? " SELECT  " + columns + " FROM " + this._table1 + " WHERE " + this._column1 + match_str : " SELECT  " + columns + " FROM " + this._table + " WHERE " + this._column + match_str;
        m_match_query = !this._table.equals(this._table1) ? m_match_query + " SELECT " + this._table + "." + this._column + " FROM " + this._table + "," + this._table1 + " WHERE " + this._table + "." + this._column + " = " + this._table1 + "." + this._column1 + "  AND " + this._table + "." + this._column + " IS NOT NULL GROUP BY " + this._table + "." + this._column + " HAVING " + " count(" + this._table + "." + this._column + ") " : m_match_query + " SELECT " + this._table + "." + this._column + " FROM " + this._table + " WHERE " + this._table + "." + this._column + " IS NOT NULL GROUP BY " + this._table + "." + this._column + " HAVING " + " count(" + this._table + "." + this._column + ") ";
        if (multiple == 0) {
            m_match_query = m_match_query + "= 1 )";
        } else if (multiple == 1) {
            m_match_query = m_match_query + ">= 1 )";
        } else if (multiple == 2) {
            m_match_query = m_match_query + "> 1 )";
        } else if (multiple == 3) {
            m_match_query = m_match_query + "= " + mX + ")";
        }
        m_match_query = isLeft ? m_match_query + " ORDER BY " + this._column : m_match_query + " ORDER BY " + this._column1;
        return m_match_query;
    }

    public static String hive_count_query(String orgquery) {
        String query = "SELECT COUNT(*) as total_count FROM (" + orgquery + ") t1";
        return query;
    }

    public String getJoinQuery(Hashtable<String, String> ruleDetails) {
        String dbtype;
        String j_query = null;
        String[] cond = ruleDetails.get("table_Names").split(" ");
        switch (dbtype = ruleDetails.get("Database_Type").toUpperCase()) {
            case "ORACLE_NATIVE": 
            case "ORACLE_ODBC": {
                if (cond.length > 3) {
                    j_query = this.getMultiJoinQuery(ruleDetails, ruleDetails.get("Database_Type"));
                    break;
                }
                String temp = ruleDetails.get("table_Names");
                temp = temp.replaceAll("-", " ");
                j_query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names") + " ON " + ruleDetails.get("condition_Names");
                break;
            }
            case "MYSQL": {
                String temp;
                if (cond.length > 3) {
                    j_query = this.getMultiJoinQuery(ruleDetails, ruleDetails.get("Database_Type"));
                } else {
                    temp = ruleDetails.get("table_Names");
                    temp = temp.replaceAll("-", " ");
                    j_query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names") + " ON " + ruleDetails.get("condition_Names");
                }
            }
            case "SQL_SERVER": {
                if (cond.length > 3) {
                    j_query = this.getMultiJoinQuery(ruleDetails, ruleDetails.get("Database_Type"));
                    break;
                }
                String temp = ruleDetails.get("table_Names");
                temp = temp.replaceAll("-", " ");
                j_query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names") + " ON " + ruleDetails.get("condition_Names");
                break;
            }
            case "INFORMIX": {
                if (cond.length > 3) {
                    j_query = this.getMultiJoinQuery(ruleDetails, ruleDetails.get("Database_Type"));
                    break;
                }
                String temp = ruleDetails.get("table_Names");
                temp = temp.replaceAll("-", " ");
                j_query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names") + " WHERE " + ruleDetails.get("condition_Names");
                break;
            }
            case "SPLICE": {
                if (cond.length > 3) {
                    j_query = this.getMultiJoinQuery(ruleDetails, ruleDetails.get("Database_Type"));
                    break;
                }
                String temp = ruleDetails.get("table_Names");
                temp = temp.replaceAll("-", " ");
                j_query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names") + " ON " + ruleDetails.get("condition_Names");
                break;
            }
            case "MS_ACCESS": {
                if (cond.length > 3) {
                    j_query = this.getMultiJoinQuery(ruleDetails, ruleDetails.get("Database_Type"));
                    break;
                }
                String temp = ruleDetails.get("table_Names");
                temp = temp.replaceAll("-", " ");
                j_query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names") + " WHERE " + ruleDetails.get("condition_Names");
                break;
            }
            case "POSTGRES": {
                if (cond.length > 3) {
                    j_query = this.getMultiJoinQuery(ruleDetails, ruleDetails.get("Database_Type"));
                    break;
                }
                String temp = ruleDetails.get("table_Names");
                temp = temp.replaceAll("-", " ");
                j_query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names") + " ON " + ruleDetails.get("condition_Names");
                break;
            }
            case "DB2": 
            case "HIVE": {
                if (cond.length > 3) {
                    j_query = this.getMultiJoinQuery(ruleDetails, ruleDetails.get("Database_Type"));
                    break;
                }
                String temp = ruleDetails.get("table_Names");
                temp = temp.replaceAll("-", " ");
                j_query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names") + " ON (" + ruleDetails.get("condition_Names") + ")";
                break;
            }
            default: {
                if (cond.length > 3) {
                    j_query = this.getMultiJoinQuery(ruleDetails, ruleDetails.get("Database_Type"));
                    break;
                }
                String temp = ruleDetails.get("table_Names");
                temp = temp.replaceAll("-", " ");
                j_query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names") + " ON (" + ruleDetails.get("condition_Names") + ")";
            }
        }
        return j_query;
    }

    private String getMultiJoinQuery(Hashtable<String, String> ruleDetails, String dbType) {
        String[] tables = ruleDetails.get("table_Names").split(" ");
        String[] condition = ruleDetails.get("condition_Names").split(" ");
        String query = "";
        if (tables.length == 5) {
            for (int i = 0; i < tables.length; ++i) {
                if (!tables[i].contains("-")) continue;
                tables[i] = tables[i].replaceAll("-", " ");
            }
            switch (dbType) {
                case "ORACLE_NATIVE": 
                case "ORACLE_ODBC": 
                case "MYSQL": 
                case "SQL_SERVER": 
                case "SPLICE": {
                    query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + tables[0] + " " + tables[1] + " " + tables[2] + " ON " + condition[0] + " " + tables[3] + " " + tables[4] + " ON " + condition[2];
                    break;
                }
                case "MS_ACCESS": 
                case "INFORMIX": {
                    query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + tables[0] + " " + tables[1] + " " + tables[2] + " WHERE " + condition[0] + " " + tables[3] + " " + tables[4] + " WHERE " + condition[2];
                    break;
                }
                case "POSTGRES": 
                case "DB2": 
                case "HIVE": {
                    query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + tables[0] + " " + tables[1] + " " + tables[2] + " ON " + condition[0] + " " + tables[3] + " " + tables[4] + " ON " + "(" + condition[2] + ")";
                    break;
                }
                default: {
                    query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + tables[0] + " " + tables[1] + " " + tables[2] + " ON " + condition[0] + " " + tables[3] + " " + tables[4] + " ON " + "(" + condition[2] + ")";
                }
            }
        }
        if (tables.length == 7) {
            for (int i = 0; i < tables.length; ++i) {
                if (!tables[i].contains("-")) continue;
                tables[i] = tables[i].replaceAll("-", " ");
            }
            switch (dbType) {
                case "ORACLE_NATIVE": 
                case "ORACLE_ODBC": 
                case "MYSQL": 
                case "SQL_SERVER": 
                case "SPLICE": {
                    query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + tables[0] + " " + tables[1] + " " + tables[2] + " ON " + condition[0] + " " + tables[3] + " " + tables[4] + " ON " + condition[2] + " " + tables[5] + " " + tables[6] + " ON " + condition[4];
                    break;
                }
                case "MS_ACCESS": 
                case "INFORMIX": {
                    query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + tables[0] + " " + tables[1] + " " + tables[2] + " WHERE " + condition[0] + " " + tables[3] + " " + tables[4] + " WHERE " + condition[2] + " " + tables[5] + " " + tables[6] + " WHERE " + condition[4];
                    break;
                }
                case "POSTGRES": 
                case "DB2": 
                case "HIVE": {
                    query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + tables[0] + " " + tables[1] + " " + tables[2] + " ON " + condition[0] + " " + tables[3] + " " + tables[4] + " ON " + "(" + condition[2] + ") " + tables[5] + " " + tables[6] + " ON " + "(" + condition[4] + ")";
                    break;
                }
                default: {
                    query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + tables[0] + " " + tables[1] + " " + tables[2] + " ON " + condition[0] + " " + tables[3] + " " + tables[4] + " ON " + "(" + condition[2] + ") " + tables[5] + " " + tables[6] + " ON " + "(" + condition[4] + ")";
                }
            }
        }
        if (tables.length == 9) {
            for (int i = 0; i < tables.length; ++i) {
                if (!tables[i].contains("-")) continue;
                tables[i] = tables[i].replaceAll("-", " ");
            }
            switch (dbType) {
                case "ORACLE_NATIVE": 
                case "ORACLE_ODBC": 
                case "MYSQL": 
                case "SQL_SERVER": 
                case "SPLICE": {
                    query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + tables[0] + " " + tables[1] + " " + tables[2] + " ON " + condition[0] + " " + tables[3] + " " + tables[4] + " ON " + condition[2] + " " + tables[5] + " " + tables[6] + " ON " + condition[4] + " " + tables[7] + tables[8] + " ON " + condition[6];
                    break;
                }
                case "MS_ACCESS": 
                case "INFORMIX": {
                    query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + tables[0] + " " + tables[1] + " " + tables[2] + " WHERE " + condition[0] + " " + tables[3] + " " + tables[4] + " WHERE " + condition[2] + " " + tables[5] + " " + tables[6] + " WHERE " + condition[4] + " " + tables[7] + tables[8] + " WHERE " + condition[6];
                    break;
                }
                case "POSTGRES": 
                case "DB2": 
                case "HIVE": {
                    query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + tables[0] + " " + tables[1] + " " + tables[2] + " ON " + condition[0] + " " + tables[3] + " " + tables[4] + " ON " + "(" + condition[2] + ")" + tables[5] + " " + tables[6] + " ON " + "(" + condition[4] + ") " + tables[7] + tables[8] + " ON " + "(" + condition[6] + ")";
                    break;
                }
                default: {
                    query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + tables[0] + " " + tables[1] + " " + tables[2] + " ON " + condition[0] + " " + tables[3] + " " + tables[4] + " ON " + "(" + condition[2] + ")" + tables[5] + " " + tables[6] + " ON " + "(" + condition[4] + ") " + tables[7] + tables[8] + " ON " + "(" + condition[6] + ")";
                }
            }
        }
        return query;
    }

    public String getNonJoinQuery(Hashtable<String, String> ruleDetails) {
        String j_query = null;
        switch (ruleDetails.get("Database_Type")) {
            case "ORACLE_NATIVE": 
            case "ORACLE_ODBC": {
                if (ruleDetails.get("condition_Names").equals("")) {
                    j_query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names");
                    break;
                }
                j_query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names") + " WHERE " + ruleDetails.get("condition_Names");
                break;
            }
            case "MYSQL": {
                j_query = ruleDetails.get("condition_Names").equals("") ? "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names") : "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names") + " WHERE " + ruleDetails.get("condition_Names");
            }
            case "SQL_SERVER": {
                if (ruleDetails.get("condition_Names").equals("")) {
                    j_query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names");
                    break;
                }
                j_query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names") + " WHERE " + ruleDetails.get("condition_Names");
                break;
            }
            case "INFORMIX": {
                if (ruleDetails.get("condition_Names").equals("")) {
                    j_query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names");
                    break;
                }
                j_query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names") + " WHERE " + ruleDetails.get("condition_Names");
                break;
            }
            case "SPLICE": {
                if (ruleDetails.get("condition_Names").equals("")) {
                    j_query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names");
                    break;
                }
                j_query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names") + " WHERE " + ruleDetails.get("condition_Names");
                break;
            }
            case "MS_ACCESS": {
                break;
            }
            case "POSTGRES": {
                if (ruleDetails.get("condition_Names").equals("")) {
                    j_query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names");
                    break;
                }
                j_query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names") + " WHERE " + ruleDetails.get("condition_Names");
                break;
            }
            case "DB2": {
                if (ruleDetails.get("condition_Names").equals("")) {
                    j_query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names");
                    break;
                }
                j_query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names") + " WHERE " + ruleDetails.get("condition_Names");
                break;
            }
            case "HIVE": {
                if (ruleDetails.get("condition_Names").equals("")) {
                    j_query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names");
                    break;
                }
                j_query = "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names") + " WHERE " + ruleDetails.get("condition_Names");
                break;
            }
            default: {
                j_query = ruleDetails.get("condition_Names").equals("") ? "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names") : "SELECT " + ruleDetails.get("column_Names") + " FROM " + ruleDetails.get("table_Names") + " WHERE " + ruleDetails.get("condition_Names");
            }
        }
        return j_query;
    }

    public List<String> get_all_tables(Hashtable<String, String> dbDetails) {
        ArrayList<String> db_tables = new ArrayList<String>();
        Rdbms_NewConn dbmsConn = null;
        ResultSet rs = null;
        try {
            dbmsConn = new Rdbms_NewConn(dbDetails);
            dbmsConn.openConn();
            System.out.println("Connected to " + dbDetails.get("Database_ConnName"));
            DatabaseMetaData md = dbmsConn.getMetaData();
            rs = md.getTables(null, null, "%", null);
            while (rs.next()) {
                db_tables.add(rs.getString("TABLE_NAME"));
            }
            dbmsConn.closeConn();
            rs.close();
            return db_tables;
        }
        catch (SQLException ex) {
            Logger.getLogger(QueryBuilder.class.getName()).log(Level.SEVERE, null, ex);
            return db_tables;
        }
    }

    public List<String> get_all_cols(Hashtable<String, String> dbDetails, String t_name) {
        ArrayList<String> db_cols = new ArrayList<String>();
        Rdbms_NewConn dbmsConn = null;
        ResultSet rsCol = null;
        try {
            dbmsConn = new Rdbms_NewConn(dbDetails);
            dbmsConn.openConn();
            rsCol = dbmsConn.getMetaData().getColumns(null, null, t_name, "%");
            while (rsCol.next()) {
                db_cols.add(rsCol.getString("COLUMN_NAME"));
            }
            dbmsConn.closeConn();
        }
        catch (SQLException ex) {
            Logger.getLogger(QueryBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
        return db_cols;
    }

    public static void setCond(String query) {
        isCond = true;
        _cond_q = "(" + query + ")";
    }

    public static void unsetCond() {
        isCond = false;
        _cond_q = "";
    }

    public static String getCond() {
        if (isCond) {
            return _cond_q;
        }
        return "";
    }

    public static Vector<?>[] getDateCondition() {
        if (dateVar == null) {
            dateVar = new Vector[2];
            return dateVar;
        }
        return dateVar;
    }

    public static void setDateCondition(Vector<?>[] vc) {
        dateVar = vc;
    }

    public String get_dsn() {
        return this._dsn;
    }

    public void set_dsn(String _dsn) {
        this._dsn = _dsn;
    }
}

