/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.scheduler;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import org.arrah.framework.rdbms.Rdbms_NewConn;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ScheduleJob
implements Job {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ResultSet rs = null;
        File file = new File("./scheduleoutput.csv");
        BufferedWriter out = null;
        Date date = new Date();
        String DATE_FORMAT = "dd_MM_yyyy_HH_mm_ss";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        String formatDate = sdf.format(date);
        try {
            if (file.exists()) {
                file = new File(file + "_" + formatDate + ".csv");
            }
            FileWriter fstream = new FileWriter(file);
            out = new BufferedWriter(fstream);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            context.getJobDetail().getJobDataMap().entrySet().stream().forEach(e -> hashtable.put((String)e.getKey(), (String)e.getValue()));
            Rdbms_NewConn dbConn = new Rdbms_NewConn(hashtable);
            dbConn.openConn();
            String query = context.getJobDetail().getJobDataMap().getString("query");
            if (query == null) {
                System.out.println("Query is null");
                throw new JobExecutionException("Query is null");
            }
            rs = dbConn.execute(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            while (rs.next()) {
                for (int j = 0; j < numberOfColumns; ++j) {
                    out.append(rs.getString(rsmd.getColumnName(j + 1))).append(",");
                }
                out.write("\n");
            }
            System.out.println("Job executed");
        }
        catch (SQLException e2) {
            System.out.println("Job failed because of SQL Exception" + e2);
            e2.printStackTrace();
        }
        catch (Exception e3) {
            System.out.println("Job failed with an exception" + e3);
            e3.printStackTrace();
        }
        finally {
            try {
                out.close();
                System.out.println("File Saved at:" + file.getAbsolutePath());
            }
            catch (IOException e4) {
                e4.printStackTrace();
            }
        }
    }
}

