/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.xml;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.arrah.framework.ndtable.ReportTableModel;
import org.arrah.framework.xml.DOMValidator;
import org.arrah.framework.xml.FilePaths;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlReader {
    String colNames = "";
    private static final String DTD_ERRORS = "resource/DTD_Errors.txt";
    private String[] headings = null;
    private String[] nodeList = null;
    private ReportTableModel reportTable = null;
    private Document document = null;
    private Hashtable<String, String> hashTable = null;
    private Hashtable<String, String> hashRule = null;

    public String[] getRulesName(File file, String rule, String ruleName) {
        if (file.exists() && file.length() > 0L) {
            this.parseDocument(file);
            NodeList nList = this.document.getElementsByTagName(rule);
            this.nodeList = new String[nList.getLength()];
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1) continue;
                Element eElement = (Element)nNode;
                this.nodeList[temp] = eElement.getElementsByTagName(ruleName).item(0).getTextContent().trim();
            }
        }
        return this.nodeList;
    }

    public String[] getDBNames() {
        File file = new File(FilePaths.getConnFilePath());
        if (file.exists() && file.length() > 0L) {
            this.parseDocument(file);
            NodeList nList = this.document.getElementsByTagName("entry");
            this.nodeList = new String[nList.getLength()];
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1) continue;
                Element eElement = (Element)nNode;
                this.nodeList[temp] = eElement.getElementsByTagName("database_ConnectionName").item(0).getTextContent().trim();
            }
        }
        return this.nodeList;
    }

    public Hashtable<String, String> getDatabaseDetails(File file, String fileEntry, String connName) {
        if (file.exists() && file.length() > 0L) {
            this.parseDocument(file);
            NodeList nList = this.document.getElementsByTagName(fileEntry);
            this.nodeList = new String[nList.getLength()];
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Element eElement;
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1 || !(eElement = (Element)nNode).getElementsByTagName("database_ConnectionName").item(0).getTextContent().trim().equals(connName)) continue;
                this.hashTable = new Hashtable();
                this.hashTable.put("Database_Type", eElement.getElementsByTagName("database_Type").item(0).getTextContent().trim());
                this.hashTable.put("Database_DSN", eElement.getElementsByTagName("database_DSN").item(0).getTextContent().trim());
                this.hashTable.put("Database_Protocol", eElement.getElementsByTagName("database_Protocol").item(0).getTextContent().trim());
                this.hashTable.put("Database_Driver", eElement.getElementsByTagName("database_Driver").item(0).getTextContent().trim());
                this.hashTable.put("Database_User", eElement.getElementsByTagName("database_User").item(0).getTextContent().trim());
                this.hashTable.put("Database_Passwd", eElement.getElementsByTagName("database_Passwd").item(0).getTextContent().trim());
                this.hashTable.put("Database_JDBC", eElement.getElementsByTagName("database_JDBC").item(0).getTextContent().trim());
                this.hashTable.put("Database_ConnName", eElement.getElementsByTagName("database_ConnectionName").item(0).getTextContent().trim());
            }
        }
        return this.hashTable;
    }

    public Hashtable<String, String> getRuleDetails(File file, String ruleEntry, String ruleName) {
        if (file.exists() && file.length() > 0L) {
            this.parseDocument(file);
            NodeList nList = this.document.getElementsByTagName(ruleEntry);
            this.nodeList = new String[nList.getLength()];
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Element eElement;
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1 || !(eElement = (Element)nNode).getElementsByTagName("rule_Name").item(0).getTextContent().trim().equals(ruleName)) continue;
                this.hashRule = new Hashtable();
                try {
                    this.hashRule.put("rule_Name", eElement.getElementsByTagName("rule_Name").item(0).getTextContent().trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.hashRule.put("database_ConnectionName", eElement.getElementsByTagName("database_ConnectionName").item(0).getTextContent().trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.hashRule.put("rule_Type", eElement.getElementsByTagName("rule_Type").item(0).getTextContent().trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.hashRule.put("table_Names", eElement.getElementsByTagName("table_Names").item(0).getTextContent().trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.hashRule.put("column_Names", eElement.getElementsByTagName("column_Names").item(0).getTextContent().trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.hashRule.put("condition_Names", eElement.getElementsByTagName("condition_Names").item(0).getTextContent().trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.hashRule.put("join_Name", eElement.getElementsByTagName("join_Name").item(0).getTextContent().trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.hashRule.put("rule_Description", eElement.getElementsByTagName("rule_Description").item(0).getTextContent().trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.hashRule.put("query_Text", eElement.getElementsByTagName("query_Text").item(0).getTextContent().trim());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.hashRule;
    }

    public String getColumnNames(File file, String ruleName) {
        this.parseDocument(file);
        NodeList nodes = this.document.getElementsByTagName("rule");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            Element element = (Element)node;
            if (!ruleName.equals(XmlReader.getValue("rule_Name", element))) continue;
            this.colNames = XmlReader.getValue("column_Names", element);
        }
        return this.colNames;
    }

    private static String getValue(String tag, Element element) {
        NodeList nodes = element.getElementsByTagName(tag).item(0).getChildNodes();
        Node node = nodes.item(0);
        if (node == null) {
            return "";
        }
        return node.getNodeValue();
    }

    public ReportTableModel read(File file) {
        DOMValidator domValidator = new DOMValidator();
        domValidator.setErrorFile(new File(DTD_ERRORS));
        domValidator.validate(file);
        if (domValidator.getErrorCount() > 0) {
            System.out.println("\n " + domValidator.getErrorCount() + " DTD errors found, see " + DTD_ERRORS);
        }
        this.parseDocument(file);
        this.getHeadings();
        this.getRowData();
        return this.reportTable;
    }

    private void parseDocument(File file) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            this.document = docBuilder.parse(file);
            this.document.getDocumentElement().normalize();
        }
        catch (SAXException exc) {
            System.out.println("\n XmlReader error:" + exc.getMessage());
        }
        catch (ParserConfigurationException exc) {
            System.out.println("\n XmlReader error:" + exc.getMessage());
        }
        catch (IOException exc) {
            System.out.println("\n XmlReader error:" + exc.getMessage());
        }
    }

    private void getHeadings() {
        if (this.document == null) {
            return;
        }
        NodeList headerList = this.document.getElementsByTagName("header");
        if (headerList == null) {
            return;
        }
        Node firstNode = headerList.item(0);
        if (firstNode == null) {
            return;
        }
        if (firstNode.getNodeType() == 1) {
            Element element = (Element)firstNode;
            NodeList nodeList = element.getElementsByTagName("columnName");
            this.headings = new String[nodeList.getLength()];
            for (int index = 0; index < nodeList.getLength(); ++index) {
                Element columnName = (Element)nodeList.item(index);
                NodeList columnNameNode = columnName.getChildNodes();
                Node firstItem = columnNameNode.item(0);
                this.headings[index] = firstItem == null ? null : firstItem.getNodeValue();
            }
            this.reportTable = new ReportTableModel(this.headings, true, true);
        }
    }

    private void getRowData() {
        if (this.document == null) {
            return;
        }
        NodeList rowNodeList = this.document.getElementsByTagName("row");
        for (int rowIndex = 0; rowIndex < rowNodeList.getLength(); ++rowIndex) {
            Node node = rowNodeList.item(rowIndex);
            if (node.getNodeType() != 1 || this.headings == null) continue;
            String[] rowdata = new String[this.headings.length];
            for (int colIndex = 0; colIndex < this.headings.length; ++colIndex) {
                NodeList dataValueNode;
                Element dataValueElement = (Element)node;
                NodeList dataValueNodeList = dataValueElement.getElementsByTagName(this.headings[colIndex]);
                Element firstElement = (Element)dataValueNodeList.item(0);
                if (firstElement == null || (dataValueNode = firstElement.getChildNodes()) == null) continue;
                Node firstItem = dataValueNode.item(0);
                rowdata[colIndex] = firstItem == null ? null : firstItem.getNodeValue();
            }
            this.reportTable.addFillRow(rowdata);
        }
    }
}

