/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.derby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.DerivedColumn;
import org.teiid.language.LanguageObject;
import org.teiid.language.Limit;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.EscapeSyntaxModifier;
import org.teiid.translator.jdbc.db2.BaseDB2ExecutionFactory;
import org.teiid.translator.jdbc.oracle.LeftOrRightFunctionModifier;
import org.teiid.util.Version;

@Translator(name="derby", description="A translator for Apache Derby Database")
public class DerbyExecutionFactory
extends BaseDB2ExecutionFactory {
    public static final Version TEN_1 = Version.getVersion((String)"10.1");
    public static final Version TEN_2 = Version.getVersion((String)"10.2");
    public static final Version TEN_3 = Version.getVersion((String)"10.3");
    public static final Version TEN_4 = Version.getVersion((String)"10.4");
    public static final Version TEN_5 = Version.getVersion((String)"10.5");
    public static final Version TEN_6 = Version.getVersion((String)"10.6");
    public static final Version TEN_7 = Version.getVersion((String)"10.7");

    public DerbyExecutionFactory() {
        this.setSupportsFullOuterJoins(false);
    }

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("timestampadd", new EscapeSyntaxModifier());
        this.registerFunctionModifier("timestampdiff", new EscapeSyntaxModifier());
        this.registerFunctionModifier("left", new LeftOrRightFunctionModifier(this.getLanguageFactory()));
        this.registerFunctionModifier("concat", new EscapeSyntaxModifier());
    }

    @Override
    public boolean addSourceComment() {
        return false;
    }

    public boolean supportsOrderByNullOrdering() {
        return this.getVersion().compareTo(TEN_4) >= 0;
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getDefaultSupportedFunctions());
        supportedFunctions.add("ABS");
        if (this.getVersion().compareTo(TEN_2) >= 0) {
            supportedFunctions.add("ACOS");
            supportedFunctions.add("ASIN");
            supportedFunctions.add("ATAN");
        }
        if (this.getVersion().compareTo(TEN_4) >= 0) {
            supportedFunctions.add("ATAN2");
        }
        if (this.getVersion().compareTo(TEN_2) >= 0) {
            supportedFunctions.add("CEILING");
            supportedFunctions.add("COS");
            supportedFunctions.add("COT");
            supportedFunctions.add("DEGREES");
            supportedFunctions.add("EXP");
            supportedFunctions.add("FLOOR");
            supportedFunctions.add("LOG");
            supportedFunctions.add("LOG10");
        }
        supportedFunctions.add("MOD");
        if (this.getVersion().compareTo(TEN_2) >= 0) {
            supportedFunctions.add("PI");
            supportedFunctions.add("RADIANS");
            if (this.getVersion().compareTo(TEN_4) >= 0) {
                supportedFunctions.add("SIGN");
            }
            supportedFunctions.add("SIN");
        }
        supportedFunctions.add("SQRT");
        supportedFunctions.add("CONCAT");
        supportedFunctions.add("LCASE");
        supportedFunctions.add("LEFT");
        supportedFunctions.add("LENGTH");
        supportedFunctions.add("LOCATE");
        supportedFunctions.add("LTRIM");
        supportedFunctions.add("RTRIM");
        supportedFunctions.add("SUBSTRING");
        if (this.getVersion().compareTo(TEN_3) >= 0) {
            supportedFunctions.add("trim");
        }
        supportedFunctions.add("UCASE");
        supportedFunctions.add("DAYOFMONTH");
        supportedFunctions.add("HOUR");
        supportedFunctions.add("MINUTE");
        supportedFunctions.add("MONTH");
        supportedFunctions.add("SECOND");
        supportedFunctions.add("TIMESTAMPADD");
        supportedFunctions.add("TIMESTAMPDIFF");
        supportedFunctions.add("YEAR");
        supportedFunctions.add("CONVERT");
        supportedFunctions.add("IFNULL");
        supportedFunctions.add("COALESCE");
        return supportedFunctions;
    }

    public boolean supportsRowLimit() {
        return this.getVersion().compareTo(TEN_5) >= 0;
    }

    public boolean supportsRowOffset() {
        return this.getVersion().compareTo(TEN_5) >= 0;
    }

    @Override
    protected boolean usesDatabaseVersion() {
        return true;
    }

    @Override
    public String getHibernateDialectClassName() {
        if (this.getVersion().compareTo(TEN_6) >= 0) {
            if (this.getVersion().compareTo(TEN_7) >= 0) {
                return "org.hibernate.dialect.DerbyTenSevenDialect";
            }
            return "org.hibernate.dialect.DerbyTenSixDialect";
        }
        return "org.hibernate.dialect.DerbyTenFiveDialect";
    }

    public boolean supportsGroupByRollup() {
        return this.getVersion().compareTo(TEN_6) >= 0;
    }

    @Override
    public List<?> translate(LanguageObject obj, ExecutionContext context) {
        DerivedColumn selectSymbol;
        if (obj instanceof DerivedColumn && (selectSymbol = (DerivedColumn)obj).getExpression().getType() == TypeFacility.RUNTIME_TYPES.XML) {
            if (selectSymbol.getAlias() == null) {
                return Arrays.asList("XMLSERIALIZE(", selectSymbol.getExpression(), " AS CLOB)");
            }
            return Arrays.asList("XMLSERIALIZE(", selectSymbol.getExpression(), " AS CLOB) AS ", selectSymbol.getAlias());
        }
        return super.translate(obj, context);
    }

    @Override
    public List<?> translateLimit(Limit limit, ExecutionContext context) {
        if (limit.getRowOffset() > 0) {
            return Arrays.asList("OFFSET ", limit.getRowOffset(), " ROWS FETCH FIRST ", limit.getRowLimit(), " ROWS ONLY");
        }
        return super.translateLimit(limit, context);
    }
}

