/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.oracle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.language.Function;
import org.teiid.language.Literal;
import org.teiid.translator.jdbc.FunctionModifier;

public class TimestampAddModifier
extends FunctionModifier {
    private static Map<String, String> INTERVAL_MAP = new HashMap<String, String>();

    @Override
    public List<?> translate(Function function) {
        ArrayList<Object> result = new ArrayList<Object>();
        Literal intervalType = (Literal)function.getParameters().get(0);
        String interval = ((String)intervalType.getValue()).toUpperCase();
        int value = (Integer)((Literal)function.getParameters().get(1)).getValue();
        long adjustedValue = value;
        if (interval.equals("SQL_TSI_YEAR")) {
            interval = "SQL_TSI_MONTH";
            adjustedValue = (long)value * 12L;
        }
        if (interval.equals("SQL_TSI_MONTH")) {
            interval = "MONTH";
            result.add("ADD_MONTHS(");
            result.add(function.getParameters().get(2));
            result.add(", ");
            result.add(adjustedValue);
            result.add(")");
            return result;
        }
        result.add(function.getParameters().get(2));
        result.add(" + (INTERVAL '");
        String newInterval = INTERVAL_MAP.get(interval);
        if (newInterval != null) {
            result.add(value);
        } else if (interval.equals("SQL_TSI_QUARTER")) {
            newInterval = "MONTH";
            adjustedValue = (long)value * 3L;
            result.add(adjustedValue);
        } else if (interval.equals("SQL_TSI_FRAC_SECOND")) {
            newInterval = "SECOND";
            result.add(String.format("0.%09d", value));
            adjustedValue = 1L;
        } else {
            newInterval = "DAY";
            adjustedValue = (long)value * 7L;
            result.add(adjustedValue);
        }
        result.add("' ");
        result.add(newInterval);
        result.add("(");
        result.add(TimestampAddModifier.precision(Math.abs(adjustedValue)));
        result.add("))");
        return result;
    }

    static int precision(long value) {
        int precision = 1;
        while (value >= 10L) {
            ++precision;
            value /= 10L;
        }
        return precision;
    }

    static {
        INTERVAL_MAP.put("SQL_TSI_DAY", "DAY");
        INTERVAL_MAP.put("SQL_TSI_HOUR", "HOUR");
        INTERVAL_MAP.put("SQL_TSI_MINUTE", "MINUTE");
        INTERVAL_MAP.put("SQL_TSI_MONTH", "MONTH");
        INTERVAL_MAP.put("SQL_TSI_SECOND", "SECOND");
        INTERVAL_MAP.put("SQL_TSI_YEAR", "YEAR");
    }
}

