/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.postgresql;

import org.teiid.language.Array;
import org.teiid.language.ColumnReference;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Expression;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.With;
import org.teiid.language.WithItem;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.postgresql.PostgreSQLExecutionFactory;

public class PostgreSQLConversionVisitor
extends SQLConversionVisitor {
    private PostgreSQLExecutionFactory postgreSQLExecutionFactory;

    public PostgreSQLConversionVisitor(PostgreSQLExecutionFactory ef) {
        super(ef);
        this.postgreSQLExecutionFactory = ef;
    }

    protected void appendWithKeyword(With obj) {
        super.appendWithKeyword(obj);
        for (WithItem with : obj.getItems()) {
            if (!with.isRecusive()) continue;
            this.buffer.append(" ");
            this.buffer.append("RECURSIVE");
            break;
        }
    }

    @Override
    public void visit(DerivedColumn obj) {
        ColumnReference elem;
        if (obj.getExpression() instanceof Literal) {
            String castType = null;
            if (obj.getExpression().getType() == TypeFacility.RUNTIME_TYPES.STRING) {
                castType = "bpchar";
            } else if (obj.getExpression().getType() == TypeFacility.RUNTIME_TYPES.VARBINARY) {
                castType = "bytea";
            }
            if (castType != null) {
                obj.setExpression((Expression)this.postgreSQLExecutionFactory.getLanguageFactory().createFunction("cast", new Expression[]{obj.getExpression(), this.postgreSQLExecutionFactory.getLanguageFactory().createLiteral((Object)castType, TypeFacility.RUNTIME_TYPES.STRING)}, TypeFacility.RUNTIME_TYPES.STRING));
            }
        } else if (obj.isProjected() && obj.getExpression() instanceof ColumnReference && (elem = (ColumnReference)obj.getExpression()).getMetadataObject() != null) {
            String nativeType = elem.getMetadataObject().getNativeType();
            if (TypeFacility.RUNTIME_TYPES.STRING.equals(elem.getType()) && elem.getMetadataObject() != null && nativeType != null && nativeType.equalsIgnoreCase("uuid")) {
                obj.setExpression((Expression)this.postgreSQLExecutionFactory.getLanguageFactory().createFunction("cast", new Expression[]{obj.getExpression(), this.postgreSQLExecutionFactory.getLanguageFactory().createLiteral((Object)"varchar", TypeFacility.RUNTIME_TYPES.STRING)}, TypeFacility.RUNTIME_TYPES.STRING));
            }
        }
        super.visit(obj);
    }

    public void visit(Array array) {
        boolean allLiterals = true;
        Class baseType = array.getBaseType();
        if (!baseType.isArray() && this.postgreSQLExecutionFactory.convertModifier.getSimpleTypeMapping(ConvertModifier.getCode(baseType)) != null) {
            for (Expression ex : array.getExpressions()) {
                if (ex instanceof Literal) continue;
                allLiterals = false;
                break;
            }
            if (allLiterals) {
                this.addBinding((LanguageObject)new Literal((Object)array, array.getType()));
                return;
            }
        }
        super.visit(array);
    }
}

