/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.document;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teiid.language.Join;
import org.teiid.translator.document.Document;
import org.teiid.translator.document.DocumentNode;

class DocumentJoinNode
extends DocumentNode {
    private DocumentNode left;
    private DocumentNode right;
    private Join.JoinType type;

    public DocumentJoinNode(DocumentNode left, Join.JoinType joinType, DocumentNode right) {
        this.left = left;
        this.right = right;
        this.type = joinType;
    }

    public List<Map<String, Object>> mergeTuples(List<Map<String, Object>> leftRows, Document parentDocument) {
        List<Map<String, Object>> joinedRows;
        block10: {
            List<? extends Document> rightDocuments;
            block9: {
                joinedRows = new ArrayList<Map<String, Object>>();
                rightDocuments = parentDocument.getChildDocuments(this.right.getName());
                if (rightDocuments != null) break block9;
                if (!this.type.equals((Object)Join.JoinType.LEFT_OUTER_JOIN)) break block10;
                for (Map<String, Object> leftRow : leftRows) {
                    LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
                    row.putAll(leftRow);
                    joinedRows.add(row);
                }
                if (this.joinNode == null) break block10;
                joinedRows = this.joinNode.mergeTuples(joinedRows, parentDocument);
                break block10;
            }
            for (Map<String, Object> leftRow : leftRows) {
                for (Document document : rightDocuments) {
                    Map<String, Object> rightRow = document.getProperties();
                    LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
                    if (this.type.equals((Object)Join.JoinType.INNER_JOIN)) {
                        if (rightRow != null && !rightRow.isEmpty()) {
                            row.putAll(leftRow);
                            row.putAll(rightRow);
                        }
                    } else if (this.type.equals((Object)Join.JoinType.LEFT_OUTER_JOIN)) {
                        row.putAll(leftRow);
                        if (rightRow != null && !rightRow.isEmpty()) {
                            row.putAll(rightRow);
                        }
                    }
                    joinedRows.add(row);
                }
                if (this.joinNode == null) continue;
                for (Document document : rightDocuments) {
                    joinedRows = this.joinNode.mergeTuples(joinedRows, document);
                }
            }
        }
        return joinedRows;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.left);
        sb.append(this.type);
        sb.append(this.right);
        return sb.toString();
    }
}

