/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.swagger;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.HttpMethod;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.parser.SwaggerParser;
import java.io.File;
import java.sql.Blob;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.core.BundleUtil;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ExtensionMetadataProperty;
import org.teiid.metadata.MetadataException;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.swagger.BaseQueryExecution;
import org.teiid.translator.swagger.PropertyVisitor;
import org.teiid.translator.swagger.SwaggerExecutionFactory;
import org.teiid.translator.swagger.SwaggerPlugin;
import org.teiid.translator.swagger.SwaggerTypeManager;
import org.teiid.translator.ws.BinaryWSProcedureExecution;
import org.teiid.translator.ws.WSConnection;

public class SwaggerMetadataProcessor
implements MetadataProcessor<WSConnection> {
    private static final String ARRAY_SUFFIX = "[]";
    public static final String KEY_NAME = "key_name";
    public static final String KEY_VALUE = "key_value";
    @ExtensionMetadataProperty(applicable={Procedure.class}, datatype=String.class, display="URI", description="Used to define endpoint of the procedure", required=true)
    public static final String URI = "teiid_rest:URI";
    @ExtensionMetadataProperty(applicable={Procedure.class}, datatype=String.class, display="Http Method", description="Http method used to execute the procedure", required=true, allowed="GET,POST,PUT,DELETE,OPTIONS,HEAD,PATCH")
    public static final String METHOD = "teiid_rest:METHOD";
    @ExtensionMetadataProperty(applicable={Procedure.class}, datatype=String.class, display="Scheme", description="Scheme to use http, https etc.", allowed="HTTP,HTTPS")
    public static final String SCHEME = "teiid_rest:SCHEME";
    @ExtensionMetadataProperty(applicable={Procedure.class}, datatype=String.class, display="Produces", description="Used to define content type produced by this procedure, default JSON assumed")
    public static final String PRODUCES = "teiid_rest:PRODUCES";
    @ExtensionMetadataProperty(applicable={Procedure.class}, datatype=String.class, display="Consumes", description="Used to define content type consumed by this procedure with body type parameters. Default JSON assumed")
    public static final String CONSUMES = "teiid_rest:CONSUMES";
    @ExtensionMetadataProperty(applicable={Procedure.class}, datatype=String.class, display="Charset", description="Encoding of the return data")
    public static final String CHARSET = "teiid_rest:CHARSET";
    @ExtensionMetadataProperty(applicable={ProcedureParameter.class}, datatype=String.class, display="Parameter Type", description="Parameter type, as to how the parameter is being provided to the procedure", required=true, allowed="PATH,QUERY,FORM,FORMDATA,BODY,HEADER")
    public static final String PARAMETER_TYPE = "teiid_rest:PARAMETER_TYPE";
    @ExtensionMetadataProperty(applicable={ProcedureParameter.class}, datatype=String.class, display="Collection Format", description="Determines the format of the array if type array is used, like CSV,TSV etc.", allowed="CSV,SSV,TSV,PIPES,MULTI")
    public static final String COLLECION_FORMAT = "teiid_rest:COLLECION_FORMAT";
    private String swaggerFilePath;
    private boolean useDefaultHost = true;
    private String preferredScheme;
    private String preferredProduces = "application/json";
    private String preferredConsumes = "application/json";
    private SwaggerExecutionFactory ef;

    public SwaggerMetadataProcessor(SwaggerExecutionFactory ef) {
        this.ef = ef;
    }

    @TranslatorProperty(display="Swagger metadata file path", category=TranslatorProperty.PropertyType.IMPORT, description="Swagger metadata file path.")
    public String getSwaggerFilePath() {
        return this.swaggerFilePath;
    }

    public void setSwaggerFilePath(String swaggerFilePath) {
        this.swaggerFilePath = swaggerFilePath;
    }

    @TranslatorProperty(display="Use Host from Swagger File", category=TranslatorProperty.PropertyType.IMPORT, description="Use default host specified in the Swagger file; Defaults to true")
    public boolean isUseDefaultHost() {
        return this.useDefaultHost;
    }

    public void setUseDefaultHost(boolean useDefault) {
        this.useDefaultHost = useDefault;
    }

    @TranslatorProperty(display="Preferred Scheme", category=TranslatorProperty.PropertyType.IMPORT, description="Preferred Scheme to use when Swagger file supports multiple invocation schemes like http, https etc.")
    public String getPreferredScheme() {
        return this.preferredScheme;
    }

    public void setPreferredScheme(String scheme) {
        this.preferredScheme = scheme;
    }

    @TranslatorProperty(display="Preferred Accept Header", category=TranslatorProperty.PropertyType.IMPORT, description="Preferred Accept MIME type header, this should be one of the Swagger 'produces' types; default is application/json")
    public String getPreferredProduces() {
        return this.preferredProduces;
    }

    public void setPreferredProduces(String accept) {
        this.preferredProduces = accept;
    }

    @TranslatorProperty(display="Preferred Content-type Header", category=TranslatorProperty.PropertyType.IMPORT, description="Preferred Content-type header, this should be one of the Swagger 'consume' types, default is application/json")
    public String getPreferredConsumes() {
        return this.preferredConsumes;
    }

    public void setPreferredConsumes(String type) {
        this.preferredConsumes = type;
    }

    public void process(MetadataFactory mf, WSConnection connection) throws TranslatorException {
        Swagger swagger = this.getSchema(connection);
        String basePath = swagger.getBasePath();
        String scheme = null;
        if (swagger.getSchemes().size() > 0) {
            if (this.preferredScheme == null) {
                scheme = ((Scheme)swagger.getSchemes().get(0)).toValue();
            } else {
                for (Scheme s : swagger.getSchemes()) {
                    if (!s.toValue().equalsIgnoreCase(this.preferredScheme)) continue;
                    scheme = s.toValue();
                    break;
                }
                if (scheme == null) {
                    scheme = ((Scheme)swagger.getSchemes().get(0)).toValue();
                }
            }
        } else {
            scheme = this.preferredScheme;
            if (scheme == null) {
                scheme = "https";
            }
        }
        String httpHost = null;
        if (swagger.getHost() != null && !swagger.getHost().trim().isEmpty()) {
            httpHost = scheme + "://" + swagger.getHost();
        }
        if (this.useDefaultHost && httpHost != null) {
            httpHost = httpHost + basePath;
        }
        for (Map.Entry entry : swagger.getPaths().entrySet()) {
            this.addProcedure(mf, swagger, httpHost != null ? httpHost : basePath, (String)entry.getKey(), (Path)entry.getValue());
        }
    }

    private String buildURL(String basePath, String endpoint) {
        if (endpoint.startsWith("/")) {
            if (basePath.endsWith("/")) {
                return basePath + endpoint.substring(1);
            }
            return basePath + endpoint;
        }
        if (basePath.endsWith("/")) {
            return basePath + endpoint;
        }
        return basePath + "/" + endpoint;
    }

    private String getSchemes(Operation op) {
        StringBuilder sb = new StringBuilder();
        for (Scheme s : op.getSchemes()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(s.name());
        }
        return sb.toString();
    }

    private static <T> T nvl(T value, T ifNull) {
        if (value == null) {
            return ifNull;
        }
        return value;
    }

    public static Map<HttpMethod, Operation> getOperationMap(Path operations) {
        LinkedHashMap<HttpMethod, Operation> result = new LinkedHashMap<HttpMethod, Operation>();
        if (operations.getGet() != null) {
            result.put(HttpMethod.GET, operations.getGet());
        }
        if (operations.getPut() != null) {
            result.put(HttpMethod.PUT, operations.getPut());
        }
        if (operations.getPost() != null) {
            result.put(HttpMethod.POST, operations.getPost());
        }
        if (operations.getDelete() != null) {
            result.put(HttpMethod.DELETE, operations.getDelete());
        }
        if (operations.getPatch() != null) {
            result.put(HttpMethod.PATCH, operations.getPatch());
        }
        if (operations.getHead() != null) {
            result.put(HttpMethod.HEAD, operations.getHead());
        }
        if (operations.getOptions() != null) {
            result.put(HttpMethod.OPTIONS, operations.getOptions());
        }
        return result;
    }

    private void addProcedure(MetadataFactory mf, Swagger swagger, String basePath, String endpoint, Path operations) throws TranslatorException {
        for (Map.Entry<HttpMethod, Operation> entry : SwaggerMetadataProcessor.getOperationMap(operations).entrySet()) {
            Operation operation = entry.getValue();
            String produces = this.getTypes(SwaggerMetadataProcessor.nvl(operation.getProduces(), swagger.getProduces()), this.getPreferredProduces());
            String consumes = this.getTypes(SwaggerMetadataProcessor.nvl(operation.getConsumes(), swagger.getConsumes()), this.getPreferredConsumes());
            String name = operation.getOperationId();
            if (name == null) {
                int start = 0;
                if (endpoint.startsWith("/")) {
                    start = 1;
                }
                name = endpoint.substring(start);
                name = name.replaceAll("\\{([^}]*)\\}", "$1");
                if (operations.getOperationMap().entrySet().size() > 1) {
                    name = name + "_" + entry.getKey().name();
                }
            }
            Procedure procedure = mf.addProcedure(name);
            procedure.setVirtual(false);
            procedure.setProperty(METHOD, entry.getKey().name());
            if (operation.getSchemes() != null && !operation.getSchemes().isEmpty()) {
                procedure.setProperty(SCHEME, this.getSchemes(operation));
            }
            procedure.setProperty(URI, this.buildURL(basePath, endpoint));
            procedure.setProperty(PRODUCES, produces);
            procedure.setProperty(CONSUMES, consumes);
            procedure.setAnnotation(this.getOperationSummary(operation));
            for (Map.Entry extension : operation.getVendorExtensions().entrySet()) {
                procedure.setProperty((String)extension.getKey(), extension.getValue().toString());
            }
            this.addProcedureParameters(mf, swagger, procedure, operation);
            boolean returnAdded = false;
            Map respMap = operation.getResponses();
            for (String code : respMap.keySet()) {
                int httpCode;
                if (code.equalsIgnoreCase("default") || (httpCode = Integer.valueOf(code).intValue()) <= 100 || httpCode >= 300) continue;
                Response resp = (Response)respMap.get(code);
                returnAdded = this.buildResponse(mf, swagger, procedure, resp);
                break;
            }
            if (returnAdded || respMap.get("default") == null) continue;
            Response resp = (Response)respMap.get("default");
            returnAdded = this.buildResponse(mf, swagger, procedure, resp);
        }
    }

    private boolean buildResponse(final MetadataFactory mf, Swagger swagger, final Procedure procedure, Response resp) throws TranslatorException {
        Map headers;
        PropertyAction pa = new PropertyAction(){

            @Override
            public void execute(String name, String nameInSource, Property property, boolean array) {
                String type = SwaggerMetadataProcessor.getPropertyType(property, array);
                Column c = mf.addProcedureResultSetColumn(name, type, procedure);
                if (!name.equalsIgnoreCase(nameInSource)) {
                    c.setNameInSource(nameInSource);
                }
            }
        };
        Property schema = resp.getSchema();
        if (schema != null) {
            if (this.isSimple(schema)) {
                boolean array = false;
                if (schema instanceof ArrayProperty) {
                    schema = ((ArrayProperty)schema).getItems();
                    array = true;
                }
                if (resp.getHeaders() == null || resp.getHeaders().isEmpty()) {
                    String type = SwaggerTypeManager.teiidType(schema.getType(), schema.getFormat(), array);
                    mf.addProcedureParameter("return", type, ProcedureParameter.Type.ReturnValue, procedure);
                } else {
                    LinkedHashMap<String, Property> properties = new LinkedHashMap<String, Property>();
                    properties.put("return", schema);
                    this.walkProperties(swagger, properties, null, null, pa);
                }
            } else {
                if (schema instanceof ArrayProperty) {
                    schema = ((ArrayProperty)schema).getItems();
                }
                if (schema instanceof ObjectProperty) {
                    this.walkProperties(swagger, ((ObjectProperty)schema).getProperties(), null, null, pa);
                } else if (schema instanceof RefProperty) {
                    String modelName = ((RefProperty)schema).getSimpleRef();
                    Model model = (Model)swagger.getDefinitions().get(modelName);
                    this.walkProperties(swagger, model.getProperties(), null, null, pa);
                } else if (schema instanceof MapProperty) {
                    Property property = ((MapProperty)schema).getAdditionalProperties();
                    String type = SwaggerTypeManager.teiidType(property.getType(), property.getFormat(), false);
                    Column c = mf.addProcedureResultSetColumn(KEY_NAME, "string", procedure);
                    c.setNameInSource(KEY_NAME);
                    c = mf.addProcedureResultSetColumn(KEY_VALUE, type, procedure);
                    c.setNameInSource(KEY_VALUE);
                } else {
                    throw new TranslatorException("File properties are not supported");
                }
            }
        }
        if ((headers = resp.getHeaders()) != null && !headers.isEmpty()) {
            this.walkProperties(swagger, headers, null, null, pa);
        }
        return procedure.getResultSet() != null;
    }

    private boolean isSimple(Property property) {
        if (property instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)property;
            return this.isSimple(ap.getItems());
        }
        if (property instanceof RefProperty) {
            return false;
        }
        if (property instanceof ObjectProperty) {
            return false;
        }
        if (property instanceof MapProperty) {
            return false;
        }
        return !(property instanceof FileProperty);
    }

    private void walkProperties(Swagger swagger, Map<String, Property> properties, String namePrefix, String nisPrefix, PropertyAction pa) {
        this.walkProperties(swagger, new HashSet<Property>(), properties, namePrefix, nisPrefix, pa);
    }

    private void walkProperties(final Swagger swagger, final Set<Property> parents, final Map<String, Property> properties, final String namePrefix, final String nisPrefix, final PropertyAction pa) {
        if (properties == null) {
            return;
        }
        PropertyVisitor visitor = new PropertyVisitor(){

            @Override
            public void visit(String name, Property property) {
                pa.execute(SwaggerMetadataProcessor.this.fqn(namePrefix, name), SwaggerMetadataProcessor.this.nis(nisPrefix, name, false), property, false);
            }

            @Override
            public void visit(String name, ArrayProperty property) {
                if (SwaggerMetadataProcessor.this.isSimple((Property)property)) {
                    pa.execute(SwaggerMetadataProcessor.this.fqn(namePrefix, name), SwaggerMetadataProcessor.this.nis(nisPrefix, name, false), property.getItems(), true);
                } else {
                    Property items = property.getItems();
                    parents.add(property);
                    if (items instanceof ObjectProperty) {
                        String modelName = ((ObjectProperty)items).getName();
                        SwaggerMetadataProcessor.this.walkProperties(swagger, parents, ((ObjectProperty)items).getProperties(), SwaggerMetadataProcessor.this.fqn(SwaggerMetadataProcessor.this.fqn(namePrefix, name), modelName), SwaggerMetadataProcessor.this.nis(SwaggerMetadataProcessor.this.nis(nisPrefix, name, true), modelName, false), pa);
                    } else if (items instanceof RefProperty) {
                        String modelName = ((RefProperty)items).getSimpleRef();
                        Model model = (Model)swagger.getDefinitions().get(modelName);
                        SwaggerMetadataProcessor.this.walkProperties(swagger, parents, model.getProperties(), SwaggerMetadataProcessor.this.fqn(SwaggerMetadataProcessor.this.fqn(namePrefix, name), modelName), SwaggerMetadataProcessor.this.nis(SwaggerMetadataProcessor.this.nis(nisPrefix, name, true), modelName, false), pa);
                    } else {
                        SwaggerMetadataProcessor.this.walkProperties(swagger, parents, properties, SwaggerMetadataProcessor.this.fqn(namePrefix, name), SwaggerMetadataProcessor.this.nis(nisPrefix, name, true), pa);
                    }
                    parents.remove(property);
                }
            }

            @Override
            public void visit(String name, FileProperty property) {
            }

            @Override
            public void visit(String name, MapProperty property) {
            }

            @Override
            public void visit(String name, ObjectProperty property) {
                parents.add(property);
                SwaggerMetadataProcessor.this.walkProperties(swagger, parents, property.getProperties(), SwaggerMetadataProcessor.this.fqn(namePrefix, name), SwaggerMetadataProcessor.this.nis(nisPrefix, name, false), pa);
                parents.remove(property);
            }

            @Override
            public void visit(String name, RefProperty property) {
                parents.add(property);
                Model model = (Model)swagger.getDefinitions().get(property.getSimpleRef());
                SwaggerMetadataProcessor.this.walkProperties(swagger, parents, model.getProperties(), SwaggerMetadataProcessor.this.fqn(namePrefix, name), SwaggerMetadataProcessor.this.nis(nisPrefix, name, false), pa);
                parents.remove(property);
            }
        };
        for (Map.Entry<String, Property> p : properties.entrySet()) {
            if (parents.contains(p.getValue())) continue;
            visitor.accept(p.getKey(), p.getValue());
        }
    }

    private String fqn(String prefix, String name) {
        if (name == null) {
            return prefix;
        }
        return prefix == null ? name : prefix + "_" + name;
    }

    private String nis(String prefix, String name, boolean array) {
        String nis = null;
        if (name == null) {
            nis = prefix;
        } else {
            String string = nis = prefix == null ? name : prefix + "/" + name;
        }
        if (array) {
            nis = nis + ARRAY_SUFFIX;
        }
        return nis;
    }

    private static String getPropertyType(Property property, boolean array) {
        String type = "string";
        if (property != null) {
            type = SwaggerTypeManager.teiidType(property.getType(), property.getFormat(), array);
        } else if (array) {
            type = type + ARRAY_SUFFIX;
        }
        return type;
    }

    private void addProcedureParameters(final MetadataFactory mf, Swagger swagger, final Procedure procedure, Operation operation) throws TranslatorException {
        for (final Parameter parameter : operation.getParameters()) {
            AbstractSerializableParameter p;
            if (parameter instanceof BodyParameter) {
                PropertyAction pa = new PropertyAction(){

                    @Override
                    public void execute(String name, String nameInSource, Property property, boolean array) {
                        String type = SwaggerMetadataProcessor.getPropertyType(property, array);
                        if (procedure.getParameterByName(nameInSource) == null) {
                            ProcedureParameter param = mf.addProcedureParameter(name, type, ProcedureParameter.Type.In, procedure);
                            param.setProperty(SwaggerMetadataProcessor.PARAMETER_TYPE, parameter.getIn());
                            if (property != null && !property.getRequired()) {
                                param.setProperty("{http://www.teiid.org/ext/relational/2012}default_handling", "omit");
                            }
                            param.setNullType(BaseColumn.NullType.No_Nulls);
                            param.setAnnotation(property != null ? property.getDescription() : null);
                            if (!name.equalsIgnoreCase(nameInSource)) {
                                param.setNameInSource(nameInSource);
                            }
                        }
                    }
                };
                Model model = ((BodyParameter)parameter).getSchema();
                if (model instanceof RefModel) {
                    RefModel refModel = (RefModel)model;
                    if (refModel.getProperties() != null) {
                        this.walkProperties(swagger, refModel.getProperties(), null, null, pa);
                        continue;
                    }
                    if (refModel.getReference() == null) continue;
                    Model m = (Model)swagger.getDefinitions().get(refModel.getSimpleRef());
                    this.walkProperties(swagger, m.getProperties(), null, null, pa);
                    continue;
                }
                if (model instanceof ModelImpl && model.getProperties() != null) {
                    this.walkProperties(swagger, model.getProperties(), null, null, pa);
                    continue;
                }
                ProcedureParameter p2 = mf.addProcedureParameter(parameter.getName(), "clob", ProcedureParameter.Type.In, procedure);
                p2.setProperty(PARAMETER_TYPE, parameter.getIn());
                p2.setNullType(BaseColumn.NullType.No_Nulls);
                p2.setAnnotation(parameter.getDescription());
                continue;
            }
            String name = parameter.getName();
            ProcedureParameter pp = null;
            String type = null;
            Object defaultValue = null;
            String collectionFormat = null;
            if (parameter instanceof AbstractSerializableParameter) {
                p = (AbstractSerializableParameter)parameter;
                type = p.getType();
                if (p.getType().equalsIgnoreCase("array")) {
                    Property ap = p.getItems();
                    type = ap.getType();
                }
            } else {
                throw new MetadataException("Unknown property type" + parameter.getClass().getName());
            }
            type = SwaggerTypeManager.teiidType(type, p.getFormat(), p.getItems() != null);
            defaultValue = p.getDefaultValue();
            collectionFormat = p.getCollectionFormat();
            pp = mf.addProcedureParameter(name, type, ProcedureParameter.Type.In, procedure);
            pp.setProperty(PARAMETER_TYPE, parameter.getIn());
            boolean required = parameter.getRequired();
            if (!required) {
                pp.setProperty("{http://www.teiid.org/ext/relational/2012}default_handling", "omit");
            }
            pp.setNullType(BaseColumn.NullType.No_Nulls);
            pp.setAnnotation(parameter.getDescription());
            if (defaultValue != null) {
                pp.setDefaultValue(defaultValue.toString());
            }
            if (collectionFormat != null) {
                pp.setProperty(COLLECION_FORMAT, collectionFormat);
            }
            for (Map.Entry extension : parameter.getVendorExtensions().entrySet()) {
                pp.setProperty((String)extension.getKey(), extension.getValue().toString());
            }
        }
    }

    private String getOperationSummary(Operation operation) {
        String description = operation.getDescription();
        if (description == null || description.equals("")) {
            description = operation.getSummary();
        }
        return description;
    }

    private String getTypes(List<String> types, String preferred) {
        String selected = null;
        if (types != null && !types.isEmpty()) {
            for (String type : types) {
                if (preferred == null || !preferred.equalsIgnoreCase(type)) continue;
                selected = preferred;
            }
            if (selected == null) {
                selected = types.get(0);
            }
        }
        return selected;
    }

    protected Swagger getSchema(WSConnection conn) throws TranslatorException {
        Swagger swagger = null;
        try {
            String swaggerFile = this.getSwaggerFilePath();
            if (swaggerFile != null && !swaggerFile.isEmpty()) {
                File f = new File(swaggerFile);
                if (!f.exists() || !f.isFile()) {
                    throw new TranslatorException((BundleUtil.Event)SwaggerPlugin.Event.TEIID28019, SwaggerPlugin.Util.gs((BundleUtil.Event)SwaggerPlugin.Event.TEIID28019, new Object[]{swaggerFile}));
                }
                SwaggerParser parser = new SwaggerParser();
                swagger = parser.read(f.getAbsolutePath(), null, true);
            } else {
                BaseQueryExecution execution = new BaseQueryExecution(this.ef, null, null, conn);
                HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
                BinaryWSProcedureExecution call = execution.buildInvokeHTTP("GET", "swagger.json", null, headers);
                call.execute();
                if (call.getResponseCode() != 200) {
                    throw new TranslatorException((BundleUtil.Event)SwaggerPlugin.Event.TEIID28015, SwaggerPlugin.Util.gs((BundleUtil.Event)SwaggerPlugin.Event.TEIID28015, new Object[]{call.getResponseCode()}));
                }
                Blob out = (Blob)call.getOutputParameterValues().get(0);
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode rootNode = objectMapper.readTree(out.getBinaryStream());
                swagger = new SwaggerParser().read(rootNode, true);
            }
        }
        catch (Exception e) {
            throw new TranslatorException((BundleUtil.Event)SwaggerPlugin.Event.TEIID28016, (Throwable)e, SwaggerPlugin.Util.gs((BundleUtil.Event)SwaggerPlugin.Event.TEIID28016, new Object[]{e}));
        }
        return swagger;
    }

    static interface PropertyAction {
        public void execute(String var1, String var2, Property var3, boolean var4);
    }
}

