/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.swagger;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.document.Document;
import org.teiid.translator.swagger.SwaggerSerializer;

public class SwaggerResponse {
    private Iterator<Document> results;
    private List<Map<String, Object>> currentDocumentRows;
    private Map<String, Object> headers;
    private boolean mapResponse;

    public SwaggerResponse(InputStream payload, Map<String, Object> headers, SwaggerSerializer serializer, boolean mapResponse) throws TranslatorException {
        this.headers = headers;
        this.mapResponse = mapResponse;
        this.results = serializer.deserialize(payload).iterator();
    }

    public Map<String, Object> getNext() throws TranslatorException {
        if (this.currentDocumentRows != null && !this.currentDocumentRows.isEmpty()) {
            return this.currentDocumentRows.remove(0);
        }
        if (this.results.hasNext()) {
            Document d = this.results.next();
            ArrayList rows = d.flatten();
            ArrayList mapResults = new ArrayList();
            if (this.mapResponse && !rows.isEmpty()) {
                for (String key : ((Map)rows.get(0)).keySet()) {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put(key, ((Map)rows.get(0)).get(key));
                    mapResults.add(map);
                }
                rows = mapResults;
            }
            this.currentDocumentRows = rows;
            return this.getNext();
        }
        return null;
    }

    public boolean isMapResponse() {
        return this.mapResponse;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }
}

