/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;
import org.teiid.core.BundleUtil;
import org.teiid.language.Argument;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.ldap.IQueryToLdapSearchParser;
import org.teiid.translator.ldap.LDAPExecutionFactory;
import org.teiid.translator.ldap.LDAPPlugin;

public class LDAPDirectCreateUpdateDeleteQueryExecution
implements ProcedureExecution {
    private static final String ATTRIBUTES = "attributes";
    private List<Argument> arguments;
    protected LdapContext ldapConnection;
    protected LDAPExecutionFactory executionFactory;
    protected ExecutionContext executionContext;
    private int updateCount = -1;
    private boolean returnsArray = true;
    private String query;

    public LDAPDirectCreateUpdateDeleteQueryExecution(List<Argument> arguments, LDAPExecutionFactory factory, ExecutionContext executionContext, LdapContext connection, String query, boolean returnsArray) {
        this.arguments = arguments;
        this.executionFactory = factory;
        this.executionContext = executionContext;
        this.ldapConnection = connection;
        this.query = query;
        this.returnsArray = returnsArray;
    }

    public void execute() throws TranslatorException {
        String firstToken = null;
        StringTokenizer st = new StringTokenizer(this.query, ";");
        if (st.hasMoreTokens()) {
            firstToken = st.nextToken();
        }
        if (firstToken == null || !firstToken.equalsIgnoreCase("create") && !firstToken.equalsIgnoreCase("update") && !firstToken.equalsIgnoreCase("delete")) {
            throw new TranslatorException(LDAPPlugin.Util.gs((BundleUtil.Event)LDAPPlugin.Event.TEIID12009, new Object[0]));
        }
        LdapContext ldapCtx = null;
        try {
            ldapCtx = (LdapContext)this.ldapConnection.lookup("");
        }
        catch (NamingException ne) {
            throw new TranslatorException((Throwable)ne, LDAPPlugin.Util.getString("LDAPUpdateExecution.createContextError", new Object[]{ne.getExplanation()}));
        }
        if (firstToken.equalsIgnoreCase("delete")) {
            String theDN = this.getDN(st);
            if (st.hasMoreTokens()) {
                throw new TranslatorException(LDAPPlugin.Util.gs((BundleUtil.Event)LDAPPlugin.Event.TEIID12013, new Object[]{st.nextToken()}));
            }
            try {
                ldapCtx.destroySubcontext(theDN);
                this.updateCount = 1;
            }
            catch (NamingException ne) {
                throw new TranslatorException((Throwable)ne, LDAPPlugin.Util.getString("LDAPUpdateExecution.deleteFailed", new Object[]{theDN, ne.getExplanation()}));
            }
            catch (Exception e) {
                throw new TranslatorException((Throwable)e, LDAPPlugin.Util.getString("LDAPUpdateExecution.deleteFailedUnexpected", new Object[]{theDN}));
            }
        }
        if (firstToken.equalsIgnoreCase("create")) {
            String theDN = this.getDN(st);
            ArrayList<BasicAttribute> attributes = this.getAttributes(st);
            if (st.hasMoreTokens()) {
                throw new TranslatorException(LDAPPlugin.Util.gs((BundleUtil.Event)LDAPPlugin.Event.TEIID12013, new Object[]{st.nextToken()}));
            }
            BasicAttributes attrs = new BasicAttributes();
            for (BasicAttribute ba : attributes) {
                attrs.put(ba);
            }
            try {
                ldapCtx.createSubcontext(theDN, (Attributes)attrs);
                this.updateCount = 1;
            }
            catch (NamingException ne) {
                throw new TranslatorException((Throwable)ne, LDAPPlugin.Util.getString("LDAPUpdateExecution.insertFailed", new Object[]{theDN, ne.getExplanation()}));
            }
            catch (Exception e) {
                throw new TranslatorException((Throwable)e, LDAPPlugin.Util.getString("LDAPUpdateExecution.insertFailedUnexpected", new Object[]{theDN}));
            }
        }
        if (firstToken.equalsIgnoreCase("update")) {
            String theDN = this.getDN(st);
            ArrayList<BasicAttribute> attributes = this.getAttributes(st);
            if (st.hasMoreTokens()) {
                throw new TranslatorException(LDAPPlugin.Util.gs((BundleUtil.Event)LDAPPlugin.Event.TEIID12013, new Object[]{st.nextToken()}));
            }
            ModificationItem[] updateMods = new ModificationItem[attributes.size()];
            int i = 0;
            for (BasicAttribute ba : attributes) {
                updateMods[i++] = new ModificationItem(2, ba);
            }
            try {
                ldapCtx.modifyAttributes(theDN, updateMods);
                this.updateCount = 1;
            }
            catch (NamingException ne) {
                throw new TranslatorException((Throwable)ne, LDAPPlugin.Util.getString("LDAPUpdateExecution.updateFailed", new Object[]{theDN, ne.getExplanation()}));
            }
            catch (Exception e) {
                throw new TranslatorException((Throwable)e, LDAPPlugin.Util.getString("LDAPUpdateExecution.updateFailedUnexpected", new Object[]{theDN}));
            }
        }
    }

    private String getDN(StringTokenizer st) throws TranslatorException {
        if (!st.hasMoreTokens()) {
            throw new TranslatorException(LDAPPlugin.Util.gs((BundleUtil.Event)LDAPPlugin.Event.TEIID12010, new Object[0]));
        }
        return st.nextToken();
    }

    private ArrayList<BasicAttribute> getAttributes(StringTokenizer st) throws TranslatorException {
        if (!st.hasMoreTokens()) {
            throw new TranslatorException(LDAPPlugin.Util.gs((BundleUtil.Event)LDAPPlugin.Event.TEIID12011, new Object[0]));
        }
        ArrayList<BasicAttribute> attributes = new ArrayList<BasicAttribute>();
        if (st.hasMoreElements()) {
            String var = st.nextToken();
            int index = var.indexOf(61);
            if (index == -1) {
                throw new TranslatorException(LDAPPlugin.Util.gs((BundleUtil.Event)LDAPPlugin.Event.TEIID12011, new Object[0]));
            }
            String key = var.substring(0, index).trim();
            String value = var.substring(index + 1).trim();
            if (key.equalsIgnoreCase(ATTRIBUTES)) {
                StringTokenizer attrTokens = new StringTokenizer(value, ",");
                int attrCount = 0;
                while (attrTokens.hasMoreElements()) {
                    String name = attrTokens.nextToken().trim();
                    if (this.arguments.size() <= attrCount) {
                        throw new TranslatorException(LDAPPlugin.Util.gs((BundleUtil.Event)LDAPPlugin.Event.TEIID12012, new Object[]{name}));
                    }
                    Argument argument = this.arguments.get(attrCount++);
                    String anObj = null;
                    if (argument.getArgumentValue().getValue() != null) {
                        anObj = IQueryToLdapSearchParser.getLiteralString(argument.getArgumentValue());
                    }
                    attributes.add(new BasicAttribute(name, anObj));
                }
            } else {
                throw new TranslatorException(LDAPPlugin.Util.gs((BundleUtil.Event)LDAPPlugin.Event.TEIID12011, new Object[0]));
            }
        }
        return attributes;
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        return null;
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        if (this.updateCount != -1) {
            List<Object> row = Arrays.asList(this.updateCount);
            if (this.returnsArray) {
                Object[] columns = new Object[]{this.updateCount};
                row.set(0, columns);
            }
            this.updateCount = -1;
            return row;
        }
        return null;
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }
}

