/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.google.api.result;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.teiid.translator.google.api.result.PartialResultExecutor;
import org.teiid.translator.google.api.result.SheetRow;

public class RowsResult
implements Iterable<SheetRow> {
    private PartialResultExecutor queryStrategy;
    private int batchSize = 0;
    private Integer offset = 0;
    private Integer limit = null;

    public RowsResult(PartialResultExecutor queryStrategy, int batchSize) {
        this.queryStrategy = queryStrategy;
        this.batchSize = batchSize;
    }

    public void setOffset(int i) {
        this.offset = i;
    }

    public void setLimit(int i) {
        this.limit = i;
    }

    @Override
    public Iterator<SheetRow> iterator() {
        return new BatchingRowIterator();
    }

    private class BatchingRowIterator
    implements Iterator<SheetRow> {
        private int returnedAlready = 0;
        private List<SheetRow> currentBatch = new ArrayList<SheetRow>();
        private int position = -1;
        private int batchStartIndex = 0;
        private boolean noMoreBatches = false;

        private BatchingRowIterator() {
        }

        @Override
        public boolean hasNext() {
            if (RowsResult.this.limit != null && this.returnedAlready == RowsResult.this.limit) {
                return false;
            }
            if (this.position < this.currentBatch.size() - 1) {
                return true;
            }
            if (this.noMoreBatches) {
                return false;
            }
            this.currentBatch = RowsResult.this.queryStrategy.getResultsBatch(this.batchStartIndex + RowsResult.this.offset, RowsResult.this.batchSize);
            this.batchStartIndex += RowsResult.this.batchSize;
            if (this.currentBatch == null || this.currentBatch.size() == 0) {
                return false;
            }
            if (this.currentBatch.size() < RowsResult.this.batchSize) {
                this.noMoreBatches = true;
            }
            this.position = -1;
            return true;
        }

        @Override
        public SheetRow next() {
            ++this.returnedAlready;
            return this.currentBatch.get(++this.position);
        }

        @Override
        public void remove() {
        }
    }
}

