/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.simpledb;

import com.amazonaws.services.simpledb.model.Item;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.teiid.core.BundleUtil;
import org.teiid.language.Argument;
import org.teiid.language.Command;
import org.teiid.language.Select;
import org.teiid.logging.LogManager;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.simpledb.SimpleDBMetadataProcessor;
import org.teiid.translator.simpledb.SimpleDBPlugin;
import org.teiid.translator.simpledb.SimpleDBQueryExecution;
import org.teiid.translator.simpledb.api.SimpleDBConnection;

public class SimpleDBDirectQueryExecution
extends SimpleDBQueryExecution
implements ProcedureExecution {
    protected int columnCount;
    private List<Argument> arguments;
    protected int updateCount = -1;
    private String sourceSQL;

    public SimpleDBDirectQueryExecution(List<Argument> arguments, Command command, RuntimeMetadata metadata, SimpleDBConnection connection, ExecutionContext context) throws TranslatorException {
        super((Select)command, context, metadata, connection);
        this.arguments = arguments;
    }

    @Override
    public void execute() throws TranslatorException {
        this.sourceSQL = (String)this.arguments.get(0).getArgumentValue().getValue();
        List<Argument> parameters = this.arguments.subList(1, this.arguments.size());
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object)"Source sql", (Object)this.sourceSQL);
        int paramCount = parameters.size();
        if (paramCount > 0) {
            throw new TranslatorException((BundleUtil.Event)SimpleDBPlugin.Event.TEIID24003, SimpleDBPlugin.Util.gs((BundleUtil.Event)SimpleDBPlugin.Event.TEIID24003, new Object[0]));
        }
        if (!this.sourceSQL.toLowerCase().startsWith("select")) {
            throw new TranslatorException((BundleUtil.Event)SimpleDBPlugin.Event.TEIID24002, SimpleDBPlugin.Util.gs((BundleUtil.Event)SimpleDBPlugin.Event.TEIID24002, new Object[0]));
        }
        this.executeDirect(this.getSQL(), null);
    }

    @Override
    protected String getSQL() {
        return this.sourceSQL;
    }

    @Override
    protected List<?> buildRow(Item item) throws TranslatorException {
        Map<String, List<String>> valueMap = this.createAttributeMap(item.getAttributes());
        ArrayList<Object[]> row = new ArrayList<Object[]>();
        Object[] results = new Object[valueMap.size()];
        int i = 0;
        for (String attributeName : valueMap.keySet()) {
            if (SimpleDBMetadataProcessor.isItemName(attributeName)) {
                results[i++] = item.getName();
                continue;
            }
            List<String> value = valueMap.get(attributeName);
            results[i++] = value.size() == 1 ? value.get(0) : value.toString();
        }
        row.add(results);
        return row;
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        return null;
    }
}

