/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.simpledb;

import java.util.List;
import org.teiid.language.Argument;
import org.teiid.language.Command;
import org.teiid.language.Delete;
import org.teiid.language.Insert;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.language.Update;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.resource.api.ConnectionFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.simpledb.SimpleDBDeleteExecute;
import org.teiid.translator.simpledb.SimpleDBDirectQueryExecution;
import org.teiid.translator.simpledb.SimpleDBInsertExecute;
import org.teiid.translator.simpledb.SimpleDBMetadataProcessor;
import org.teiid.translator.simpledb.SimpleDBQueryExecution;
import org.teiid.translator.simpledb.SimpleDBUpdateExecute;
import org.teiid.translator.simpledb.api.SimpleDBConnection;

@Translator(name="simpledb", description="Translator for Amazon SimpleDB")
public class SimpleDBExecutionFactory
extends ExecutionFactory<ConnectionFactory, SimpleDBConnection> {
    public static final String INTERSECTION = "INTERSECTION";
    public static final String ASTRING = "ASTRING";
    public static final String EVERY = "EVERY";
    public static final String SIMPLEDB = "SIMPLEDB";

    public SimpleDBExecutionFactory() {
        this.setSupportsOrderBy(true);
        this.setSupportsDirectQueryProcedure(false);
        this.setSourceRequiredForMetadata(true);
        this.setTransactionSupport(ExecutionFactory.TransactionSupport.NONE);
    }

    public void start() throws TranslatorException {
        super.start();
        this.addPushDownFunction(SIMPLEDB, EVERY, "string", new String[]{"string[]"});
        this.addPushDownFunction(SIMPLEDB, INTERSECTION, "boolean", new String[]{"string[]", "string", "string"});
        this.addPushDownFunction(SIMPLEDB, INTERSECTION, "boolean", new String[]{"string[]", "string", "string", "string"});
        this.addPushDownFunction(SIMPLEDB, INTERSECTION, "boolean", new String[]{"string[]", "string", "string", "string", "string"});
    }

    public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, SimpleDBConnection connection) throws TranslatorException {
        if (command instanceof Insert) {
            return new SimpleDBInsertExecute(command, connection);
        }
        if (command instanceof Delete) {
            return new SimpleDBDeleteExecute(command, connection);
        }
        if (command instanceof Update) {
            return new SimpleDBUpdateExecute(command, connection);
        }
        throw new TranslatorException("Just INSERT, DELETE and UPDATE are supported");
    }

    public ProcedureExecution createDirectExecution(List<Argument> arguments, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, SimpleDBConnection connection) throws TranslatorException {
        return new SimpleDBDirectQueryExecution(arguments, command, metadata, connection, executionContext);
    }

    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, SimpleDBConnection connection) throws TranslatorException {
        return new SimpleDBQueryExecution((Select)command, executionContext, metadata, connection);
    }

    public MetadataProcessor<SimpleDBConnection> getMetadataProcessor() {
        return new SimpleDBMetadataProcessor();
    }

    public boolean supportsCompareCriteriaEquals() {
        return true;
    }

    public boolean supportsCompareCriteriaOrdered() {
        return true;
    }

    public boolean supportsInCriteria() {
        return true;
    }

    public boolean supportsIsNullCriteria() {
        return true;
    }

    public boolean supportsOnlyLiteralComparison() {
        return true;
    }

    public boolean supportsRowLimit() {
        return false;
    }

    public boolean supportsNotCriteria() {
        return true;
    }

    public boolean supportsOrCriteria() {
        return true;
    }

    public boolean supportsLikeCriteria() {
        return true;
    }

    public boolean supportsLikeCriteriaEscapeCharacter() {
        return true;
    }

    public boolean supportsAggregatesCountStar() {
        return true;
    }

    public boolean supportsArrayType() {
        return true;
    }

    public boolean supportsBulkUpdate() {
        return true;
    }

    public boolean returnsSingleUpdateCount() {
        return true;
    }
}

