/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.simpledb;

import java.util.Arrays;
import java.util.List;
import org.teiid.core.util.StringUtil;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.simpledb.api.SimpleDBConnection;

public class SimpleDBMetadataProcessor
implements MetadataProcessor<SimpleDBConnection> {
    public static final String ITEM_NAME = "itemName()";
    private static final String DISPLAY_ITEM_NAME = "ItemName";

    public void process(MetadataFactory metadataFactory, SimpleDBConnection connection) throws TranslatorException {
        List domains = connection.getDomains();
        for (String domain : domains) {
            Table table = metadataFactory.addTable(domain);
            table.setSupportsUpdate(true);
            Column itemName = metadataFactory.addColumn(DISPLAY_ITEM_NAME, "string", (ColumnSet)table);
            itemName.setUpdatable(true);
            itemName.setNameInSource(ITEM_NAME);
            itemName.setNullType(BaseColumn.NullType.No_Nulls);
            metadataFactory.addPrimaryKey("PK0", Arrays.asList(DISPLAY_ITEM_NAME), table);
            for (SimpleDBConnection.SimpleDBAttribute attribute : connection.getAttributeNames(domain)) {
                Column column = null;
                column = attribute.hasMultipleValues() ? metadataFactory.addColumn(attribute.getName(), "string[]", (ColumnSet)table) : metadataFactory.addColumn(attribute.getName(), "string", (ColumnSet)table);
                column.setUpdatable(true);
                column.setNullType(BaseColumn.NullType.Nullable);
            }
        }
    }

    private static String quote(String name) {
        return '`' + StringUtil.replaceAll((String)name, (String)"`", (String)"``") + '`';
    }

    public static String getName(AbstractMetadataRecord record) {
        return SQLStringVisitor.getRecordName((AbstractMetadataRecord)record);
    }

    public static String getQuotedName(AbstractMetadataRecord record) {
        String name = SimpleDBMetadataProcessor.getName(record);
        if (record instanceof Column && SimpleDBMetadataProcessor.isItemName(name)) {
            return name;
        }
        return SimpleDBMetadataProcessor.quote(name);
    }

    public static boolean isItemName(Column column) {
        return SimpleDBMetadataProcessor.isItemName(SimpleDBMetadataProcessor.getName((AbstractMetadataRecord)column));
    }

    public static boolean isItemName(String name) {
        return name.equalsIgnoreCase(ITEM_NAME);
    }
}

