/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.simpledb;

import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.Item;
import com.amazonaws.services.simpledb.model.SelectResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.teiid.language.LanguageObject;
import org.teiid.language.Select;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.simpledb.SimpleDBMetadataProcessor;
import org.teiid.translator.simpledb.SimpleDBSQLVisitor;
import org.teiid.translator.simpledb.api.SimpleDBConnection;
import org.teiid.translator.simpledb.api.SimpleDBDataTypeManager;

public class SimpleDBQueryExecution
implements ResultSetExecution {
    private static final int MAX_PAGE_SIZE = 2500;
    private Class<?>[] expectedColumnTypes;
    private ExecutionContext executionContext;
    private RuntimeMetadata metadata;
    protected SimpleDBConnection connection;
    private SimpleDBSQLVisitor visitor = new SimpleDBSQLVisitor();
    private String nextToken;
    protected Iterator<Item> listIterator;

    public SimpleDBQueryExecution(Select command, ExecutionContext executionContext, RuntimeMetadata metadata, SimpleDBConnection connection) throws TranslatorException {
        this.executionContext = executionContext;
        this.metadata = metadata;
        this.connection = connection;
        if (command != null) {
            this.visitor.append((LanguageObject)command);
            this.visitor.checkExceptions();
            this.expectedColumnTypes = command.getColumnTypes();
        }
    }

    public void execute() throws TranslatorException {
        this.executeDirect(this.getSQL(), null);
    }

    protected String getSQL() {
        return this.visitor.toString() + " LIMIT " + Math.min(this.executionContext.getBatchSize(), 2500);
    }

    protected void executeDirect(String sql, String next) throws TranslatorException {
        SelectResult result = this.connection.performSelect(sql, next);
        this.nextToken = result.getNextToken();
        this.listIterator = result.getItems().iterator();
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        if (this.listIterator.hasNext()) {
            return this.buildRow(this.listIterator.next());
        }
        if (this.nextToken != null) {
            this.executeDirect(this.getSQL(), this.nextToken);
            if (this.listIterator.hasNext()) {
                return this.buildRow(this.listIterator.next());
            }
        }
        return null;
    }

    protected List<?> buildRow(Item item) throws TranslatorException {
        Map<String, List<String>> valueMap = this.createAttributeMap(item.getAttributes());
        ArrayList<Object> row = new ArrayList<Object>();
        for (int i = 0; i < this.visitor.getProjectedColumns().size(); ++i) {
            String columnName = this.visitor.getProjectedColumns().get(i);
            if (SimpleDBMetadataProcessor.isItemName(columnName)) {
                row.add(SimpleDBDataTypeManager.convertFromSimpleDBType(Arrays.asList(item.getName()), this.expectedColumnTypes[i]));
                continue;
            }
            row.add(SimpleDBDataTypeManager.convertFromSimpleDBType(valueMap.get(columnName), this.expectedColumnTypes[i]));
        }
        return row;
    }

    protected Map<String, List<String>> createAttributeMap(List<Attribute> attributes) {
        TreeMap<String, List<String>> map = new TreeMap<String, List<String>>();
        for (Attribute attribute : attributes) {
            if (map.get(attribute.getName()) == null) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(attribute.getValue());
                map.put(attribute.getName(), list);
                continue;
            }
            ((List)map.get(attribute.getName())).add(attribute.getValue());
        }
        return map;
    }
}

