/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata4;

import java.util.List;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Property;
import org.teiid.translator.document.Document;

public class ODataDocument
extends Document {
    ODataDocument(String name, ODataDocument parent) {
        super(name, false, (Document)parent);
    }

    public ODataDocument() {
    }

    public static ODataDocument createDocument(Entity entity) {
        ODataDocument document = new ODataDocument();
        List properties = entity.getProperties();
        for (Property property : properties) {
            ODataDocument.populateDocument(property, document);
        }
        return document;
    }

    public static ODataDocument createDocument(ComplexValue complex) {
        ODataDocument document = new ODataDocument();
        List properties = complex.getValue();
        for (Property property : properties) {
            ODataDocument.populateDocument(property, document);
        }
        return document;
    }

    private static ODataDocument createDocument(String name, ComplexValue complex, ODataDocument parent) {
        ODataDocument document = new ODataDocument(name, parent);
        List properties = complex.getValue();
        for (Property property : properties) {
            ODataDocument.populateDocument(property, document);
        }
        return document;
    }

    private static void populateDocument(Property property, ODataDocument document) {
        if (property.isCollection()) {
            if (property.isPrimitive()) {
                document.addProperty(property.getName(), property.asCollection());
            } else {
                List complexRows = property.asCollection();
                for (ComplexValue complexRow : complexRows) {
                    document.addChildDocument(property.getName(), ODataDocument.createDocument(property.getName(), complexRow, document));
                }
            }
        } else if (property.isPrimitive()) {
            document.addProperty(property.getName(), property.asPrimitive());
        } else if (property.isComplex()) {
            document.addChildDocument(property.getName(), ODataDocument.createDocument(property.getName(), property.asComplex(), document));
        } else if (property.isGeospatial()) {
            document.addProperty(property.getName(), property.asGeospatial());
        } else {
            throw new AssertionError((Object)(property.getType() + " not supported"));
        }
    }
}

