/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata4;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.olingo.client.api.uri.QueryOption;
import org.teiid.core.util.StringUtil;
import org.teiid.metadata.Table;
import org.teiid.translator.document.DocumentNode;

public class ODataDocumentNode
extends DocumentNode {
    private final ODataDocumentType type;
    private LinkedHashSet<String> columns = new LinkedHashSet();
    private String filterStr;

    public ODataDocumentNode(Table t, ODataDocumentType type, boolean collection) {
        super(t, collection);
        this.type = type;
    }

    boolean isComplexType() {
        return this.type == ODataDocumentType.COMPLEX;
    }

    boolean isExpandType() {
        return this.type == ODataDocumentType.EXPAND;
    }

    boolean isPrimaryType() {
        return this.type == ODataDocumentType.PRIMARY;
    }

    void appendSelect(String columnName) {
        if (this.isComplexType()) {
            this.columns.add(this.getName());
        } else {
            this.columns.add(columnName);
        }
    }

    Set<String> getSelects() {
        return this.columns;
    }

    Map<QueryOption, Object> getOptions() {
        LinkedHashMap<QueryOption, Object> options = new LinkedHashMap<QueryOption, Object>();
        if (this.isExpandType()) {
            if (!this.columns.isEmpty()) {
                options.put(QueryOption.SELECT, StringUtil.join(this.columns, (String)","));
            }
            if (this.filterStr != null) {
                options.put(QueryOption.FILTER, this.filterStr);
            }
        }
        return options;
    }

    void addFilter(String string) {
        this.filterStr = this.filterStr == null ? string : this.filterStr + " and " + string;
    }

    String getFilter() {
        return this.filterStr;
    }

    static enum ODataDocumentType {
        PRIMARY,
        COMPLEX,
        EXPAND;

    }
}

