/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata4;

import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.olingo.client.api.edm.xml.XMLMetadata;
import org.apache.olingo.client.core.serialization.ClientODataDeserializerImpl;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.StringUtil;
import org.teiid.language.Call;
import org.teiid.language.Command;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.Literal;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.resource.api.ConnectionFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.odata4.BaseQueryExecution;
import org.teiid.translator.odata4.ODataMetadataProcessor;
import org.teiid.translator.odata4.ODataPlugin;
import org.teiid.translator.odata4.ODataProcedureExecution;
import org.teiid.translator.odata4.ODataQueryExecution;
import org.teiid.translator.odata4.ODataUpdateExecution;
import org.teiid.translator.ws.BinaryWSProcedureExecution;
import org.teiid.translator.ws.WSConnection;

@Translator(name="odata4", description="A translator for making OData V4 data service calls")
public class ODataExecutionFactory
extends ExecutionFactory<ConnectionFactory, WSConnection> {
    public static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getDefault();
    static final String INVOKE_HTTP = "invokeHttp";
    protected Map<String, FunctionModifier> functionModifiers = new TreeMap<String, FunctionModifier>(String.CASE_INSENSITIVE_ORDER);
    private boolean supportsOdataFilter;
    private boolean supportsOdataOrderBy;
    private boolean supportsOdataCount;
    private boolean supportsOdataSkip;
    private boolean supportsOdataTop;
    private boolean supportsUpdates = true;
    private XMLMetadata serviceMatadata;

    public ODataExecutionFactory() {
        this.setSourceRequiredForMetadata(true);
        this.setSupportsInnerJoins(true);
        this.setSupportsOrderBy(true);
        this.setSupportsOuterJoins(true);
        this.setSupportsFullOuterJoins(true);
        this.setSupportedJoinCriteria(ExecutionFactory.SupportedJoinCriteria.KEY);
        this.setSupportsOdataCount(true);
        this.setSupportsOdataFilter(true);
        this.setSupportsOdataOrderBy(true);
        this.setSupportsOdataSkip(false);
        this.setSupportsOdataTop(false);
        this.setTransactionSupport(ExecutionFactory.TransactionSupport.NONE);
        this.registerFunctionModifier("convert", (FunctionModifier)new AliasModifier("cast"));
        this.registerFunctionModifier("locate", new FunctionModifier(){

            public List<?> translate(Function function) {
                function.setName("+");
                Expression param1 = (Expression)function.getParameters().get(0);
                Expression param2 = (Expression)function.getParameters().get(1);
                Function indexOf = new Function("indexof", Arrays.asList(param2, param1), TypeFacility.RUNTIME_TYPES.INTEGER);
                indexOf.setMetadataObject(function.getMetadataObject());
                function.getParameters().set(0, indexOf);
                function.getParameters().set(1, new Literal((Object)1, TypeFacility.RUNTIME_TYPES.INTEGER));
                return null;
            }
        });
        this.registerFunctionModifier("substring", new FunctionModifier(){

            public List<?> translate(Function function) {
                if (function.getParameters().size() != 3) {
                    return null;
                }
                Expression param2 = (Expression)function.getParameters().get(1);
                param2 = new Function("+", Arrays.asList(param2, new Literal((Object)1, TypeFacility.RUNTIME_TYPES.INTEGER)), TypeFacility.RUNTIME_TYPES.INTEGER);
                function.getParameters().set(1, param2);
                return null;
            }
        });
        this.registerFunctionModifier("lcase", (FunctionModifier)new AliasModifier("tolower"));
        this.registerFunctionModifier("ucase", (FunctionModifier)new AliasModifier("toupper"));
        this.registerFunctionModifier("dayofmonth", (FunctionModifier)new AliasModifier("day"));
        this.registerFunctionModifier("st_distance", (FunctionModifier)new AliasModifier("geo.distance"));
        this.registerFunctionModifier("st_intersects", (FunctionModifier)new AliasModifier("geo.intersects"));
        this.registerFunctionModifier("st_length", (FunctionModifier)new AliasModifier("geo.length"));
        this.addPushDownFunction("odata", "startswith", "boolean", new String[]{"string", "string"});
        this.addPushDownFunction("odata", "contains", "boolean", new String[]{"string", "string"});
    }

    public void start() throws TranslatorException {
        super.start();
    }

    public void getMetadata(MetadataFactory metadataFactory, WSConnection conn) throws TranslatorException {
        ODataMetadataProcessor metadataProcessor = (ODataMetadataProcessor)this.getMetadataProcessor();
        PropertiesUtils.setBeanProperties((Object)metadataProcessor, (Properties)metadataFactory.getModelProperties(), (String)"importer");
        metadataProcessor.setExecutionfactory(this);
        metadataProcessor.process(metadataFactory, conn);
    }

    public MetadataProcessor<WSConnection> getMetadataProcessor() {
        return new ODataMetadataProcessor();
    }

    protected XMLMetadata getSchema(WSConnection conn) throws TranslatorException {
        if (this.serviceMatadata == null) {
            try {
                BaseQueryExecution execution = new BaseQueryExecution(this, null, null, conn);
                HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
                BinaryWSProcedureExecution call = execution.invokeHTTP("GET", "$metadata", null, headers);
                if (call.getResponseCode() != HttpStatusCode.OK.getStatusCode()) {
                    throw execution.buildError(call);
                }
                Blob out = (Blob)call.getOutputParameterValues().get(0);
                ClientODataDeserializerImpl deserializer = new ClientODataDeserializerImpl(false, ContentType.APPLICATION_XML);
                this.serviceMatadata = deserializer.toMetadata(out.getBinaryStream());
                return this.serviceMatadata;
            }
            catch (SQLException e) {
                throw new TranslatorException((Throwable)e);
            }
            catch (Exception e) {
                throw new TranslatorException((Throwable)e);
            }
        }
        return this.serviceMatadata;
    }

    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, WSConnection connection) throws TranslatorException {
        return new ODataQueryExecution(this, command, executionContext, metadata, connection);
    }

    public ProcedureExecution createProcedureExecution(Call command, ExecutionContext executionContext, RuntimeMetadata metadata, WSConnection connection) throws TranslatorException {
        String nativeQuery = command.getMetadataObject().getProperty("{http://www.teiid.org/ext/relational/2012}native-query", false);
        if (nativeQuery != null) {
            throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17014, new Object[0]));
        }
        return new ODataProcedureExecution(command, this, executionContext, metadata, connection);
    }

    public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, WSConnection connection) throws TranslatorException {
        if (this.supportsUpdates()) {
            return new ODataUpdateExecution(command, this, executionContext, metadata, connection);
        }
        throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17030, new Object[0]));
    }

    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(this.getDefaultSupportedFunctions());
        supportedFunctions.add("endswith");
        supportedFunctions.add("length");
        supportedFunctions.add("locate");
        supportedFunctions.add("substring");
        supportedFunctions.add("lcase");
        supportedFunctions.add("ucase");
        supportedFunctions.add("trim");
        supportedFunctions.add("concat");
        supportedFunctions.add("convert");
        supportedFunctions.add("year");
        supportedFunctions.add("month");
        supportedFunctions.add("now");
        supportedFunctions.add("hour");
        supportedFunctions.add("minute");
        supportedFunctions.add("second");
        supportedFunctions.add("dayofmonth");
        supportedFunctions.add("round");
        supportedFunctions.add("floor");
        supportedFunctions.add("ceiling");
        supportedFunctions.add("mod");
        supportedFunctions.add("st_distance");
        supportedFunctions.add("st_intersects");
        supportedFunctions.add("st_length");
        return supportedFunctions;
    }

    public Map<String, FunctionModifier> getFunctionModifiers() {
        return this.functionModifiers;
    }

    public void registerFunctionModifier(String name, FunctionModifier modifier) {
        this.functionModifiers.put(name, modifier);
    }

    public List<String> getDefaultSupportedFunctions() {
        return Arrays.asList("+", "-", "*", "/");
    }

    @TranslatorProperty(display="Supports $Filter", description="True, $filter is supported", advanced=true)
    public boolean supportsOdataFilter() {
        return this.supportsOdataFilter;
    }

    public void setSupportsOdataFilter(boolean supports) {
        this.supportsOdataFilter = supports;
    }

    @TranslatorProperty(display="Supports $OrderBy", description="True, $orderby is supported", advanced=true)
    public boolean supportsOdataOrderBy() {
        return this.supportsOdataOrderBy;
    }

    public void setSupportsOdataOrderBy(boolean supports) {
        this.supportsOdataOrderBy = supports;
    }

    @TranslatorProperty(display="Supports $count", description="True, $count is supported", advanced=true)
    public boolean supportsOdataCount() {
        return this.supportsOdataCount;
    }

    public void setSupportsOdataCount(boolean supports) {
        this.supportsOdataCount = supports;
    }

    @TranslatorProperty(display="Supports $skip", description="True, $skip is supported", advanced=true)
    public boolean supportsOdataSkip() {
        return this.supportsOdataSkip;
    }

    public void setSupportsOdataSkip(boolean supports) {
        this.supportsOdataSkip = supports;
    }

    @TranslatorProperty(display="Supports $top", description="True, $top is supported", advanced=true)
    public boolean supportsOdataTop() {
        return this.supportsOdataTop;
    }

    public void setSupportsOdataTop(boolean supports) {
        this.supportsOdataTop = supports;
    }

    @TranslatorProperty(display="Supports Updates", description="True, if(PUT,PATCH,DELETE) operations supported", advanced=true)
    public boolean supportsUpdates() {
        return this.supportsUpdates;
    }

    public void setSupportsUpdates(boolean supports) {
        this.supportsUpdates = supports;
    }

    public boolean supportsCompareCriteriaEquals() {
        return this.supportsOdataFilter;
    }

    public boolean supportsCompareCriteriaOrdered() {
        return this.supportsOdataFilter;
    }

    public boolean supportsIsNullCriteria() {
        return this.supportsOdataFilter;
    }

    public boolean supportsOrCriteria() {
        return this.supportsOdataFilter;
    }

    public boolean supportsNotCriteria() {
        return this.supportsOdataFilter;
    }

    public boolean supportsInCriteria() {
        return false;
    }

    public boolean supportsQuantifiedCompareCriteriaSome() {
        return false;
    }

    public boolean supportsQuantifiedCompareCriteriaAll() {
        return false;
    }

    @TranslatorProperty(display="Supports ORDER BY", description="True, if this connector supports ORDER BY", advanced=true)
    public boolean supportsOrderBy() {
        return this.supportsOdataOrderBy;
    }

    public boolean supportsOrderByUnrelated() {
        return this.supportsOdataOrderBy;
    }

    public boolean supportsAggregatesCount() {
        return this.supportsOdataCount;
    }

    public boolean supportsAggregatesCountStar() {
        return this.supportsOdataCount;
    }

    public boolean supportsRowLimit() {
        return this.supportsOdataTop;
    }

    public boolean supportsRowOffset() {
        return this.supportsOdataSkip;
    }

    public boolean supportsOnlyLiteralComparison() {
        return true;
    }

    public boolean useAnsiJoin() {
        return true;
    }

    public boolean supportsArrayType() {
        return true;
    }

    protected String escapeString(String str, String quote) {
        return StringUtil.replaceAll((String)str, (String)quote, (String)(quote + quote));
    }

    public boolean supportsGeographyType() {
        return true;
    }
}

