/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata4;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.client.api.edm.xml.XMLMetadata;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlActionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlBindingTarget;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlFunctionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.provider.CsdlOperation;
import org.apache.olingo.commons.api.edm.provider.CsdlParameter;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlPropertyRef;
import org.apache.olingo.commons.api.edm.provider.CsdlReferentialConstraint;
import org.apache.olingo.commons.api.edm.provider.CsdlReturnType;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlSingleton;
import org.teiid.core.BundleUtil;
import org.teiid.logging.LogManager;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ExtensionMetadataProperty;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.olingo.common.ODataTypeManager;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.odata4.ODataExecutionFactory;
import org.teiid.translator.odata4.ODataPlugin;
import org.teiid.translator.ws.WSConnection;
import org.teiid.util.FullyQualifiedName;

public class ODataMetadataProcessor
implements MetadataProcessor<WSConnection> {
    private static final String EDM_GEOMETRY = "Edm.Geometry";
    private static final String EDM_GEOGRAPHY = "Edm.Geography";
    private static final String NAME_SEPARATOR = "_";
    @ExtensionMetadataProperty(applicable={Table.class, Procedure.class}, datatype=String.class, display="Name in OData Schema", description="Name in OData Schema", required=true)
    public static final String NAME_IN_SCHEMA = "{http://www.jboss.org/teiiddesigner/ext/odata/2012}NameInSchema";
    @ExtensionMetadataProperty(applicable={Table.class, Procedure.class}, datatype=String.class, display="OData Type", description="Type of OData Schema Item", allowed="COMPLEX, NAVIGATION, ENTITY, ENTITY_COLLECTION, ACTION, FUNCTION, COMPLEX_COLLECTION, NAVIGATION_COLLECTION", required=true)
    public static final String ODATA_TYPE = "{http://www.jboss.org/teiiddesigner/ext/odata/2012}Type";
    @ExtensionMetadataProperty(applicable={Column.class}, datatype=String.class, display="Pseudo Column", description="Pseudo column for join purposes")
    public static final String PSEUDO = "{http://www.jboss.org/teiiddesigner/ext/odata/2012}PSEUDO";
    private String schemaNamespace;
    private ODataExecutionFactory ef;

    void setExecutionfactory(ODataExecutionFactory ef) {
        this.ef = ef;
    }

    public void process(MetadataFactory mf, WSConnection conn) throws TranslatorException {
        XMLMetadata serviceMetadata = this.getSchema(conn);
        try {
            this.getMetadata(mf, serviceMetadata);
        }
        catch (NullPointerException e) {
            throw new TranslatorException((Throwable)e, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17034, new Object[0]));
        }
    }

    protected XMLMetadata getSchema(WSConnection conn) throws TranslatorException {
        if (this.ef != null) {
            return this.ef.getSchema(conn);
        }
        return null;
    }

    void getMetadata(MetadataFactory mf, XMLMetadata metadata) throws TranslatorException {
        FullyQualifiedName fqn;
        Table t;
        CsdlSchema csdlSchema = this.getDefaultSchema(metadata);
        CsdlEntityContainer container = csdlSchema.getEntityContainer();
        if (container == null) {
            throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17035, new Object[]{csdlSchema.getNamespace()}));
        }
        for (CsdlEntitySet entitySet : container.getEntitySets()) {
            t = this.addTable(mf, entitySet.getName(), entitySet.getType(), ODataType.ENTITY_COLLECTION, metadata);
            fqn = new FullyQualifiedName("entity container", container.getName() == null ? "default" : container.getName());
            fqn.append("entity set", entitySet.getName());
            t.setProperty("{http://www.teiid.org/ext/relational/2012}fqn", fqn.toString());
        }
        for (CsdlSingleton singleton : container.getSingletons()) {
            t = this.addTable(mf, singleton.getName(), singleton.getType(), ODataType.ENTITY_COLLECTION, metadata);
            fqn = new FullyQualifiedName("entity container", container.getName() == null ? "default" : container.getName());
            fqn.append("singleton", singleton.getName());
            t.setProperty("{http://www.teiid.org/ext/relational/2012}fqn", fqn.toString());
        }
        for (CsdlEntitySet entitySet : container.getEntitySets()) {
            this.addNavigationProperties(mf, entitySet.getName(), (CsdlBindingTarget)entitySet, metadata, container);
        }
        for (CsdlSingleton singleton : container.getSingletons()) {
            this.addNavigationProperties(mf, singleton.getName(), (CsdlBindingTarget)singleton, metadata, container);
        }
        for (CsdlFunctionImport function : container.getFunctionImports()) {
            this.addFunctionImportAsProcedure(mf, function, ODataType.FUNCTION, metadata);
        }
        for (CsdlActionImport action : container.getActionImports()) {
            this.addActionImportAsProcedure(mf, action, ODataType.ACTION, metadata);
        }
    }

    private CsdlSchema getDefaultSchema(XMLMetadata metadata) throws TranslatorException {
        CsdlSchema csdlSchema = null;
        if (this.schemaNamespace != null) {
            csdlSchema = metadata.getSchema(this.schemaNamespace);
        } else if (!metadata.getSchemas().isEmpty()) {
            csdlSchema = (CsdlSchema)metadata.getSchemas().get(0);
        }
        if (csdlSchema == null) {
            throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17019, new Object[0]));
        }
        return csdlSchema;
    }

    private Table buildTable(MetadataFactory mf, String name) {
        Table table = mf.addTable(name);
        table.setSupportsUpdate(true);
        return table;
    }

    private boolean isSimple(String type) {
        return type.startsWith("Edm");
    }

    private boolean isEnum(XMLMetadata metadata, String type) throws TranslatorException {
        return this.getEnumType(metadata, type) != null;
    }

    private boolean isComplexType(XMLMetadata metadata, String type) throws TranslatorException {
        return this.getComplexType(metadata, type) != null;
    }

    private boolean isEntityType(XMLMetadata metadata, String type) throws TranslatorException {
        return this.getEntityType(metadata, type) != null;
    }

    private Table addTable(MetadataFactory mf, String tableName, String entityType, ODataType odataType, XMLMetadata metadata) throws TranslatorException {
        Table table = this.buildTable(mf, tableName);
        table.setProperty(ODATA_TYPE, odataType.name());
        table.setProperty(NAME_IN_SCHEMA, entityType);
        CsdlEntityType type = this.getEntityType(metadata, entityType);
        this.addEntityTypeProperties(mf, metadata, table, type);
        return table;
    }

    private void addEntityTypeProperties(MetadataFactory mf, XMLMetadata metadata, Table table, CsdlEntityType entityType) throws TranslatorException {
        ArrayList<CsdlProperty> complexTypes = new ArrayList<CsdlProperty>();
        for (CsdlProperty property : entityType.getProperties()) {
            if (this.addProperty(mf, metadata, table, property)) continue;
            complexTypes.add(property);
        }
        String baseType = entityType.getBaseType();
        while (baseType != null) {
            CsdlEntityType baseEntityType = this.getEntityType(metadata, baseType);
            for (CsdlProperty property : baseEntityType.getProperties()) {
                if (this.addProperty(mf, metadata, table, property)) continue;
                complexTypes.add(property);
            }
            baseType = baseEntityType.getBaseType();
        }
        this.addPrimaryKey(mf, metadata, table, entityType);
        for (CsdlProperty property : complexTypes) {
            this.addComplexPropertyAsTable(mf, property, this.getComplexType(metadata, property.getType()), metadata, table);
        }
    }

    private boolean addProperty(MetadataFactory mf, XMLMetadata metadata, Table table, CsdlProperty property) throws TranslatorException {
        if (this.isSimple(property.getType()) || this.isEnum(metadata, property.getType())) {
            if (table.getColumnByName(property.getName()) == null) {
                this.addPropertyAsColumn(mf, table, property);
            }
            return true;
        }
        return false;
    }

    static boolean isPseudo(Column column) {
        return Boolean.parseBoolean(column.getProperty(PSEUDO, false));
    }

    static boolean isComplexType(Table table) {
        ODataType type = ODataType.valueOf(table.getProperty(ODATA_TYPE, false));
        return type == ODataType.COMPLEX || type == ODataType.COMPLEX_COLLECTION;
    }

    static boolean isNavigationType(Table table) {
        ODataType type = ODataType.valueOf(table.getProperty(ODATA_TYPE, false));
        return type == ODataType.NAVIGATION || type == ODataType.NAVIGATION_COLLECTION;
    }

    static boolean isCollection(Table table) {
        ODataType type = ODataType.valueOf(table.getProperty(ODATA_TYPE, false));
        return type == ODataType.ENTITY_COLLECTION || type == ODataType.COMPLEX_COLLECTION || type == ODataType.NAVIGATION_COLLECTION;
    }

    static boolean isEntitySet(Table table) {
        ODataType type = ODataType.valueOf(table.getProperty(ODATA_TYPE, false));
        return type == ODataType.ENTITY_COLLECTION;
    }

    static String getNativeType(Column column) {
        String nativeType = column.getNativeType();
        if (nativeType == null) {
            nativeType = "Edm.String";
        }
        return nativeType;
    }

    private void addComplexPropertyAsTable(MetadataFactory mf, CsdlProperty parentProperty, CsdlComplexType complexType, XMLMetadata metadata, Table parentTable) throws TranslatorException {
        String tableName = parentTable.getName() + NAME_SEPARATOR + parentProperty.getName();
        Table childTable = this.buildTable(mf, tableName);
        String parent = parentTable.getProperty("{http://www.teiid.org/ext/relational/2012}fqn", false);
        childTable.setProperty("{http://www.teiid.org/ext/relational/2012}fqn", parent + "/" + new FullyQualifiedName("complex property", parentProperty.getName()).toString());
        childTable.setProperty(NAME_IN_SCHEMA, parentProperty.getType());
        childTable.setProperty(ODATA_TYPE, parentProperty.isCollection() ? ODataType.COMPLEX_COLLECTION.name() : ODataType.COMPLEX.name());
        KeyRecord pk = parentTable.getPrimaryKey();
        ArrayList<Column> pkColumns = new ArrayList<Column>();
        for (Object c : pk.getColumns()) {
            String colName = parentTable.getName() + NAME_SEPARATOR + c.getName();
            if (ODataMetadataProcessor.isComplexType(parentTable)) {
                colName = c.getName();
            }
            Column col = this.addColumn(mf, childTable, (Column)c, colName);
            pkColumns.add(col);
            col.setProperty(PSEUDO, String.valueOf(Boolean.TRUE));
        }
        mf.addPrimaryKey("PK0", this.getColumnNames(pkColumns), childTable);
        mf.addForeignKey("FK0", this.getColumnNames(pkColumns), this.getColumnNames(pk.getColumns()), parentTable.getFullName(), childTable);
        if (ODataMetadataProcessor.isComplexType(parentTable)) {
            childTable.setNameInSource(parentTable.getNameInSource() + "/" + parentProperty.getName());
        } else {
            childTable.setNameInSource(parentProperty.getName());
        }
        ArrayList<CsdlProperty> complexTypes = new ArrayList<CsdlProperty>();
        for (CsdlProperty property : complexType.getProperties()) {
            if (this.addProperty(mf, metadata, childTable, property)) continue;
            complexTypes.add(property);
        }
        String baseType = complexType.getBaseType();
        while (baseType != null) {
            CsdlComplexType baseComplexType = this.getComplexType(metadata, baseType);
            for (CsdlProperty property : baseComplexType.getProperties()) {
                if (this.addProperty(mf, metadata, childTable, property)) continue;
                complexTypes.add(property);
            }
            baseType = baseComplexType.getBaseType();
        }
        for (CsdlProperty property : complexTypes) {
            this.addComplexPropertyAsTable(mf, property, this.getComplexType(metadata, property.getType()), metadata, childTable);
        }
    }

    void addPrimaryKey(MetadataFactory mf, XMLMetadata metadata, Table table, CsdlEntityType entityType) throws TranslatorException {
        List keys = entityType.getKey();
        ArrayList<String> pkNames = new ArrayList<String>();
        for (CsdlPropertyRef ref : keys) {
            if (!this.addProperty(mf, metadata, table, entityType.getProperty(ref.getName()))) {
                throw new AssertionError((Object)"Complex type not allowed as part of primary key");
            }
            pkNames.add(ref.getName());
            if (ref.getAlias() == null) continue;
            throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17018, new Object[]{table.getName(), ref.getName()}));
        }
        mf.addPrimaryKey("PK", pkNames, table);
    }

    private CsdlNavigationPropertyBinding getNavigationPropertyBinding(CsdlBindingTarget entitySet, String name) {
        List bindings = entitySet.getNavigationPropertyBindings();
        for (CsdlNavigationPropertyBinding binding : bindings) {
            String path = binding.getPath();
            int index = path.lastIndexOf(47);
            if (index != -1) {
                path = path.substring(index + 1);
            }
            if (!path.equals(name)) continue;
            return binding;
        }
        return null;
    }

    private CsdlEntityType getEntityType(XMLMetadata metadata, String name) throws TranslatorException {
        if (name == null) {
            return null;
        }
        if (name.startsWith("Collection")) {
            int start = name.indexOf(40);
            int end = name.indexOf(41);
            name = name.substring(start + 1, end).trim();
        }
        if (name.contains(".")) {
            int idx = name.lastIndexOf(46);
            String schemaName = name.substring(0, idx);
            CsdlSchema schema = metadata.getSchema(schemaName);
            if (schema == null) {
                throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17021, new Object[]{schemaName}));
            }
            return schema.getEntityType(name.substring(idx + 1));
        }
        return this.getDefaultSchema(metadata).getEntityType(name);
    }

    private List<CsdlFunction> getFunctions(XMLMetadata metadata, String name) throws TranslatorException {
        if (name.contains(".")) {
            int idx = name.lastIndexOf(46);
            CsdlSchema schema = metadata.getSchema(name.substring(0, idx));
            if (schema == null) {
                throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17021, new Object[]{name}));
            }
            return schema.getFunctions(name.substring(idx + 1));
        }
        return this.getDefaultSchema(metadata).getFunctions(name);
    }

    private List<CsdlAction> getActions(XMLMetadata metadata, String name) throws TranslatorException {
        if (name.contains(".")) {
            int idx = name.lastIndexOf(46);
            CsdlSchema schema = metadata.getSchema(name.substring(0, idx));
            if (schema == null) {
                throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17021, new Object[]{name}));
            }
            return schema.getActions(name.substring(idx + 1));
        }
        return this.getDefaultSchema(metadata).getActions(name);
    }

    private CsdlComplexType getComplexType(XMLMetadata metadata, String name) throws TranslatorException {
        if (name.contains(".")) {
            int idx = name.lastIndexOf(46);
            CsdlSchema schema = metadata.getSchema(name.substring(0, idx));
            if (schema == null) {
                throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17021, new Object[]{name}));
            }
            return schema.getComplexType(name.substring(idx + 1));
        }
        return this.getDefaultSchema(metadata).getComplexType(name);
    }

    private CsdlEnumType getEnumType(XMLMetadata metadata, String name) throws TranslatorException {
        if (name.contains(".")) {
            int idx = name.lastIndexOf(46);
            CsdlSchema schema = metadata.getSchema(name.substring(0, idx));
            if (schema == null) {
                throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17021, new Object[]{name}));
            }
            return schema.getEnumType(name.substring(idx + 1));
        }
        return this.getDefaultSchema(metadata).getEnumType(name);
    }

    void addNavigationProperties(MetadataFactory mf, String tableName, CsdlBindingTarget entitySet, XMLMetadata metadata, CsdlEntityContainer container) throws TranslatorException {
        Table fromTable = mf.getSchema().getTable(tableName);
        CsdlEntityType fromEntityType = this.getEntityType(metadata, entitySet.getType());
        for (CsdlNavigationProperty property : fromEntityType.getNavigationProperties()) {
            String parent;
            CsdlNavigationPropertyBinding binding = this.getNavigationPropertyBinding(entitySet, property.getName());
            Table toTable = null;
            if (binding != null) {
                String target = binding.getTarget();
                int index = target.lastIndexOf(47);
                if (index != -1) {
                    target = target.substring(index + 1);
                }
                toTable = mf.getSchema().getTable(target);
                if (index != -1) {
                    toTable.setNameInSource(binding.getTarget());
                }
            } else {
                if (!property.isContainsTarget()) continue;
                toTable = this.addNavigationAsTable(mf, metadata, fromTable, property);
                parent = fromTable.getProperty("{http://www.teiid.org/ext/relational/2012}fqn", false);
                toTable.setProperty("{http://www.teiid.org/ext/relational/2012}fqn", parent + "/" + new FullyQualifiedName("contained", property.getName()).toString());
            }
            if (this.same(fromTable, toTable)) {
                toTable = this.addNavigationAsTable(mf, metadata, fromTable, property);
                parent = fromTable.getProperty("{http://www.teiid.org/ext/relational/2012}fqn", false);
                toTable.setProperty("{http://www.teiid.org/ext/relational/2012}fqn", parent + "/" + new FullyQualifiedName().append("self join", property.getName()).toString());
            }
            ArrayList<String> columnNames = new ArrayList<String>();
            ArrayList<String> referenceColumnNames = new ArrayList<String>();
            if (property.getReferentialConstraints().isEmpty()) {
                if (ODataMetadataProcessor.isNavigationType(toTable) || this.hasReverseNavigation(mf, metadata, container, fromTable, property, binding, toTable)) continue;
                if (property.isCollection()) {
                    this.addImplicitFk(mf, fromTable, property, toTable, columnNames, referenceColumnNames);
                    continue;
                }
                this.addImplicitFk(mf, toTable, property, fromTable, columnNames, referenceColumnNames);
                continue;
            }
            if (property.isCollection()) continue;
            for (CsdlReferentialConstraint constraint : property.getReferentialConstraints()) {
                columnNames.add(constraint.getProperty());
                referenceColumnNames.add(constraint.getReferencedProperty());
            }
            mf.addForeignKey(ODataMetadataProcessor.join(fromTable.getName(), NAME_SEPARATOR, property.getName()), columnNames, referenceColumnNames, toTable.getFullName(), fromTable);
        }
    }

    private void addImplicitFk(MetadataFactory mf, Table fromTable, CsdlNavigationProperty property, Table toTable, List<String> columnNames, List<String> referenceColumnNames) {
        KeyRecord pk = this.getPKorUnique(fromTable);
        if (pk != null) {
            boolean matches = true;
            for (Column c : pk.getColumns()) {
                referenceColumnNames.add(c.getName());
                if (toTable.getColumnByName(c.getName()) != null) {
                    columnNames.add(c.getName());
                    continue;
                }
                matches = false;
                break;
            }
            if (matches) {
                mf.addForeignKey(ODataMetadataProcessor.join(fromTable.getName(), NAME_SEPARATOR, property.getName()), columnNames, referenceColumnNames, fromTable.getFullName(), toTable);
            }
        }
    }

    private boolean hasReverseNavigation(MetadataFactory mf, XMLMetadata metadata, CsdlEntityContainer container, Table fromTable, CsdlNavigationProperty property, CsdlNavigationPropertyBinding binding, Table toTable) throws TranslatorException, AssertionError {
        if (!property.isCollection() || binding == null) {
            return false;
        }
        CsdlEntityType toEntityType = this.getEntityType(metadata, toTable.getProperty(NAME_IN_SCHEMA, false));
        for (CsdlNavigationProperty toProperty : toEntityType.getNavigationProperties()) {
            Table reverseTable;
            CsdlNavigationPropertyBinding toBinding;
            CsdlEntitySet toEntitySet;
            if (toProperty.isCollection() || toProperty.isContainsTarget() || (toEntitySet = container.getEntitySet(binding.getTarget())) == null || (toBinding = this.getNavigationPropertyBinding((CsdlBindingTarget)toEntitySet, toProperty.getName())) == null) continue;
            String toTarget = toBinding.getTarget();
            int index = toTarget.lastIndexOf(47);
            if (index != -1) {
                toTarget = toTarget.substring(index + 1);
            }
            if (!this.same(fromTable, reverseTable = mf.getSchema().getTable(toTarget))) continue;
            return true;
        }
        return false;
    }

    private Table addNavigationAsTable(MetadataFactory mf, XMLMetadata metadata, Table fromTable, CsdlNavigationProperty property) throws TranslatorException {
        String name = ODataMetadataProcessor.join(fromTable.getName(), NAME_SEPARATOR, property.getName());
        Table toTable = this.addTable(mf, name, property.getType(), property.isCollection() ? ODataType.NAVIGATION_COLLECTION : ODataType.NAVIGATION, metadata);
        toTable.setNameInSource(property.getName());
        KeyRecord pk = fromTable.getPrimaryKey();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Column c : pk.getColumns()) {
            String columnName = ODataMetadataProcessor.join(fromTable.getName(), NAME_SEPARATOR, c.getName());
            Column column = mf.addColumn(columnName, c.getRuntimeType(), (ColumnSet)toTable);
            column.setProperty(PSEUDO, String.valueOf(Boolean.TRUE));
            columnNames.add(columnName);
        }
        mf.addForeignKey("FK0", columnNames, this.getColumnNames(pk.getColumns()), fromTable.getFullName(), toTable);
        return toTable;
    }

    static String join(String ... records) {
        StringBuffer sb = new StringBuffer();
        for (String r : records) {
            sb.append(r);
        }
        return sb.toString();
    }

    boolean same(Table x, Table y) {
        return x.getFullName().equalsIgnoreCase(y.getFullName());
    }

    private Column addPropertyAsColumn(MetadataFactory mf, Table table, CsdlProperty property) {
        Column c = this.buildColumn(mf, table, property);
        c.setNullType(property.isNullable() ? BaseColumn.NullType.Nullable : BaseColumn.NullType.No_Nulls);
        if (property.getMaxLength() != null) {
            c.setLength(property.getMaxLength().intValue());
        }
        if (property.getPrecision() != null) {
            c.setPrecision(property.getPrecision().intValue());
        }
        if (property.getScale() != null) {
            c.setScale(property.getScale().intValue());
        }
        if (property.getDefaultValue() != null) {
            c.setDefaultValue(property.getDefaultValue());
        }
        if (property.getMimeType() != null) {
            c.setProperty("MIME-TYPE", property.getMimeType());
        }
        if (!property.getType().equals("Edm.String")) {
            if (property.isCollection()) {
                c.setNativeType("Collection(" + property.getType() + ")");
            } else {
                c.setNativeType(property.getType());
            }
        }
        if (property.getType().equals("Edm.String") && property.isCollection()) {
            c.setNativeType("Collection(" + property.getType() + ")");
        }
        return c;
    }

    private Column addColumn(MetadataFactory mf, Table table, Column property, String newName) {
        Column c = mf.addColumn(newName, property.getRuntimeType(), (ColumnSet)table);
        c.setUpdatable(true);
        c.setNullType(property.getNullType());
        c.setLength(property.getLength());
        c.setPrecision(property.getPrecision());
        c.setScale(property.getScale());
        c.setDefaultValue(property.getDefaultValue());
        c.setProperty("MIME-TYPE", c.getProperty("MIME-TYPE", false));
        c.setProperty("{http://www.teiid.org/translator/spatial/2015}srid", property.getProperty("{http://www.teiid.org/translator/spatial/2015}srid", false));
        c.setProperty("NATIVE_TYPE", property.getProperty("NATIVE_TYPE", false));
        return c;
    }

    private ProcedureParameter addParameterAsColumn(MetadataFactory mf, Procedure procedure, CsdlParameter parameter) {
        ProcedureParameter p = mf.addProcedureParameter(parameter.getName(), ODataTypeManager.teiidType((String)parameter.getType(), (boolean)parameter.isCollection()), ProcedureParameter.Type.In, procedure);
        p.setNullType(parameter.isNullable() ? BaseColumn.NullType.Nullable : BaseColumn.NullType.No_Nulls);
        if (parameter.getMaxLength() != null) {
            p.setLength(parameter.getMaxLength().intValue());
        }
        if (parameter.getPrecision() != null) {
            p.setPrecision(parameter.getPrecision().intValue());
        }
        if (parameter.getScale() != null) {
            p.setScale(parameter.getScale().intValue());
        }
        this.handleGeometryTypes(parameter.getSrid(), parameter.getType(), (BaseColumn)p);
        return p;
    }

    private Column buildColumn(MetadataFactory mf, Table table, CsdlProperty property) {
        String columnName = property.getName();
        Column c = mf.addColumn(columnName, ODataTypeManager.teiidType((String)property.getType(), (boolean)property.isCollection()), (ColumnSet)table);
        this.handleGeometryTypes(property.getSrid(), property.getType(), (BaseColumn)c);
        if (property.isCollection()) {
            c.setSearchType(Column.SearchType.Unsearchable);
        }
        c.setUpdatable(true);
        return c;
    }

    private void handleGeometryTypes(SRID srid, String type, BaseColumn c) {
        String value;
        if (!"geometry".equals(c.getDatatype().getName())) {
            return;
        }
        if (type.startsWith(EDM_GEOMETRY)) {
            if (type.length() > EDM_GEOMETRY.length()) {
                c.setProperty("{http://www.teiid.org/translator/spatial/2015}type", type.substring(EDM_GEOMETRY.length()).toUpperCase());
            } else {
                c.setProperty("{http://www.teiid.org/translator/spatial/2015}type", "GEOMETRY");
            }
        } else if (type.startsWith(EDM_GEOGRAPHY)) {
            c.setProperty("{http://www.teiid.org/translator/spatial/2015}srid", "4326");
            if (type.length() > EDM_GEOGRAPHY.length()) {
                c.setProperty("{http://www.teiid.org/translator/spatial/2015}type", type.substring(EDM_GEOGRAPHY.length()).toUpperCase());
            } else {
                c.setProperty("{http://www.teiid.org/translator/spatial/2015}type", "GEOMETRY");
            }
        }
        if (srid != null && srid.isNotDefault() && !(value = srid.toString()).equalsIgnoreCase("VARIABLE")) {
            c.setProperty("{http://www.teiid.org/translator/spatial/2015}srid", value);
        }
    }

    private void addParameter(MetadataFactory mf, XMLMetadata metadata, Procedure procedure, CsdlParameter parameter) throws TranslatorException {
        if (!this.isSimple(parameter.getType())) {
            throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17022, new Object[]{parameter.getName()}));
        }
        this.addParameterAsColumn(mf, procedure, parameter);
    }

    void addFunctionImportAsProcedure(MetadataFactory mf, CsdlFunctionImport functionImport, ODataType odataType, XMLMetadata metadata) throws TranslatorException {
        List<CsdlFunction> functions = this.getFunctions(metadata, functionImport.getFunction());
        for (CsdlFunction function : functions) {
            Procedure procedure = mf.addProcedure(function.getName());
            this.addOperation(mf, metadata, odataType, (CsdlOperation)function, procedure);
        }
    }

    private void addProcedureTableReturn(MetadataFactory mf, XMLMetadata metadata, Procedure procedure, CsdlComplexType type, String namePrefix) throws TranslatorException {
        for (CsdlProperty property : type.getProperties()) {
            if (this.isSimple(property.getType()) || this.isEnum(metadata, property.getType())) {
                mf.addProcedureResultSetColumn(namePrefix == null ? property.getName() : namePrefix + NAME_SEPARATOR + property.getName(), ODataTypeManager.teiidType((String)property.getType(), (boolean)property.isCollection()), procedure);
                continue;
            }
            if (this.isComplexType(metadata, property.getType())) {
                CsdlComplexType childType = this.getComplexType(metadata, property.getType());
                this.addProcedureTableReturn(mf, metadata, procedure, childType, property.getName());
                continue;
            }
            throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17023, new Object[]{procedure.getName()}));
        }
    }

    private void addProcedureTableReturn(MetadataFactory mf, XMLMetadata metadata, Procedure procedure, CsdlEntityType type, String namePrefix) throws TranslatorException {
        for (CsdlProperty property : type.getProperties()) {
            if (this.isSimple(property.getType()) || this.isEnum(metadata, property.getType())) {
                mf.addProcedureResultSetColumn(namePrefix == null ? property.getName() : namePrefix + NAME_SEPARATOR + property.getName(), ODataTypeManager.teiidType((String)property.getType(), (boolean)property.isCollection()), procedure);
                continue;
            }
            if (this.isComplexType(metadata, property.getType())) {
                CsdlComplexType childType = this.getComplexType(metadata, property.getType());
                this.addProcedureTableReturn(mf, metadata, procedure, childType, property.getName());
                continue;
            }
            throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17023, new Object[]{procedure.getName()}));
        }
    }

    private void addActionImportAsProcedure(MetadataFactory mf, CsdlActionImport actionImport, ODataType odataType, XMLMetadata metadata) throws TranslatorException {
        List<CsdlAction> actions = this.getActions(metadata, actionImport.getAction());
        for (CsdlAction action : actions) {
            if (!this.hasComplexParameters(action.getParameters())) {
                Procedure procedure = mf.addProcedure(action.getName());
                this.addOperation(mf, metadata, odataType, (CsdlOperation)action, procedure);
                continue;
            }
            LogManager.logInfo((String)"org.teiid.ODATA", (Object)ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17033, new Object[]{action.getName()}));
        }
    }

    private boolean hasComplexParameters(List<CsdlParameter> parameters) {
        for (CsdlParameter parameter : parameters) {
            if (this.isSimple(parameter.getType())) continue;
            return false;
        }
        return false;
    }

    private void addOperation(MetadataFactory mf, XMLMetadata metadata, ODataType odataType, CsdlOperation function, Procedure procedure) throws TranslatorException {
        procedure.setProperty(ODATA_TYPE, odataType.name());
        for (CsdlParameter parameter : function.getParameters()) {
            this.addParameter(mf, metadata, procedure, parameter);
        }
        CsdlReturnType returnType = function.getReturnType();
        if (returnType != null) {
            if (this.isSimple(returnType.getType())) {
                mf.addProcedureParameter("return", ODataTypeManager.teiidType((String)returnType.getType(), (boolean)returnType.isCollection()), ProcedureParameter.Type.ReturnValue, procedure);
            } else if (this.isComplexType(metadata, returnType.getType())) {
                this.addProcedureTableReturn(mf, metadata, procedure, this.getComplexType(metadata, returnType.getType()), null);
                procedure.getResultSet().setProperty(ODATA_TYPE, returnType.isCollection() ? ODataType.COMPLEX_COLLECTION.name() : ODataType.COMPLEX.name());
            } else if (this.isEntityType(metadata, returnType.getType())) {
                this.addProcedureTableReturn(mf, metadata, procedure, this.getEntityType(metadata, returnType.getType()), null);
                procedure.getResultSet().setProperty(ODATA_TYPE, returnType.isCollection() ? ODataType.ENTITY_COLLECTION.name() : ODataType.ENTITY.name());
            } else {
                throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17005, new Object[]{function.getName(), returnType.getType()}));
            }
        }
    }

    public void setSchemaNamespace(String namespace) {
        this.schemaNamespace = namespace;
    }

    List<String> getColumnNames(List<Column> columns) {
        ArrayList<String> names = new ArrayList<String>();
        for (Column c : columns) {
            names.add(c.getName());
        }
        return names;
    }

    KeyRecord getPKorUnique(Table table) {
        KeyRecord pk = table.getPrimaryKey();
        if (pk == null && !table.getUniqueKeys().isEmpty()) {
            pk = (KeyRecord)table.getUniqueKeys().get(0);
        }
        return pk;
    }

    static Table getComplexTableParentTable(RuntimeMetadata metadata, Table table) throws TranslatorException {
        for (Column c : table.getColumns()) {
            if (!ODataMetadataProcessor.isPseudo(c)) continue;
            ForeignKey fk = (ForeignKey)table.getForeignKeys().get(0);
            String tableName = fk.getReferenceTableName();
            if (tableName.indexOf(46) == -1) {
                tableName = ((Table)fk.getReferenceKey().getParent()).getFullName();
            }
            return metadata.getTable(tableName);
        }
        return table;
    }

    static Column normalizePseudoColumn(RuntimeMetadata metadata, Column column) throws TranslatorException {
        if (ODataMetadataProcessor.isPseudo(column)) {
            Table table = (Table)column.getParent();
            ForeignKey fk = (ForeignKey)table.getForeignKeys().get(0);
            for (int i = 0; i < fk.getColumns().size(); ++i) {
                Column c = (Column)fk.getColumns().get(i);
                if (!c.getName().equals(column.getName())) continue;
                String refColumn = (String)fk.getReferenceColumns().get(i);
                String tableName = fk.getReferenceTableName();
                if (tableName.indexOf(46) == -1) {
                    tableName = ((Table)fk.getReferenceKey().getParent()).getFullName();
                }
                Table refTable = metadata.getTable(tableName);
                return refTable.getColumnByName(refColumn);
            }
        }
        return column;
    }

    @TranslatorProperty(display="Schema Namespace", category=TranslatorProperty.PropertyType.IMPORT, description="Namespace of the schema to import")
    public String getSchemaNamespace() {
        return this.schemaNamespace;
    }

    public static enum ODataType {
        COMPLEX,
        NAVIGATION,
        ENTITY,
        ENTITY_COLLECTION,
        ACTION,
        FUNCTION,
        COMPLEX_COLLECTION,
        NAVIGATION_COLLECTION;

    }
}

