/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata4;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.Join;
import org.teiid.language.LanguageUtil;
import org.teiid.metadata.Column;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.document.DocumentNode;
import org.teiid.translator.odata4.ODataDocumentNode;
import org.teiid.translator.odata4.ODataExecutionFactory;
import org.teiid.translator.odata4.ODataFilterVisitor;
import org.teiid.translator.odata4.ODataMetadataProcessor;
import org.teiid.translator.odata4.ODataPlugin;

public class ODataQuery {
    protected ODataExecutionFactory executionFactory;
    protected RuntimeMetadata metadata;
    protected ODataDocumentNode rootDocument;
    protected DocumentNode joinNode;
    protected ArrayList<ODataDocumentNode> complexTables = new ArrayList();
    protected ArrayList<ODataDocumentNode> expandTables = new ArrayList();

    public ODataQuery(ODataExecutionFactory executionFactory, RuntimeMetadata metadata) {
        this.executionFactory = executionFactory;
        this.metadata = metadata;
    }

    public void addRootDocument(Table table) throws TranslatorException {
        ODataDocumentNode node = null;
        if (this.rootDocument == null) {
            if (ODataMetadataProcessor.isEntitySet(table)) {
                this.rootDocument = node = new ODataDocumentNode(table, ODataDocumentNode.ODataDocumentType.PRIMARY, ODataMetadataProcessor.isCollection(table));
                this.joinNode = node;
            } else {
                Table parentTable = ODataMetadataProcessor.getComplexTableParentTable(this.metadata, table);
                if (parentTable == null) {
                    throw new TranslatorException((BundleUtil.Event)ODataPlugin.Event.TEIID17028, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17028, new Object[]{table.getName()}));
                }
                this.addRootDocument(parentTable);
                if (ODataMetadataProcessor.isComplexType(table) || ODataMetadataProcessor.isNavigationType(table)) {
                    this.joinChildDocument(table, Join.JoinType.INNER_JOIN);
                }
            }
        } else {
            this.joinChildDocument(table, Join.JoinType.INNER_JOIN);
        }
    }

    private ODataDocumentNode addComplexOrNavigation(Table table) {
        ODataDocumentNode node;
        if (ODataMetadataProcessor.isComplexType(table)) {
            node = new ODataDocumentNode(table, ODataDocumentNode.ODataDocumentType.COMPLEX, ODataMetadataProcessor.isCollection(table));
            this.complexTables.add(node);
        } else if (ODataMetadataProcessor.isNavigationType(table)) {
            node = new ODataDocumentNode(table, ODataDocumentNode.ODataDocumentType.EXPAND, ODataMetadataProcessor.isCollection(table));
            this.expandTables.add(node);
        } else {
            node = new ODataDocumentNode(table, ODataDocumentNode.ODataDocumentType.EXPAND, ODataMetadataProcessor.isCollection(table));
            this.expandTables.add(node);
        }
        return node;
    }

    private void joinChildDocument(Table table, Join.JoinType joinType) throws TranslatorException {
        ODataDocumentNode node = this.addComplexOrNavigation(table);
        this.joinNode = this.joinNode.joinWith(joinType, (DocumentNode)node);
    }

    public Condition addNavigation(Condition obj, Join.JoinType joinType, Table right) throws TranslatorException {
        this.joinChildDocument(right, joinType);
        return this.parseKeySegmentFromCondition(obj);
    }

    public Condition addNavigation(Condition obj, Join.JoinType joinType, Table left, Table right) throws TranslatorException {
        this.addRootDocument(left);
        this.joinChildDocument(right, joinType);
        return this.parseKeySegmentFromCondition(obj);
    }

    public DocumentNode getRootDocument() {
        return this.rootDocument;
    }

    protected String processFilter(Condition condition) throws TranslatorException {
        List crits = LanguageUtil.separateCriteriaByAnd((Condition)condition);
        if (!crits.isEmpty()) {
            for (Condition crit : crits) {
                ODataFilterVisitor visitor = new ODataFilterVisitor(this.executionFactory, this.metadata, this);
                visitor.appendFilter(crit);
            }
        }
        StringBuilder sb = new StringBuilder();
        if (this.rootDocument.getFilter() != null) {
            sb.append(this.rootDocument.getFilter());
        }
        for (ODataDocumentNode use : this.complexTables) {
            if (use.getFilter() == null) continue;
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append(use.getFilter());
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    protected Condition parseKeySegmentFromCondition(Condition obj) throws TranslatorException {
        List crits = LanguageUtil.separateCriteriaByAnd((Condition)obj);
        if (!crits.isEmpty()) {
            boolean modified = false;
            Iterator iter = crits.iterator();
            while (iter.hasNext()) {
                Comparison left;
                boolean leftAdded;
                Condition crit = (Condition)iter.next();
                if (!(crit instanceof Comparison) || !(leftAdded = this.parseKeySegmentFromComparison(left = (Comparison)crit))) continue;
                iter.remove();
                modified = true;
            }
            if (modified) {
                return LanguageUtil.combineCriteria((List)crits);
            }
        }
        return obj;
    }

    private boolean parseKeySegmentFromComparison(Comparison obj) throws TranslatorException {
        if (obj.getOperator().equals((Object)Comparison.Operator.EQ) && obj.getLeftExpression() instanceof ColumnReference && obj.getRightExpression() instanceof ColumnReference) {
            Column left = ((ColumnReference)obj.getLeftExpression()).getMetadataObject();
            Column right = ((ColumnReference)obj.getRightExpression()).getMetadataObject();
            if (this.isJoinOrPkColumn(left) && this.isJoinOrPkColumn(right)) {
                return true;
            }
        }
        return false;
    }

    ODataDocumentNode getSchemaElement(Table table) {
        if (this.rootDocument != null && this.rootDocument.getTable().equals((Object)table)) {
            return this.rootDocument;
        }
        for (ODataDocumentNode schemaElement : this.complexTables) {
            if (!schemaElement.getTable().equals((Object)table)) continue;
            return schemaElement;
        }
        for (ODataDocumentNode schemaElement : this.expandTables) {
            if (!schemaElement.getTable().equals((Object)table)) continue;
            return schemaElement;
        }
        return null;
    }

    private boolean isJoinOrPkColumn(Column column) {
        boolean isKey;
        Table table = (Table)column.getParent();
        boolean bl = isKey = table.getPrimaryKey().getColumnByName(column.getName()) != null;
        if (!isKey) {
            for (ForeignKey fk : table.getForeignKeys()) {
                if (fk.getColumnByName(column.getName()) == null) continue;
                isKey = true;
            }
        }
        return isKey;
    }
}

