/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata4;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.language.AggregateFunction;
import org.teiid.language.DerivedColumn;
import org.teiid.language.LanguageObject;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.odata4.BaseQueryExecution;
import org.teiid.translator.odata4.ODataExecutionFactory;
import org.teiid.translator.odata4.ODataMetadataProcessor;
import org.teiid.translator.odata4.ODataResponse;
import org.teiid.translator.odata4.ODataSQLVisitor;
import org.teiid.translator.ws.BinaryWSProcedureExecution;
import org.teiid.translator.ws.WSConnection;

public class ODataQueryExecution
extends BaseQueryExecution
implements ResultSetExecution {
    private ODataSQLVisitor visitor;
    private int countResponse = -1;
    private Class<?>[] expectedColumnTypes;
    private ODataResponse response;
    private boolean isCount;

    public ODataQueryExecution(ODataExecutionFactory translator, QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, WSConnection connection) throws TranslatorException {
        super(translator, executionContext, metadata, connection);
        Select select;
        this.visitor = new ODataSQLVisitor(this.translator, metadata);
        this.visitor.visitNode((LanguageObject)command);
        if (command instanceof Select && (select = (Select)command).getGroupBy() == null && ((DerivedColumn)select.getDerivedColumns().get(0)).getExpression() instanceof AggregateFunction) {
            this.isCount = true;
        }
        if (!this.visitor.exceptions.isEmpty()) {
            throw this.visitor.exceptions.get(0);
        }
        this.expectedColumnTypes = command.getColumnTypes();
    }

    public void execute() throws TranslatorException {
        final String URI2 = this.visitor.buildURL("");
        if (this.isCount) {
            TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>();
            headers.put("Accept", Arrays.asList("text/plain"));
            BinaryWSProcedureExecution execution = this.invokeHTTP("GET", URI2, null, headers);
            if (execution.getResponseCode() != HttpStatusCode.OK.getStatusCode()) {
                throw this.buildError(execution);
            }
            Blob blob = (Blob)execution.getOutputParameterValues().get(0);
            try {
                this.countResponse = Integer.parseInt(ObjectConverterUtil.convertToString((InputStream)blob.getBinaryStream()));
            }
            catch (IOException e) {
                throw new TranslatorException((Throwable)e);
            }
            catch (SQLException e) {
                throw new TranslatorException((Throwable)e);
            }
        } else {
            InputStream payload = this.executeQuery("GET", URI2, null, null, new HttpStatusCode[]{HttpStatusCode.OK, HttpStatusCode.NO_CONTENT, HttpStatusCode.NOT_FOUND});
            this.response = new ODataResponse(payload, ODataMetadataProcessor.ODataType.ENTITY_COLLECTION, this.visitor.getODataQuery().getRootDocument()){

                @Override
                public InputStream nextBatch(URI uri) throws TranslatorException {
                    return ODataQueryExecution.this.executeSkipToken(uri, URI2.toString(), new HttpStatusCode[]{HttpStatusCode.OK, HttpStatusCode.NO_CONTENT, HttpStatusCode.NOT_FOUND});
                }
            };
        }
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        Map<String, Object> row;
        if (this.isCount && this.countResponse != -1) {
            int count = this.countResponse;
            this.countResponse = -1;
            return Arrays.asList(count);
        }
        if (this.response != null && (row = this.response.getNext()) != null) {
            return this.buildRow(this.visitor.getODataQuery().getRootDocument().getTable(), this.visitor.getProjectedColumns(), this.expectedColumnTypes, row);
        }
        return null;
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }
}

