/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata4;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.olingo.client.api.serialization.ODataDeserializerException;
import org.apache.olingo.client.core.serialization.JsonDeserializer;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Property;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.document.Document;
import org.teiid.translator.document.DocumentNode;
import org.teiid.translator.odata4.ODataDocument;
import org.teiid.translator.odata4.ODataMetadataProcessor;

public abstract class ODataResponse {
    private URI nextUri;
    private Iterator<ODataDocument> results;
    private ODataMetadataProcessor.ODataType resultsType;
    private List<Map<String, Object>> currentDocumentRows;
    private DocumentNode rootNode;

    public ODataResponse(InputStream payload, ODataMetadataProcessor.ODataType type, DocumentNode rootNode) throws TranslatorException {
        this.resultsType = type;
        this.rootNode = rootNode;
        this.results = this.parsePayload(payload);
    }

    private Iterator<ODataDocument> parsePayload(InputStream payload) throws TranslatorException {
        try {
            JsonDeserializer parser = new JsonDeserializer(false);
            if (this.resultsType == ODataMetadataProcessor.ODataType.ENTITY) {
                Entity entity = (Entity)parser.toEntity(payload).getPayload();
                ODataDocument document = ODataDocument.createDocument(entity);
                return Arrays.asList(document).iterator();
            }
            if (this.resultsType == ODataMetadataProcessor.ODataType.ENTITY_COLLECTION) {
                EntityCollection entityCollection = (EntityCollection)parser.toEntitySet(payload).getPayload();
                this.nextUri = entityCollection.getNext();
                ArrayList<ODataDocument> documents = new ArrayList<ODataDocument>();
                for (Entity entity : entityCollection.getEntities()) {
                    documents.add(ODataDocument.createDocument(entity));
                }
                return documents.iterator();
            }
            Property property = (Property)parser.toProperty(payload).getPayload();
            if (property.isCollection()) {
                ArrayList<ODataDocument> documents = new ArrayList<ODataDocument>();
                for (Object obj : property.asCollection()) {
                    ComplexValue complexValue = (ComplexValue)obj;
                    documents.add(ODataDocument.createDocument(complexValue));
                }
                return documents.iterator();
            }
            ODataDocument document = ODataDocument.createDocument(property.asComplex());
            return Arrays.asList(document).iterator();
        }
        catch (ODataDeserializerException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public Map<String, Object> getNext() throws TranslatorException {
        if (this.currentDocumentRows != null && !this.currentDocumentRows.isEmpty()) {
            return this.currentDocumentRows.remove(0);
        }
        if (this.results.hasNext()) {
            this.currentDocumentRows = this.rootNode.tuples((Document)this.results.next());
            return this.getNext();
        }
        if (this.nextUri != null) {
            this.results = this.fetchSkipToken(this.nextUri);
            return this.getNext();
        }
        return null;
    }

    private Iterator<ODataDocument> fetchSkipToken(URI uri) throws TranslatorException {
        return this.parsePayload(this.nextBatch(uri));
    }

    public abstract InputStream nextBatch(URI var1) throws TranslatorException;
}

