/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata4;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.client.api.Configuration;
import org.apache.olingo.client.api.serialization.ODataSerializerException;
import org.apache.olingo.client.core.ConfigurationImpl;
import org.apache.olingo.client.core.serialization.JsonSerializer;
import org.apache.olingo.client.core.uri.URIBuilderImpl;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.format.ContentType;
import org.teiid.language.Condition;
import org.teiid.metadata.Column;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.document.DocumentNode;
import org.teiid.translator.odata4.ODataDocumentNode;
import org.teiid.translator.odata4.ODataExecutionFactory;
import org.teiid.translator.odata4.ODataQuery;

public class ODataUpdateQuery
extends ODataQuery {
    private Map<String, Object> keys = new LinkedHashMap<String, Object>();
    private Map<String, Object> expandKeys = new LinkedHashMap<String, Object>();
    private List<Property> payloadProperties = new ArrayList<Property>();
    private Condition condition;

    public ODataUpdateQuery(ODataExecutionFactory executionFactory, RuntimeMetadata metadata) {
        super(executionFactory, metadata);
    }

    public String buildInsertURL(String serviceRoot) throws TranslatorException {
        URIBuilderImpl uriBuilder = new URIBuilderImpl((Configuration)new ConfigurationImpl(), serviceRoot);
        uriBuilder.appendEntitySetSegment(this.rootDocument.getName());
        if (this.keys.size() == 1) {
            uriBuilder.appendKeySegment(this.keys.values().iterator().next());
        } else if (!this.keys.isEmpty()) {
            uriBuilder.appendKeySegment(this.keys);
        }
        if (!this.complexTables.isEmpty()) {
            uriBuilder.appendPropertySegment(((ODataDocumentNode)((Object)this.complexTables.get(0))).getName());
        }
        if (!this.expandTables.isEmpty()) {
            uriBuilder.appendPropertySegment(((ODataDocumentNode)((Object)this.expandTables.get(0))).getName());
        }
        URI uri = uriBuilder.build();
        return uri.toString();
    }

    public String getInsertMethod() {
        String method = "POST";
        if (!this.complexTables.isEmpty()) {
            method = ((ODataDocumentNode)((Object)this.complexTables.get(0))).isCollection() ? "PUT" : "PATCH";
        }
        if (!this.expandTables.isEmpty() && !((ODataDocumentNode)((Object)this.expandTables.get(0))).isCollection()) {
            method = "PUT";
        }
        return method;
    }

    public String getPayload(Entity parentEntity) throws TranslatorException {
        JsonSerializer serializer = new JsonSerializer(false, ContentType.JSON_FULL_METADATA);
        StringWriter writer = new StringWriter();
        try {
            if (!this.complexTables.isEmpty()) {
                Table table = ((ODataDocumentNode)((Object)this.complexTables.get(0))).getTable();
                Property complexProperty = new Property();
                complexProperty.setName(this.getName(table));
                complexProperty.setType(table.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}NameInSchema", false));
                ComplexValue value = new ComplexValue();
                for (Property p : this.payloadProperties) {
                    value.getValue().add(p);
                }
                if (((ODataDocumentNode)((Object)this.complexTables.get(0))).isCollection()) {
                    complexProperty.setValue(ValueType.COLLECTION_COMPLEX, Arrays.asList(value));
                } else {
                    complexProperty.setValue(ValueType.COMPLEX, (Object)value);
                }
                serializer.write((Writer)writer, (Object)complexProperty);
            } else if (!this.expandTables.isEmpty()) {
                Table table = ((ODataDocumentNode)((Object)this.expandTables.get(0))).getTable();
                Entity entity = new Entity();
                entity.setType(table.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}NameInSchema", false));
                for (Property p : this.payloadProperties) {
                    entity.addProperty(p);
                }
                serializer.write((Writer)writer, (Object)entity);
            } else {
                Entity entity = new Entity();
                entity.setType(this.rootDocument.getTable().getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}NameInSchema", false));
                for (Property p : this.payloadProperties) {
                    entity.addProperty(p);
                }
                if (parentEntity != null) {
                    List keys = this.rootDocument.getTable().getPrimaryKey().getColumns();
                    for (Column key : keys) {
                        entity.addProperty(parentEntity.getProperty(key.getName()));
                    }
                }
                serializer.write((Writer)writer, (Object)entity);
            }
        }
        catch (ODataSerializerException e) {
            throw new TranslatorException((Throwable)e);
        }
        return writer.toString();
    }

    private void buildKeyColumns(Table parentTable, Table childTable, String columnName, Object value) {
        if (parentTable.equals((Object)childTable)) {
            return;
        }
        for (ForeignKey fk : childTable.getForeignKeys()) {
            if (!fk.getReferenceTableName().equals(parentTable.getName())) continue;
            List columns = fk.getColumns();
            for (int i = 0; i < columns.size(); ++i) {
                Column fkColumn = (Column)columns.get(i);
                if (!fkColumn.getName().equals(columnName)) continue;
                this.keys.put((String)fk.getReferenceColumns().get(i), value);
            }
        }
        if (!this.expandTables.isEmpty() && childTable.getPrimaryKey() != null) {
            for (Column column : childTable.getPrimaryKey().getColumns()) {
                if (this.isPseudo(column) || !column.getName().equals(columnName)) continue;
                this.expandKeys.put(columnName, value);
            }
        }
    }

    private boolean isPseudo(Column column) {
        String property = column.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}PSEUDO", false);
        return property != null;
    }

    private String getName(Table table) {
        if (table.getNameInSource() != null) {
            return table.getNameInSource();
        }
        return table.getName();
    }

    public void addInsertProperty(Column column, String type, Object value) {
        this.buildKeyColumns(this.getRootDocument().getTable(), (Table)column.getParent(), column.getName(), value);
        this.addUpdateProperty(column, type, value);
    }

    public void addUpdateProperty(Column column, String type, Object value) {
        boolean collection = value instanceof List;
        if (!this.isPseudo(column)) {
            this.payloadProperties.add(new Property(type, column.getName(), collection ? ValueType.COLLECTION_PRIMITIVE : ValueType.PRIMITIVE, value));
        }
    }

    public void setCondition(Condition where) {
        this.condition = where;
    }

    public String buildUpdateSelectionURL(String serviceRoot) throws TranslatorException {
        String filter;
        URIBuilderImpl uriBuilder = new URIBuilderImpl((Configuration)new ConfigurationImpl(), serviceRoot);
        uriBuilder.appendEntitySetSegment(this.rootDocument.getName());
        List selection = this.rootDocument.getIdentityColumns();
        uriBuilder.select(selection.toArray(new String[selection.size()]));
        if (!this.expandTables.isEmpty()) {
            ODataDocumentNode use = (ODataDocumentNode)((Object)this.expandTables.get(0));
            List keys = use.getIdentityColumns();
            for (String key : keys) {
                use.appendSelect(key);
            }
            uriBuilder.expandWithOptions(use.getName(), use.getOptions());
        }
        if ((filter = this.processFilter(this.condition)) != null) {
            uriBuilder.filter(filter);
        }
        URI uri = uriBuilder.build();
        return uri.toString();
    }

    public String getUpdateMethod() {
        String method = "PATCH";
        if (!this.complexTables.isEmpty()) {
            method = ((ODataDocumentNode)((Object)this.complexTables.get(0))).isCollection() ? "PUT" : "PATCH";
        }
        if (!this.expandTables.isEmpty() && !((ODataDocumentNode)((Object)this.expandTables.get(0))).isCollection()) {
            method = "PUT";
        }
        return method;
    }

    public String buildUpdateURL(String serviceRoot, List<?> row) {
        URIBuilderImpl uriBuilder = new URIBuilderImpl((Configuration)new ConfigurationImpl(), serviceRoot);
        uriBuilder.appendEntitySetSegment(this.rootDocument.getName());
        List selection = this.rootDocument.getIdentityColumns();
        if (selection.size() == 1) {
            uriBuilder.appendKeySegment(row.get(0));
        } else if (!selection.isEmpty()) {
            LinkedHashMap keys = new LinkedHashMap();
            for (int i = 0; i < selection.size(); ++i) {
                keys.put(selection.get(i), row.get(i));
            }
            uriBuilder.appendKeySegment(keys);
        }
        if (!this.complexTables.isEmpty()) {
            uriBuilder.appendPropertySegment(((ODataDocumentNode)((Object)this.complexTables.get(0))).getName());
        }
        if (!this.expandTables.isEmpty()) {
            uriBuilder.appendPropertySegment(((ODataDocumentNode)((Object)this.expandTables.get(0))).getName());
            DocumentNode use = (DocumentNode)this.expandTables.get(0);
            List expandSelection = use.getIdentityColumns();
            LinkedHashMap keys = new LinkedHashMap();
            for (int i = 0; i < expandSelection.size(); ++i) {
                keys.put(expandSelection.get(i), row.get(selection.size() + i));
            }
            if (!keys.isEmpty()) {
                uriBuilder.appendKeySegment(keys);
            }
        }
        URI uri = uriBuilder.build();
        return uri.toString();
    }
}

