/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.loopback;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.Command;
import org.teiid.language.QueryExpression;
import org.teiid.logging.LogManager;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.loopback.LoopbackExecutionFactory;

public class LoopbackExecution
implements UpdateExecution,
ProcedureExecution {
    private LoopbackExecutionFactory config;
    private Command command;
    private String staticStringValue = "";
    private Random randomNumber = new Random();
    private List<Object> row;
    private List<Class<?>> types;
    private boolean waited = false;
    private int rowsReturned = 0;
    private int rowsNeeded = 1;
    private BigInteger rowNumber = BigInteger.ZERO;
    public static final Long DAY_SECONDS = 86400L;
    private static final int DATE_PERIOD = 0x22229D;

    public LoopbackExecution(Command command, LoopbackExecutionFactory config) {
        this.config = config;
        this.command = command;
        this.staticStringValue = LoopbackExecution.constructIncrementedString(config.getCharacterValuesSize());
    }

    public static String constructIncrementedString(int characterValuesSize) {
        StringBuffer alphaString = new StringBuffer();
        int genAlphaSize = characterValuesSize;
        int currentChar = 65;
        while (genAlphaSize-- != 0) {
            alphaString.append((char)currentChar);
            if (currentChar == 90) {
                currentChar = 65;
                continue;
            }
            currentChar = (char)(currentChar + 1);
        }
        return alphaString.toString();
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        if (this.config.getWaitTime() > 0 && !this.waited) {
            int randomTimeToWait = this.randomNumber.nextInt(this.config.getWaitTime());
            if (this.config.getPollIntervalInMilli() >= 0L && (long)randomTimeToWait > this.config.getPollIntervalInMilli()) {
                this.waited = true;
                DataNotAvailableException dnae = new DataNotAvailableException((long)randomTimeToWait);
                dnae.setStrict(true);
                throw dnae;
            }
            try {
                Thread.sleep(randomTimeToWait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.waited = true;
        }
        List<Object> resultRow = this.row;
        if (this.rowsReturned < this.rowsNeeded && resultRow.size() > 0) {
            ++this.rowsReturned;
            if (this.config.getIncrementRows()) {
                this.rowNumber = this.rowNumber.add(BigInteger.ONE);
                this.generateRow();
            }
            return resultRow;
        }
        return null;
    }

    public void execute() throws TranslatorException {
        QueryExpression queryCommand;
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object)("Loopback executing command: " + this.command));
        if (this.config.isThrowError()) {
            throw new TranslatorException("Failing because Error=true");
        }
        this.rowsNeeded = this.config.getRowCount();
        if (this.command instanceof QueryExpression && (queryCommand = (QueryExpression)this.command).getLimit() != null) {
            this.rowsNeeded = queryCommand.getLimit().getRowLimit();
        }
        this.determineOutputTypes();
        this.generateRow();
    }

    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
        return new int[]{0};
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        Call proc = (Call)this.command;
        int count = proc.getReturnType() != null ? 1 : 0;
        for (Argument param : proc.getArguments()) {
            if (param.getDirection() != Argument.Direction.INOUT && param.getDirection() != Argument.Direction.OUT) continue;
            ++count;
        }
        return Arrays.asList(new Object[count]);
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }

    private void determineOutputTypes() {
        if (this.command instanceof QueryExpression) {
            QueryExpression query = (QueryExpression)this.command;
            this.types = Arrays.asList(query.getColumnTypes());
            return;
        }
        if (this.command instanceof Call) {
            this.types = Arrays.asList(((Call)this.command).getResultSetColumnTypes());
            return;
        }
        this.types = new ArrayList(1);
        this.types.add(Integer.class);
    }

    private void generateRow() {
        ArrayList<Object> newRow = new ArrayList<Object>(this.types.size());
        String incrementedString = LoopbackExecution.incrementString(this.staticStringValue, this.rowNumber);
        for (Class<?> type : this.types) {
            Object val = this.getVal(incrementedString, type);
            newRow.add(val);
        }
        this.row = newRow;
    }

    Object getVal(String incrementedString, Class<?> type) {
        Object val;
        if (type.equals(Integer.class)) {
            val = this.rowNumber.intValue();
        } else if (type.equals(Short.class)) {
            val = this.rowNumber.shortValue();
        } else if (type.equals(Long.class)) {
            val = this.rowNumber.longValue();
        } else if (type.equals(Float.class)) {
            val = Float.valueOf(this.rowNumber.floatValue() / 10.0f);
        } else if (type.equals(Double.class)) {
            val = this.rowNumber.doubleValue() / 10.0;
        } else if (type.equals(Character.class)) {
            val = Character.valueOf((char)(((this.rowNumber.byteValue() & 0xFF) + 2) % 26 + 97));
        } else if (type.equals(Byte.class)) {
            val = this.rowNumber.byteValue();
        } else if (type.equals(Boolean.class)) {
            val = this.rowNumber.intValue() % 2 != 0;
        } else if (type.equals(BigInteger.class)) {
            val = this.rowNumber;
        } else if (type.equals(BigDecimal.class)) {
            val = new BigDecimal(this.rowNumber, 1);
        } else if (type.equals(Date.class)) {
            val = new Date(DAY_SECONDS * 1000L * (long)(this.rowNumber.intValue() % 0x22229D));
        } else if (type.equals(Time.class)) {
            val = new Time((long)this.rowNumber.intValue() % DAY_SECONDS * 1000L);
        } else if (type.equals(Timestamp.class)) {
            val = new Timestamp(this.rowNumber.longValue());
        } else if (type.equals(TypeFacility.RUNTIME_TYPES.CLOB)) {
            val = this.config.getTypeFacility().convertToRuntimeType((Object)incrementedString.toCharArray());
        } else if (type.equals(TypeFacility.RUNTIME_TYPES.BLOB) || type.equals(TypeFacility.RUNTIME_TYPES.VARBINARY)) {
            val = this.config.getTypeFacility().convertToRuntimeType((Object)incrementedString.getBytes());
        } else if (type.isArray()) {
            val = Array.newInstance(type.getComponentType(), 1);
            Array.set(val, 0, this.getVal(incrementedString, type.getComponentType()));
        } else {
            val = incrementedString;
        }
        return val;
    }

    public static String incrementString(String string, BigInteger number) {
        String numberString = number.toString();
        if (number.equals(BigInteger.ZERO)) {
            return string;
        }
        return string.substring(0, string.length() - numberString.length()) + numberString;
    }
}

