/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.teiid.connector.DataPlugin;
import org.teiid.core.BundleUtil;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.DuplicateRecordException;

public class ColumnSet<T extends AbstractMetadataRecord>
extends AbstractMetadataRecord {
    private static final long serialVersionUID = -1185104601468519829L;
    private List<Column> columns;
    private T parent;
    private transient Map<String, Column> columnMap;

    public List<Column> getColumns() {
        return this.columns;
    }

    public Column getColumnByName(String name) {
        if (this.columns == null || name == null) {
            return null;
        }
        Map<String, Column> map = this.columnMap;
        if (map == null) {
            map = new TreeMap<String, Column>(String.CASE_INSENSITIVE_ORDER);
            for (Column c : this.columns) {
                map.put(c.getName(), c);
            }
            this.columnMap = map;
        }
        return map.get(name);
    }

    public void addColumn(Column column) {
        if (this.columns == null) {
            this.columns = new ArrayList<Column>();
        }
        if (this.getColumnByName(column.getName()) != null) {
            throw new DuplicateRecordException((BundleUtil.Event)DataPlugin.Event.TEIID60016, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60016, new Object[]{this.getFullName() + '.' + column.getName()}));
        }
        this.columns.add(column);
        Map<String, Column> map = this.columnMap;
        if (map != null) {
            map.put(column.getName(), column);
        }
    }

    public void removeColumn(Column column) {
        if (this.columns == null) {
            return;
        }
        this.columns.remove(column);
        Map<String, Column> map = this.columnMap;
        if (map != null) {
            map.remove(column.getName());
        }
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
        this.columnMap = null;
    }

    public T getParent() {
        return this.parent;
    }

    public void setParent(T parent) {
        this.parent = parent;
    }
}

