/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.rowset.serial.SerialBlob;
import org.teiid.common.buffer.AutoCleanupUtil;
import org.teiid.common.buffer.FileStore;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.BaseClobType;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.Streamable;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.symbol.Expression;

public class LobManager {
    private Map<String, LobHolder> lobReferences = Collections.synchronizedMap(new HashMap());
    private boolean inlineLobs = true;
    private int maxMemoryBytes = DataTypeManager.MAX_LOB_MEMORY_BYTES;
    private int[] lobIndexes;
    private FileStore lobStore;

    public LobManager(int[] lobIndexes, FileStore lobStore) {
        this.lobIndexes = lobIndexes;
        this.lobStore = lobStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LobManager clone() {
        LobManager clone = new LobManager(this.lobIndexes, null);
        clone.inlineLobs = this.inlineLobs;
        clone.maxMemoryBytes = this.maxMemoryBytes;
        Map<String, LobHolder> map = this.lobReferences;
        synchronized (map) {
            for (Map.Entry<String, LobHolder> entry : this.lobReferences.entrySet()) {
                LobHolder lobHolder = new LobHolder(entry.getValue().lob);
                lobHolder.referenceCount = entry.getValue().referenceCount;
                clone.lobReferences.put(entry.getKey(), lobHolder);
            }
        }
        return clone;
    }

    public void setInlineLobs(boolean trackMemoryLobs) {
        this.inlineLobs = trackMemoryLobs;
    }

    public void setMaxMemoryBytes(int maxMemoryBytes) {
        this.maxMemoryBytes = maxMemoryBytes;
    }

    public void updateReferences(List<?> tuple, ReferenceMode mode) throws TeiidComponentException {
        block7: for (int i = 0; i < this.lobIndexes.length; ++i) {
            Object anObj = tuple.get(this.lobIndexes[i]);
            if (!(anObj instanceof Streamable)) continue;
            Streamable lob = (Streamable)anObj;
            String id = lob.getReferenceStreamId();
            LobHolder lobHolder = this.lobReferences.get(id);
            switch (mode) {
                case REMOVE: {
                    if (lobHolder == null) continue block7;
                    --lobHolder.referenceCount;
                    if (lobHolder.referenceCount >= 1) continue block7;
                    this.lobReferences.remove(id);
                    continue block7;
                }
                case ATTACH: {
                    if (lob.getReference() != null) continue block7;
                    if (lobHolder == null) {
                        throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30033, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30033, new Object[0]));
                    }
                    lob.setReference(lobHolder.lob.getReference());
                    continue block7;
                }
                case CREATE: {
                    try {
                        InputStreamFactory.StorageMode storageMode = InputStreamFactory.getStorageMode((Object)lob);
                        if (lob.getReferenceStreamId() == null || this.inlineLobs && (storageMode == InputStreamFactory.StorageMode.MEMORY || storageMode != InputStreamFactory.StorageMode.FREE && lob.length() * (long)(lob instanceof BaseClobType ? 2 : 1) <= (long)this.maxMemoryBytes)) {
                            lob.setReferenceStreamId(null);
                            if (!this.inlineLobs || storageMode != InputStreamFactory.StorageMode.OTHER) continue block7;
                            LobManager.persistLob(lob, null, null, true, this.maxMemoryBytes);
                            continue block7;
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    if (lob.getReference() == null) {
                        throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30034, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30034, new Object[0]));
                    }
                    if (lobHolder == null) {
                        this.lobReferences.put(id, new LobHolder(lob));
                        continue block7;
                    }
                    ++lobHolder.referenceCount;
                }
            }
        }
    }

    public Streamable<?> getLobReference(String id) throws TeiidComponentException {
        LobHolder lob = this.lobReferences.get(id);
        if (lob == null) {
            throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30035, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30035, new Object[0]));
        }
        return lob.lob;
    }

    public static int[] getLobIndexes(List<? extends Expression> expressions) {
        if (expressions == null) {
            return null;
        }
        int[] result = new int[expressions.size()];
        int resultIndex = 0;
        for (int i = 0; i < expressions.size(); ++i) {
            Expression expr = expressions.get(i);
            if (!DataTypeManager.isLOB(expr.getType()) && expr.getType() != DataTypeManager.DefaultDataClasses.OBJECT) continue;
            result[resultIndex++] = i;
        }
        if (resultIndex == 0) {
            return null;
        }
        return Arrays.copyOf(result, resultIndex);
    }

    public void persist() throws TeiidComponentException {
        byte[] bytes = new byte[16384];
        AutoCleanupUtil.setCleanupReference(this, this.lobStore);
        for (Map.Entry<String, LobHolder> entry : this.lobReferences.entrySet()) {
            this.detachLob(entry.getValue().lob, this.lobStore, bytes);
        }
    }

    public void detachLob(Streamable<?> lob, FileStore store, byte[] bytes) throws TeiidComponentException {
        if (InputStreamFactory.getStorageMode(lob) != InputStreamFactory.StorageMode.MEMORY) {
            LobManager.persistLob(lob, store, bytes, this.inlineLobs, this.maxMemoryBytes);
        }
    }

    public static void persistLob(Streamable<?> lob, final FileStore store, byte[] bytes, boolean inlineLobs, int maxMemoryBytes) throws TeiidComponentException {
        block16: {
            long byteLength = Integer.MAX_VALUE;
            try {
                byteLength = lob.length() * (long)(lob instanceof BaseClobType ? 2 : 1);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (lob.getReferenceStreamId() == null || inlineLobs && byteLength <= (long)maxMemoryBytes) {
                    lob.setReferenceStreamId(null);
                    if (InputStreamFactory.getStorageMode(lob) == InputStreamFactory.StorageMode.MEMORY) {
                        return;
                    }
                    if (lob instanceof BlobType) {
                        BlobType b = (BlobType)lob;
                        byte[] blobBytes = b.getBytes(1L, (int)byteLength);
                        b.setReference((Object)new SerialBlob(blobBytes));
                    } else if (lob instanceof BaseClobType) {
                        BaseClobType c = (BaseClobType)lob;
                        String s = "";
                        if (byteLength != 0L) {
                            s = c.getSubString(1L, (int)(byteLength >>> 1));
                        }
                        c.setReference((Object)new ClobImpl(s));
                    } else {
                        XMLType x = (XMLType)lob;
                        String s = x.getString();
                        x.setReference((Object)new SQLXMLImpl(s));
                    }
                    return;
                }
                InputStream is = null;
                is = lob instanceof BlobType ? new InputStreamFactory.BlobInputStreamFactory((Blob)lob).getInputStream() : (lob instanceof BaseClobType ? new InputStreamFactory.ClobInputStreamFactory((Clob)lob).getInputStream() : new InputStreamFactory.SQLXMLInputStreamFactory((SQLXML)lob).getInputStream());
                long offset = store.getLength();
                OutputStream fsos = store.createOutputStream();
                byteLength = ObjectConverterUtil.write((OutputStream)fsos, (InputStream)is, (byte[])bytes, (int)-1);
                final long lobOffset = offset;
                final long lobLength = byteLength;
                InputStreamFactory isf = new InputStreamFactory(){

                    public InputStream getInputStream() throws IOException {
                        return store.createInputStream(lobOffset, lobLength);
                    }

                    public InputStreamFactory.StorageMode getStorageMode() {
                        return InputStreamFactory.StorageMode.PERSISTENT;
                    }
                };
                isf.setLength(byteLength);
                if (lob instanceof BlobType) {
                    ((BlobType)lob).setReference((Object)new BlobImpl(isf));
                    break block16;
                }
                if (lob instanceof BaseClobType) {
                    long length = -1L;
                    try {
                        length = ((BaseClobType)lob).length();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    ((BaseClobType)lob).setReference((Object)new ClobImpl(isf, length));
                    break block16;
                }
                ((XMLType)lob).setReference((Object)new SQLXMLImpl(isf));
            }
            catch (SQLException e) {
                throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30037, (Throwable)e);
            }
            catch (IOException e) {
                throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30036, (Throwable)e);
            }
        }
    }

    public int getLobCount() {
        return this.lobReferences.size();
    }

    public void remove() {
        this.lobReferences.clear();
        this.lobStore.remove();
    }

    private static class LobHolder {
        Streamable<?> lob;
        int referenceCount = 1;

        public LobHolder(Streamable<?> lob) {
            this.lob = lob;
        }
    }

    public static enum ReferenceMode {
        ATTACH,
        CREATE,
        REMOVE;

    }
}

