/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.BaseLob;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.Streamable;

public final class SizeUtility {
    private static final int UNKNOWN_SIZE_BYTES = 1024;
    public static final int REFERENCE_SIZE = 8;
    private static Map<Class<?>, int[]> SIZE_ESTIMATES = new HashMap(128);
    private static Set<Class<?>> VARIABLE_SIZE_TYPES = new HashSet();
    private Class<?>[] types;
    private static ConcurrentHashMap<String, ClassStats> objectEstimates;

    public SizeUtility(Class<?>[] types) {
        this.types = types;
    }

    public long getBatchSize(boolean accountForValueCache, List<? extends List<?>> data) {
        int colLength = this.types.length;
        int rowLength = data.size();
        long size = 16L + SizeUtility.alignMemory(rowLength * 8);
        size += (long)rowLength * (48L + SizeUtility.alignMemory(colLength * 8));
        for (int col = 0; col < colLength; ++col) {
            Class<?> type = this.types[col];
            int rowsSampled = 0;
            int estimatedSize = 0;
            if (SizeUtility.isVariableSize(type)) {
                int row = 0;
                while (row < rowLength) {
                    ++rowsSampled;
                    estimatedSize = (int)((long)estimatedSize + SizeUtility.getSize(data.get(row).get(col), accountForValueCache));
                    row = row * 2 + 1;
                }
                size = (long)((float)size + (float)estimatedSize / (float)rowsSampled * (float)rowLength);
                continue;
            }
            size += (long)(SizeUtility.getSize(accountForValueCache, type) * rowLength);
        }
        return size;
    }

    public static boolean isVariableSize(Class<?> type) {
        return VARIABLE_SIZE_TYPES.contains(type) || type.isArray();
    }

    public static int getSize(boolean isValueCacheEnabled, Class<?> type) {
        int[] vals = SIZE_ESTIMATES.get(type);
        if (vals == null) {
            return 1024;
        }
        return vals[isValueCacheEnabled ? 0 : 1];
    }

    public static long getSize(Object obj, boolean accountForValueCache) {
        Class<?> clazz;
        block34: {
            if (obj == null) {
                return 0L;
            }
            clazz = obj.getClass();
            if (clazz == DataTypeManager.DefaultDataClasses.STRING) {
                int length = ((String)obj).length();
                if (length > 0) {
                    return SizeUtility.alignMemory(40 + 2 * length);
                }
                return 40L;
            }
            if (clazz == DataTypeManager.DefaultDataClasses.VARBINARY) {
                int length = ((BinaryType)obj).getLength();
                if (length > 0) {
                    return SizeUtility.alignMemory(16 + length);
                }
                return 16L;
            }
            if (clazz == DataTypeManager.DefaultDataClasses.BIG_DECIMAL) {
                int bitLength = ((BigDecimal)obj).unscaledValue().bitLength();
                long result = 88L + SizeUtility.alignMemory(4 + (bitLength >> 3));
                return result;
            }
            if (clazz == DataTypeManager.DefaultDataClasses.BIG_INTEGER) {
                int bitLength = ((BigInteger)obj).bitLength();
                long result = 40L + SizeUtility.alignMemory(4 + (bitLength >> 3));
                return result;
            }
            if (obj instanceof Iterable) {
                Iterable i = (Iterable)obj;
                long total = 16L;
                for (Object object : i) {
                    total += SizeUtility.getSize(object, false) + 8L;
                }
                return total;
            }
            if (clazz.isArray() || obj instanceof ArrayImpl) {
                Class<?> componentType;
                int overhead = 0;
                if (obj instanceof ArrayImpl) {
                    obj = ((ArrayImpl)obj).getValues();
                    clazz = obj.getClass();
                    overhead += 16;
                }
                if (!(componentType = clazz.getComponentType()).isPrimitive()) {
                    Object[] rows = obj;
                    long total = (long)(overhead + 16) + SizeUtility.alignMemory(rows.length * 8);
                    for (int i = 0; i < rows.length; ++i) {
                        total += SizeUtility.getSize(rows[i], false);
                    }
                    return total;
                }
                int length = Array.getLength(obj);
                int primitiveSize = 8;
                if (componentType == Boolean.TYPE) {
                    primitiveSize = 4;
                } else if (componentType == Byte.TYPE) {
                    primitiveSize = 1;
                } else if (componentType == Short.TYPE) {
                    primitiveSize = 2;
                } else if (componentType == Integer.TYPE || componentType == Float.TYPE) {
                    primitiveSize = 4;
                }
                return (long)overhead + SizeUtility.alignMemory(length * primitiveSize) + 16L;
            }
            if (obj instanceof Streamable) {
                try {
                    Streamable s = (Streamable)obj;
                    Object o = s.getReference();
                    if (!(o instanceof BaseLob)) break block34;
                    InputStreamFactory isf = ((BaseLob)o).getStreamFactory();
                    if (isf.getStorageMode() == InputStreamFactory.StorageMode.MEMORY) {
                        long length = isf.getLength();
                        if (length >= 0L) {
                            return 40L + SizeUtility.alignMemory(length);
                        }
                    } else if (isf.getStorageMode() == InputStreamFactory.StorageMode.PERSISTENT) {
                        long length = isf.getLength();
                        return 40L + SizeUtility.alignMemory(Math.min((long)DataTypeManager.MAX_LOB_MEMORY_BYTES, length));
                    }
                }
                catch (Exception s) {}
            } else {
                if (SIZE_ESTIMATES.containsKey(clazz)) {
                    return SizeUtility.getSize(accountForValueCache, clazz);
                }
                if (obj instanceof Serializable) {
                    int samples;
                    ClassStats stats = objectEstimates.get(clazz.getName());
                    if (stats == null) {
                        stats = new ClassStats();
                        objectEstimates.put(clazz.getName(), stats);
                    }
                    if ((samples = stats.samples.getAndIncrement()) < 1000 || (samples & 0x3FF) == 1023) {
                        try {
                            DummyOutputStream os = new DummyOutputStream();
                            ObjectOutputStream oos = new ObjectOutputStream(os){

                                @Override
                                protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
                                }

                                @Override
                                protected void writeStreamHeader() throws IOException {
                                }
                            };
                            oos.writeObject(obj);
                            oos.close();
                            int result = (int)SizeUtility.alignMemory(os.getBytes() * 3);
                            stats.averageSize = result > stats.averageSize ? (stats.averageSize + result * 2) / 3 : (stats.averageSize + result) / 2;
                            return result;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return stats.averageSize;
                }
            }
        }
        return SizeUtility.getSize(accountForValueCache, clazz);
    }

    private static long alignMemory(long numBytes) {
        long remainder = numBytes % 8L;
        if (remainder != 0L) {
            numBytes += 8L - remainder;
        }
        return numBytes;
    }

    static {
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.STRING, new int[]{100, Math.max(100, DataTypeManager.nextPowOf2((int)(DataTypeManager.MAX_STRING_LENGTH / 16)))});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.VARBINARY, new int[]{100, Math.max(100, DataTypeManager.MAX_VARBINARY_BYTES / 32)});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.DATE, new int[]{20, 28});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.TIME, new int[]{20, 28});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.TIMESTAMP, new int[]{20, 28});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.LONG, new int[]{12, 16});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.DOUBLE, new int[]{12, 16});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.INTEGER, new int[]{6, 12});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.FLOAT, new int[]{6, 12});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.CHAR, new int[]{4, 10});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.SHORT, new int[]{4, 10});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.OBJECT, new int[]{1024, 1024});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.NULL, new int[]{0, 0});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.BYTE, new int[]{1, 1});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.BOOLEAN, new int[]{1, 1});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.BIG_INTEGER, new int[]{75, 100});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.BIG_DECIMAL, new int[]{150, 200});
        VARIABLE_SIZE_TYPES.add(DataTypeManager.DefaultDataClasses.STRING);
        VARIABLE_SIZE_TYPES.add(DataTypeManager.DefaultDataClasses.VARBINARY);
        VARIABLE_SIZE_TYPES.add(DataTypeManager.DefaultDataClasses.OBJECT);
        VARIABLE_SIZE_TYPES.add(DataTypeManager.DefaultDataClasses.BIG_INTEGER);
        VARIABLE_SIZE_TYPES.add(DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
        VARIABLE_SIZE_TYPES.add(DataTypeManager.DefaultDataClasses.BLOB);
        VARIABLE_SIZE_TYPES.add(DataTypeManager.DefaultDataClasses.CLOB);
        VARIABLE_SIZE_TYPES.add(DataTypeManager.DefaultDataClasses.XML);
        VARIABLE_SIZE_TYPES.add(DataTypeManager.DefaultDataClasses.GEOMETRY);
        objectEstimates = new ConcurrentHashMap();
    }

    private static class ClassStats {
        AtomicInteger samples = new AtomicInteger();
        volatile int averageSize = 1024;

        private ClassStats() {
        }
    }

    private static final class DummyOutputStream
    extends OutputStream {
        int bytes;

        private DummyOutputStream() {
        }

        @Override
        public void write(int arg0) throws IOException {
            ++this.bytes;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.bytes += len;
        }

        public int getBytes() {
            return this.bytes;
        }
    }
}

